/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.swing;

import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.listener.awt.AWTListChangeListenerWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListModelAdapter
extends AbstractListModel {
    protected ListValueModel<?> listHolder;
    protected int listSize = 0;
    protected final ListChangeListener listChangeListener = this.buildListChangeListener();
    private static final long serialVersionUID = 1L;

    private ListModelAdapter() {
    }

    public ListModelAdapter(ListValueModel<?> listHolder) {
        this();
        this.setModel(listHolder);
    }

    public ListModelAdapter(CollectionValueModel<?> collectionHolder) {
        this();
        this.setModel(collectionHolder);
    }

    protected ListChangeListener buildListChangeListener() {
        return new AWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    protected ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                ListModelAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                ListModelAdapter.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                ListModelAdapter.this.itemsReplaced(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                ListModelAdapter.this.itemsMoved(event);
            }

            public void listCleared(ListClearEvent event) {
                ListModelAdapter.this.listCleared();
            }

            public void listChanged(ListChangeEvent event) {
                ListModelAdapter.this.listChanged();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    @Override
    public int getSize() {
        return this.listHolder.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.listHolder.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.hasNoListDataListeners()) {
            this.engageModel();
            this.listSize = this.listHolder.size();
        }
        super.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        super.removeListDataListener(l);
        if (this.hasNoListDataListeners()) {
            this.disengageModel();
            this.listSize = 0;
        }
    }

    public ListValueModel<?> model() {
        return this.listHolder;
    }

    public void setModel(ListValueModel<?> listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        boolean hasListeners = this.hasListDataListeners();
        if (hasListeners) {
            this.disengageModel();
        }
        this.listHolder = listHolder;
        if (hasListeners) {
            this.engageModel();
            this.listChanged();
        }
    }

    public void setModel(CollectionValueModel<?> collectionHolder) {
        this.setModel(new CollectionListValueModelAdapter(collectionHolder));
    }

    protected boolean hasNoListDataListeners() {
        return this.getListDataListeners().length == 0;
    }

    protected boolean hasListDataListeners() {
        return !this.hasNoListDataListeners();
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    protected void itemsAdded(ListAddEvent event) {
        int start = event.getIndex();
        int end = start + event.getItemsSize() - 1;
        this.fireIntervalAdded(this, start, end);
        this.listSize += event.getItemsSize();
    }

    protected void itemsRemoved(ListRemoveEvent event) {
        int start = event.getIndex();
        int end = start + event.getItemsSize() - 1;
        this.fireIntervalRemoved(this, start, end);
        this.listSize -= event.getItemsSize();
    }

    protected void itemsReplaced(ListReplaceEvent event) {
        int start = event.getIndex();
        int end = start + event.getItemsSize() - 1;
        this.fireContentsChanged(this, start, end);
    }

    protected void itemsMoved(ListMoveEvent event) {
        int start = Math.min(event.getSourceIndex(), event.getTargetIndex());
        int end = Math.max(event.getSourceIndex(), event.getTargetIndex()) + event.getLength() - 1;
        this.fireContentsChanged(this, start, end);
    }

    protected void listCleared() {
        if (this.listSize != 0) {
            this.fireIntervalRemoved(this, 0, this.listSize - 1);
            this.listSize = 0;
        }
    }

    protected void listChanged() {
        if (this.listSize != 0) {
            this.fireIntervalRemoved(this, 0, this.listSize - 1);
        }
        this.listSize = this.listHolder.size();
        if (this.listSize != 0) {
            this.fireIntervalAdded(this, 0, this.listSize - 1);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.listHolder);
    }
}

