/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.AbstractPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyValueModelWrapper<V>
extends AbstractPropertyValueModel {
    protected final PropertyValueModel<? extends V> valueModel;
    protected final PropertyChangeListener valueListener;

    protected PropertyValueModelWrapper(PropertyValueModel<? extends V> valueModel) {
        if (valueModel == null) {
            throw new NullPointerException();
        }
        this.valueModel = valueModel;
        this.valueListener = this.buildValueListener();
    }

    protected PropertyChangeListener buildValueListener() {
        return new ValueListener();
    }

    @Override
    protected void engageModel() {
        this.valueModel.addPropertyChangeListener("value", this.valueListener);
    }

    @Override
    protected void disengageModel() {
        this.valueModel.removePropertyChangeListener("value", this.valueListener);
    }

    protected void wrappedValueChanged(PropertyChangeEvent event) {
        this.wrappedValueChanged(event.getOldValue(), event.getNewValue());
    }

    protected void wrappedValueChanged(V oldValue, V newValue) {
        this.wrappedValueChanged(newValue);
    }

    protected void wrappedValueChanged(V newValue) {
        throw new RuntimeException("This method was not overridden.");
    }

    class ValueListener
    extends PropertyChangeAdapter {
        ValueListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            PropertyValueModelWrapper.this.wrappedValueChanged(event);
        }
    }
}

