/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import org.eclipse.jpt.common.utility.collection.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayStack<E>
implements Stack<E>,
Cloneable,
Serializable {
    private ArrayList<E> elements;
    private static final long serialVersionUID = 1L;

    public ArrayStack() {
        this(10);
    }

    public ArrayStack(int initialCapacity) {
        this.elements = new ArrayList(initialCapacity);
    }

    public ArrayStack(Collection<? extends E> collection) {
        this.elements = new ArrayList<E>(collection);
    }

    @Override
    public void push(E element) {
        this.elements.add(element);
    }

    @Override
    public E pop() {
        try {
            return this.elements.remove(this.elements.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    @Override
    public E peek() {
        try {
            return this.elements.get(this.elements.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public ArrayStack<E> clone() {
        try {
            ArrayList list;
            ArrayStack clone = (ArrayStack)super.clone();
            clone.elements = list = (ArrayList)this.elements.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.elements.toString();
    }
}

