/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.preferences;

import com.ibm.icu.text.Collator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xsl.ui.internal.Messages;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLSyntaxColoringPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String SYNTAXCOLORING_XSL = "syntaxcoloring.xsl";
    private static final String XSLFILES_DIR = "xslfiles";
    private Button bold;
    private Label foregroundLabel;
    private Label backgroundLabel;
    private Button clearStyle;
    private Map contextToXSLStyleMap;
    private Color defaultForeground = null;
    private Color defaultBackground = null;
    private IStructuredDocument document;
    private ColorSelector foregroundColorEditor;
    private ColorSelector backgroundColorEditor;
    private Button italic;
    private OverlayPreferenceStore overlayStore;
    private Button strike;
    private Collection<String> stylePreferenceKeys;
    private StructuredViewer stylesViewer = null;
    private Map styleToDescriptionMap;
    private StyledText styledText;
    private Button underline;

    private void activate(String namedStyle) {
        Color foreground = this.defaultForeground;
        Color background = this.defaultBackground;
        if (namedStyle == null) {
            this.clearStyle.setEnabled(false);
            this.bold.setEnabled(false);
            this.italic.setEnabled(false);
            this.strike.setEnabled(false);
            this.underline.setEnabled(false);
            this.foregroundLabel.setEnabled(false);
            this.backgroundLabel.setEnabled(false);
            this.foregroundColorEditor.setEnabled(false);
            this.backgroundColorEditor.setEnabled(false);
            this.bold.setSelection(false);
            this.italic.setSelection(false);
            this.strike.setSelection(false);
            this.underline.setSelection(false);
        } else {
            TextAttribute attribute = this.getAttributeFor(namedStyle);
            this.clearStyle.setEnabled(true);
            this.bold.setEnabled(true);
            this.italic.setEnabled(true);
            this.strike.setEnabled(true);
            this.underline.setEnabled(true);
            this.foregroundLabel.setEnabled(true);
            this.backgroundLabel.setEnabled(true);
            this.foregroundColorEditor.setEnabled(true);
            this.backgroundColorEditor.setEnabled(true);
            this.bold.setSelection((attribute.getStyle() & 1) != 0);
            this.italic.setSelection((attribute.getStyle() & 2) != 0);
            this.strike.setSelection((attribute.getStyle() & 0x20000000) != 0);
            this.underline.setSelection((attribute.getStyle() & 0x40000000) != 0);
            if (attribute.getForeground() != null) {
                foreground = attribute.getForeground();
            }
            if (attribute.getBackground() != null) {
                background = attribute.getBackground();
            }
        }
        this.foregroundColorEditor.setColorValue(foreground.getRGB());
        this.backgroundColorEditor.setColorValue(background.getRGB());
    }

    public void applyStyles() {
        if (this.styledText == null || this.styledText.isDisposed()) {
            return;
        }
        IStructuredDocumentRegion documentRegion = this.document.getFirstStructuredDocumentRegion();
        while (documentRegion != null) {
            ITextRegionList regions = documentRegion.getRegions();
            int i = 0;
            while (i < regions.size()) {
                TextAttribute attribute;
                ITextRegion currentRegion = regions.get(i);
                String namedStyle = null;
                if (this.contextToXSLStyleMap.containsKey(currentRegion.getType()) && (namedStyle = (String)this.contextToXSLStyleMap.get(currentRegion.getType())) != null && (attribute = this.getAttributeFor(namedStyle)) != null) {
                    StyleRange style = new StyleRange(documentRegion.getStartOffset(currentRegion), currentRegion.getTextLength(), attribute.getForeground(), attribute.getBackground(), attribute.getStyle());
                    style.strikeout = (attribute.getStyle() & 0x20000000) != 0;
                    style.underline = (attribute.getStyle() & 0x40000000) != 0;
                    this.styledText.setStyleRange(style);
                }
                ++i;
            }
            documentRegion = documentRegion.getNext();
        }
    }

    public Button createCheckbox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        return button;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(final Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.defaultForeground = parent.getDisplay().getSystemColor(24);
        this.defaultBackground = parent.getDisplay().getSystemColor(25);
        Composite pageComponent = this.createComposite(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComponent, "org.eclipse.wst.xml.ui.webx0062");
        Link link = new Link(pageComponent, 64);
        link.setText(Messages.XSLSyntaxColoringPage);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        GridData linkData = new GridData(4, 1, true, false, 2, 1);
        linkData.widthHint = 150;
        link.setLayoutData((Object)linkData);
        new Label(pageComponent, 0).setLayoutData((Object)new GridData());
        new Label(pageComponent, 0).setLayoutData((Object)new GridData());
        SashForm editor = new SashForm(pageComponent, 512);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.horizontalSpan = 2;
        editor.setLayoutData((Object)gridData2);
        SashForm top = new SashForm((Composite)editor, 256);
        Composite styleEditor = this.createComposite((Composite)top, 1);
        ((GridLayout)styleEditor.getLayout()).marginRight = 5;
        ((GridLayout)styleEditor.getLayout()).marginLeft = 0;
        this.createLabel(styleEditor, XMLUIMessages.SyntaxColoringPage_0);
        this.stylesViewer = this.createStylesViewer(styleEditor);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 0;
        Iterator iterator = this.styleToDescriptionMap.values().iterator();
        while (iterator.hasNext()) {
            gridData.widthHint = Math.max(gridData.widthHint, this.convertWidthInCharsToPixels(iterator.next().toString().length()));
        }
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        this.stylesViewer.getControl().setLayoutData((Object)gridData);
        Composite editingComposite = this.createComposite((Composite)top, 1);
        ((GridLayout)styleEditor.getLayout()).marginLeft = 5;
        this.createLabel(editingComposite, "");
        Button enabler = this.createCheckbox(editingComposite, XMLUIMessages.SyntaxColoringPage_2);
        enabler.setEnabled(false);
        enabler.setSelection(true);
        Composite editControls = this.createComposite(editingComposite, 2);
        ((GridLayout)editControls.getLayout()).marginLeft = 20;
        this.foregroundLabel = this.createLabel(editControls, SSEUIMessages.Foreground_UI_);
        ((GridData)this.foregroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.foregroundLabel.setEnabled(false);
        this.foregroundColorEditor = new ColorSelector(editControls);
        Button fForegroundColor = this.foregroundColorEditor.getButton();
        GridData gd = new GridData(1, 4, false, false);
        fForegroundColor.setLayoutData((Object)gd);
        this.foregroundColorEditor.setEnabled(false);
        this.backgroundLabel = this.createLabel(editControls, SSEUIMessages.Background_UI_);
        ((GridData)this.backgroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.backgroundLabel.setEnabled(false);
        this.backgroundColorEditor = new ColorSelector(editControls);
        Button fBackgroundColor = this.backgroundColorEditor.getButton();
        gd = new GridData(1, 4, false, false);
        fBackgroundColor.setLayoutData((Object)gd);
        this.backgroundColorEditor.setEnabled(false);
        this.bold = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_3);
        this.bold.setEnabled(false);
        ((GridData)this.bold.getLayoutData()).horizontalSpan = 2;
        this.italic = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_4);
        this.italic.setEnabled(false);
        ((GridData)this.italic.getLayoutData()).horizontalSpan = 2;
        this.strike = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_5);
        this.strike.setEnabled(false);
        ((GridData)this.strike.getLayoutData()).horizontalSpan = 2;
        this.underline = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_6);
        this.underline.setEnabled(false);
        ((GridData)this.underline.getLayoutData()).horizontalSpan = 2;
        this.clearStyle = new Button(editingComposite, 8);
        this.clearStyle.setText(SSEUIMessages.Restore_Default_UI_);
        this.clearStyle.setLayoutData((Object)new GridData(1));
        ((GridData)this.clearStyle.getLayoutData()).horizontalIndent = 20;
        this.clearStyle.setEnabled(false);
        Composite sampleArea = this.createComposite((Composite)editor, 1);
        ((GridLayout)sampleArea.getLayout()).marginLeft = 5;
        ((GridLayout)sampleArea.getLayout()).marginTop = 5;
        this.createLabel(sampleArea, SSEUIMessages.Sample_text__UI_);
        SourceViewer viewer = new SourceViewer(sampleArea, null, 33557258);
        this.styledText = viewer.getTextWidget();
        GridData gridData3 = new GridData(4, 4, true, true);
        gridData3.widthHint = this.convertWidthInCharsToPixels(20);
        gridData3.heightHint = this.convertHeightInCharsToPixels(5);
        gridData3.horizontalSpan = 2;
        this.styledText.setLayoutData((Object)gridData3);
        this.styledText.setEditable(false);
        this.styledText.setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        this.styledText.addKeyListener(this.getTextKeyListener());
        this.styledText.addSelectionListener(this.getTextSelectionListener());
        this.styledText.addMouseListener(this.getTextMouseListener());
        this.styledText.addTraverseListener(this.getTraverseListener());
        this.setAccessible((Control)this.styledText, SSEUIMessages.Sample_text__UI_);
        try {
            File file = XSLUIPlugin.makeFileFor(XSLFILES_DIR, SYNTAXCOLORING_XSL);
            this.document = StructuredModelManager.getModelManager().createStructuredDocumentFor(file.getAbsolutePath(), (InputStream)new FileInputStream(file), null);
        }
        catch (Exception ex) {
            XSLUIPlugin.log(ex);
        }
        viewer.setDocument((IDocument)this.document);
        top.setWeights(new int[]{1, 1});
        editor.setWeights(new int[]{1, 1});
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComponent, "org.eclipse.wst.xml.ui.webx0062");
        this.stylesViewer.setInput(this.getStylePreferenceKeys());
        this.applyStyles();
        this.stylesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    XSLSyntaxColoringPage.this.activate(namedStyle);
                    if (namedStyle == null) {
                        return;
                    }
                }
            }
        });
        this.foregroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("colorValue")) {
                    Object o = ((IStructuredSelection)XSLSyntaxColoringPage.this.stylesViewer.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    String prefString = XSLSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                    String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                    if (stylePrefs != null) {
                        String oldValue = stylePrefs[0];
                        String newValue = ColorHelper.toRGBString((RGB)XSLSyntaxColoringPage.this.foregroundColorEditor.getColorValue());
                        if (!newValue.equals(oldValue)) {
                            stylePrefs[0] = newValue;
                            String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                            XSLSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                            XSLSyntaxColoringPage.this.applyStyles();
                            XSLSyntaxColoringPage.this.styledText.redraw();
                        }
                    }
                }
            }
        });
        this.backgroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("colorValue")) {
                    Object o = ((IStructuredSelection)XSLSyntaxColoringPage.this.stylesViewer.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    String prefString = XSLSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                    String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                    if (stylePrefs != null) {
                        String oldValue = stylePrefs[1];
                        String newValue = ColorHelper.toRGBString((RGB)XSLSyntaxColoringPage.this.backgroundColorEditor.getColorValue());
                        if (!newValue.equals(oldValue)) {
                            stylePrefs[1] = newValue;
                            String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                            XSLSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                            XSLSyntaxColoringPage.this.applyStyles();
                            XSLSyntaxColoringPage.this.styledText.redraw();
                            XSLSyntaxColoringPage.this.activate(namedStyle);
                        }
                    }
                }
            }
        });
        this.bold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)XSLSyntaxColoringPage.this.stylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = XSLSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[2];
                    String newValue = String.valueOf(XSLSyntaxColoringPage.this.bold.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[2] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        XSLSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        XSLSyntaxColoringPage.this.applyStyles();
                        XSLSyntaxColoringPage.this.styledText.redraw();
                    }
                }
            }
        });
        this.italic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)XSLSyntaxColoringPage.this.stylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = XSLSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[3];
                    String newValue = String.valueOf(XSLSyntaxColoringPage.this.italic.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[3] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        XSLSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        XSLSyntaxColoringPage.this.applyStyles();
                        XSLSyntaxColoringPage.this.styledText.redraw();
                    }
                }
            }
        });
        this.strike.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)XSLSyntaxColoringPage.this.stylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = XSLSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[4];
                    String newValue = String.valueOf(XSLSyntaxColoringPage.this.strike.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[4] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        XSLSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        XSLSyntaxColoringPage.this.applyStyles();
                        XSLSyntaxColoringPage.this.styledText.redraw();
                    }
                }
            }
        });
        this.underline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)XSLSyntaxColoringPage.this.stylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = XSLSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[5];
                    String newValue = String.valueOf(XSLSyntaxColoringPage.this.underline.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[5] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        XSLSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        XSLSyntaxColoringPage.this.applyStyles();
                        XSLSyntaxColoringPage.this.styledText.redraw();
                    }
                }
            }
        });
        this.clearStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (XSLSyntaxColoringPage.this.stylesViewer.getSelection().isEmpty()) {
                    return;
                }
                String namedStyle = ((IStructuredSelection)XSLSyntaxColoringPage.this.stylesViewer.getSelection()).getFirstElement().toString();
                XSLSyntaxColoringPage.this.getOverlayStore().setToDefault(namedStyle);
                XSLSyntaxColoringPage.this.applyStyles();
                XSLSyntaxColoringPage.this.styledText.redraw();
                XSLSyntaxColoringPage.this.activate(namedStyle);
            }
        });
        return pageComponent;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 64);
        label.setText(text);
        GridData data = new GridData(4, 4, false, false);
        label.setLayoutData((Object)data);
        label.setBackground(parent.getBackground());
        return label;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator<String> i = this.getStylePreferenceKeys().iterator();
        while (i.hasNext()) {
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, i.next()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private StructuredViewer createStylesViewer(Composite parent) {
        ListViewer stylesViewer = new ListViewer(parent, 2820);
        stylesViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        stylesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Object description = XSLSyntaxColoringPage.this.styleToDescriptionMap.get(element);
                if (description != null) {
                    return description.toString();
                }
                return super.getText(element);
            }
        });
        stylesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return XSLSyntaxColoringPage.this.getStylePreferenceKeys().toArray();
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object getParent(Object element) {
                return XSLSyntaxColoringPage.this.getStylePreferenceKeys();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        return stylesViewer;
    }

    public void dispose() {
        if (this.overlayStore != null) {
            this.overlayStore.stop();
        }
        super.dispose();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return XSLUIPlugin.getDefault().getPreferenceStore();
    }

    private TextAttribute getAttributeFor(String namedStyle) {
        String prefString;
        String[] stylePrefs;
        TextAttribute ta = new TextAttribute(this.defaultForeground, this.defaultBackground, 0);
        if (namedStyle != null && this.overlayStore != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = this.getOverlayStore().getString(namedStyle)))) != null) {
            boolean on;
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            int fontModifier = 0;
            if (stylePrefs.length > 2 && (on = Boolean.valueOf(stylePrefs[2]).booleanValue())) {
                fontModifier |= 1;
            }
            if (stylePrefs.length > 3 && (on = Boolean.valueOf(stylePrefs[3]).booleanValue())) {
                fontModifier |= 2;
            }
            if (stylePrefs.length > 4 && (on = Boolean.valueOf(stylePrefs[4]).booleanValue())) {
                fontModifier |= 0x20000000;
            }
            if (stylePrefs.length > 5 && (on = Boolean.valueOf(stylePrefs[5]).booleanValue())) {
                fontModifier |= 0x40000000;
            }
            ta = new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, fontModifier);
        }
        return ta;
    }

    private String getNamedStyleAtOffset(int offset) {
        if (offset >= this.document.getLength()) {
            return this.getNamedStyleAtOffset(this.document.getLength() - 1);
        }
        if (offset < 0) {
            return this.getNamedStyleAtOffset(0);
        }
        IStructuredDocumentRegion documentRegion = this.document.getFirstStructuredDocumentRegion();
        while (documentRegion != null && !documentRegion.containsOffset(offset)) {
            documentRegion = documentRegion.getNext();
        }
        if (documentRegion != null) {
            ITextRegion interest = documentRegion.getRegionAtCharacterOffset(offset);
            if (interest == null) {
                return null;
            }
            if (offset > documentRegion.getTextEndOffset(interest)) {
                return null;
            }
            String regionContext = interest.getType();
            if (regionContext == null) {
                return null;
            }
            String namedStyle = (String)this.contextToXSLStyleMap.get(regionContext);
            if (namedStyle != null) {
                return namedStyle;
            }
        }
        return null;
    }

    private OverlayPreferenceStore getOverlayStore() {
        return this.overlayStore;
    }

    private Collection<String> getStylePreferenceKeys() {
        if (this.stylePreferenceKeys == null) {
            ArrayList<String> styles = new ArrayList<String>();
            styles.add("xsltagBorder");
            styles.add("xsltagName");
            styles.add("xsltagAttributeName");
            styles.add("xsltagAttributeValue");
            this.stylePreferenceKeys = styles;
        }
        return this.stylePreferenceKeys;
    }

    private KeyListener getTextKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    XSLSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    XSLSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private MouseListener getTextMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    XSLSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private SelectionListener getTextSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XSLSyntaxColoringPage.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                XSLSyntaxColoringPage.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }
        };
    }

    private TraverseListener getTraverseListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.widget instanceof StyledText && (e.detail == 16 || e.detail == 8)) {
                    e.doit = true;
                }
            }
        };
    }

    public void init(IWorkbench workbench) {
        this.setDescription(SSEUIMessages.SyntaxColoring_Description);
        this.styleToDescriptionMap = new HashMap();
        this.contextToXSLStyleMap = new HashMap();
        this.initStyleToDescriptionMap();
        this.initRegionContextToStyleMap();
        this.overlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
        this.overlayStore.load();
        this.overlayStore.start();
    }

    private void initRegionContextToStyleMap() {
        this.xslContextToStyleMap();
    }

    private void xslContextToStyleMap() {
        this.contextToXSLStyleMap.put("XML_TAG_OPEN", "xsltagBorder");
        this.contextToXSLStyleMap.put("XML_END_TAG_OPEN", "xsltagBorder");
        this.contextToXSLStyleMap.put("XML_TAG_NAME", "xsltagName");
        this.contextToXSLStyleMap.put("XML_TAG_ATTRIBUTE_NAME", "xsltagAttributeName");
        this.contextToXSLStyleMap.put("XML_TAG_ATTRIBUTE_VALUE", "xsltagAttributeValue");
        this.contextToXSLStyleMap.put("XML_TAG_CLOSE", "xsltagBorder");
        this.contextToXSLStyleMap.put("XML_EMPTY_TAG_CLOSE", "xsltagBorder");
    }

    private void initStyleToDescriptionMap() {
        this.styleToDescriptionMap.put("xsltagBorder", XMLUIMessages.Tag_Delimiters_UI_);
        this.styleToDescriptionMap.put("xsltagName", XMLUIMessages.Tag_Names_UI_);
        this.styleToDescriptionMap.put("xsltagAttributeName", XMLUIMessages.Attribute_Names_UI_);
        this.styleToDescriptionMap.put("xsltagAttributeValue", XMLUIMessages.Attribute_Values_UI_);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getOverlayStore().loadDefaults();
        this.applyStyles();
        this.stylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.activate(null);
        this.styledText.redraw();
    }

    public boolean performOk() {
        this.getOverlayStore().propagate();
        XSLUIPlugin.getDefault().savePluginPreferences();
        SSEUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void selectColorAtOffset(int offset) {
        String namedStyle = this.getNamedStyleAtOffset(offset);
        if (namedStyle != null) {
            this.stylesViewer.setSelection((ISelection)new StructuredSelection((Object)namedStyle));
            this.stylesViewer.reveal((Object)namedStyle);
        } else {
            this.stylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.activate(namedStyle);
    }

    private void setAccessible(Control control, String name) {
        if (control == null) {
            return;
        }
        final String n = name;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = n;
                }
            }
        });
    }
}

