/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.upgrade.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.upgrade.internal.UpgradeWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class UpgradeWizard
extends Wizard {
    private static final String WIZBAN_IMAGE = "images/upgrade-wizban.gif";
    private final Set<IProject> projects;
    private boolean isCanceled;
    private IProgressMonitor monitor;

    public UpgradeWizard(Set<IProject> projects) {
        this.projects = projects;
        this.isCanceled = true;
        this.monitor = null;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Resources.windowTitle);
        ImageDescriptor defaultPageImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.common.upgrade", (String)WIZBAN_IMAGE);
        this.setDefaultPageImageDescriptor(defaultPageImageDescriptor);
    }

    public void addPages() {
        UpgradeWizardPage page = new UpgradeWizardPage(this.projects);
        this.addPage((IWizardPage)page);
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                UpgradeWizard wizard;
                UpgradeWizard upgradeWizard = wizard = UpgradeWizard.this;
                synchronized (upgradeWizard) {
                    wizard.isCanceled = false;
                    wizard.monitor = (IProgressMonitor)new NotifyWhenDoneProgressMonitor(monitor, (Object)wizard);
                    ((Object)((Object)wizard)).notify();
                    boolean keepWaiting = true;
                    while (keepWaiting) {
                        try {
                            ((Object)((Object)wizard)).wait();
                            keepWaiting = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        return true;
    }

    public synchronized boolean performCancel() {
        this.isCanceled = true;
        ((Object)((Object)this)).notify();
        DialogService.showWarningDialog((String)Resources.upgradeCancelWarningDialogTitle, (String)Resources.upgradeCancelWarningMessage);
        return true;
    }

    public synchronized void show() {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UpgradeWizard wizard = UpgradeWizard.this;
                try {
                    Shell shell = display.getActiveShell();
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                }
                catch (Throwable throwable) {
                    UpgradeWizard upgradeWizard = wizard;
                    synchronized (upgradeWizard) {
                        ((Object)((Object)wizard)).notify();
                    }
                    throw throwable;
                }
                UpgradeWizard upgradeWizard = wizard;
                synchronized (upgradeWizard) {
                    ((Object)((Object)wizard)).notify();
                }
            }
        });
        boolean keepWaiting = true;
        while (keepWaiting) {
            try {
                ((Object)((Object)this)).wait();
                keepWaiting = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    private static final class NotifyWhenDoneProgressMonitor
    extends ProgressMonitorWrapper {
        private final Object monitor;

        public NotifyWhenDoneProgressMonitor(IProgressMonitor progressMonitor, Object monitor) {
            super(progressMonitor);
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            super.done();
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notify();
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String windowTitle;
        public static String upgradeCancelWarningDialogTitle;
        public static String upgradeCancelWarningMessage;

        static {
            Resources.initializeMessages((String)UpgradeWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

