/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.upgrade.internal;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IWorkspaceUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.internal.ProjectUpgradeLog;
import oracle.eclipse.tools.common.upgrade.internal.Tracing;
import oracle.eclipse.tools.common.upgrade.internal.UpgradePlugin;
import oracle.eclipse.tools.common.upgrade.internal.UpgradeWizard;
import oracle.eclipse.tools.common.util.EclipseThreadingUtil;
import oracle.eclipse.tools.common.util.MutableReference;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.ProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class UpgradeFrameworkImpl {
    private static final String EL_PARTICIPANT = "participant";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_REQUIRES = "requires";
    private static final String ATTR_PRIORITY = "priority";
    private static final int DEFAULT_PRIORITY = 0;
    private static final String PARTICIPANT_ID_SEPARATOR = ";";
    private final Map<String, SoftReference<ProjectUpgradeLog>> projectUpgradeLogs = new HashMap<String, SoftReference<ProjectUpgradeLog>>();
    private List<Set<Extension<IProjectUpgradeParticipant>>> projectUpgradeParticipants;
    private List<Set<Extension<IWorkspaceUpgradeParticipant>>> workspaceUpgradeParticipants;
    private final Object lock = new Object();
    private CheckerThread checkerThread = null;

    public void initialize() {
        this.projectUpgradeParticipants = UpgradeFrameworkImpl.readExtensions("projectUpgradeParticipants", IProjectUpgradeParticipant.class);
        this.workspaceUpgradeParticipants = UpgradeFrameworkImpl.readExtensions("workspaceUpgradeParticipants", IWorkspaceUpgradeParticipant.class);
        ResourceChangeListener listener = new ResourceChangeListener();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.addResourceChangeListener((IResourceChangeListener)listener, 1);
        boolean promptedForWorkspaceUpgrade = false;
        if (Tracing.isTracingEnabled(Tracing.Flag.WORKSPACE_UPGRADE)) {
            Tracing.output("Starting workspace upgrade.");
        }
        for (Set<Extension<IWorkspaceUpgradeParticipant>> bucket : this.getWorkspaceUpgradeParticipants()) {
            for (Extension<IWorkspaceUpgradeParticipant> pext : bucket) {
                IWorkspaceUpgradeParticipant participant = pext.getParticipantInstance();
                try {
                    StringBuilder msg;
                    if (Tracing.isTracingEnabled(Tracing.Flag.WORKSPACE_UPGRADE)) {
                        msg = new StringBuilder();
                        msg.append("CHECKING ");
                        msg.append(participant.getClass().getName());
                        msg.append(" (");
                        msg.append(pext.getPluginId());
                        msg.append(')');
                        Tracing.output(msg.toString());
                    }
                    if (!participant.check()) continue;
                    if (!promptedForWorkspaceUpgrade) {
                        if (!UpgradeFrameworkImpl.promptForWorkspaceUpgrade()) {
                            return;
                        }
                        promptedForWorkspaceUpgrade = true;
                    }
                    if (Tracing.isTracingEnabled(Tracing.Flag.WORKSPACE_UPGRADE)) {
                        msg = new StringBuilder();
                        msg.append("EXECUTING ");
                        msg.append(participant.getClass().getName());
                        msg.append(" (");
                        msg.append(pext.getPluginId());
                        msg.append(')');
                        Tracing.output(msg.toString());
                    }
                    participant.execute((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.upgrade", (Throwable)e);
                }
            }
        }
        if (Tracing.isTracingEnabled(Tracing.Flag.WORKSPACE_UPGRADE)) {
            Tracing.output("Workspace upgrade completed.");
        }
        this.checkProjects(Arrays.asList(ws.getRoot().getProjects()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectUpgradeLog getProjectUpgradeLog(IProject project) {
        Map<String, SoftReference<ProjectUpgradeLog>> map = this.projectUpgradeLogs;
        synchronized (map) {
            ProjectUpgradeLog log;
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList<String> toDelete = new ArrayList<String>();
            for (Map.Entry<String, SoftReference<ProjectUpgradeLog>> entry : this.projectUpgradeLogs.entrySet()) {
                String projectName = entry.getKey();
                if (wsroot.getProject(projectName).isAccessible() && entry.getValue().get() != null) continue;
                toDelete.add(projectName);
            }
            for (String projectName : toDelete) {
                this.projectUpgradeLogs.remove(projectName);
            }
            SoftReference<ProjectUpgradeLog> softref = this.projectUpgradeLogs.get(project.getName());
            if (softref != null && (log = softref.get()) != null) {
                log.refresh();
                return log;
            }
            log = new ProjectUpgradeLog(project);
            softref = new SoftReference<ProjectUpgradeLog>(log);
            this.projectUpgradeLogs.put(project.getName(), softref);
            return log;
        }
    }

    private List<Set<Extension<IProjectUpgradeParticipant>>> getProjectUpgradeParticipants() {
        return this.projectUpgradeParticipants;
    }

    private List<Set<Extension<IWorkspaceUpgradeParticipant>>> getWorkspaceUpgradeParticipants() {
        return this.workspaceUpgradeParticipants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProjects(Collection<IProject> projects) {
        if (projects != null && !projects.isEmpty()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.checkerThread == null) {
                    this.checkerThread = new CheckerThread(projects);
                    this.checkerThread.start();
                } else {
                    this.checkerThread.addProjects(projects);
                }
            }
        }
    }

    private static boolean promptForWorkspaceUpgrade() {
        if (DialogService.showYesNoDialog((String)Resources.upgradeWorkspaceDialogTitle, (String)Resources.upgradeWorkspaceDialogMessage)) {
            return true;
        }
        DialogService.showWarningDialog((String)Resources.upgradeCancelWarningDialogTitle, (String)Resources.upgradeCancelWarningMessage);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> List<Set<Extension<T>>> readExtensions(String extensionPointId, Class<T> participantInterfaceClass) {
        boolean bl;
        void var7_14;
        HashSet<Extension<T>> participants = new HashSet<Extension<T>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("oracle.eclipse.tools.common.upgrade", extensionPointId);
        if (point == null) {
            throw new IllegalStateException();
        }
        HashMap requiredParticipantsMap = new HashMap();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        boolean bl2 = false;
        while (var7_14 < n) {
            IExtension extension = iExtensionArray[var7_14];
            String string = extension.getContributor().getName();
            String pluginVersion = PluginUtil.getPluginVersion((String)string);
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n2 = iConfigurationElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IConfigurationElement el = iConfigurationElementArray[n3];
                String elName = el.getName();
                if (elName.equals(EL_PARTICIPANT)) {
                    Object participant;
                    String id;
                    String clname = el.getAttribute(ATTR_CLASS);
                    if (clname == null) {
                        PluginUtil.reportMissingAttribute((IConfigurationElement)el, (String)ATTR_CLASS);
                    }
                    if ((id = el.getAttribute(ATTR_ID)) == null) {
                        id = clname;
                    }
                    String priorityStr = el.getAttribute(ATTR_PRIORITY);
                    int priority = 0;
                    if (priorityStr != null) {
                        try {
                            priority = Integer.valueOf(priorityStr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            String msg = NLS.bind((String)Resources.invalidPriority, (Object)id);
                            LoggingService.logError((String)"oracle.eclipse.tools.common.upgrade", (String)msg);
                        }
                    }
                    String requires = el.getAttribute(ATTR_REQUIRES);
                    Set requiredParticipants = null;
                    if (requires != null) {
                        String[] stringArray = requires.split(PARTICIPANT_ID_SEPARATOR);
                        int n4 = stringArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String x = stringArray[n5];
                            if ((x = x.trim()).length() > 0) {
                                if (requiredParticipants == null) {
                                    requiredParticipants = new HashSet();
                                }
                                requiredParticipants.add(x);
                            }
                            ++n5;
                        }
                    }
                    if (requiredParticipants == null) {
                        requiredParticipants = Collections.emptySet();
                    }
                    if ((participant = PluginUtil.instantiate((String)string, (String)clname, participantInterfaceClass)) != null) {
                        Extension<Object> pext = new Extension<Object>(string, pluginVersion, id, participant, priority);
                        participants.add(pext);
                        requiredParticipantsMap.put(pext, requiredParticipants);
                    }
                }
                ++n3;
            }
            ++var7_14;
        }
        HashSet<Extension> toRemove = new HashSet<Extension>();
        for (Extension extension : participants) {
            Set requiredParticipants = (Set)requiredParticipantsMap.get(extension);
            for (String string : requiredParticipants) {
                Extension<T> requiredParticipant = UpgradeFrameworkImpl.find(participants, string);
                if (requiredParticipant == null) {
                    toRemove.add(extension);
                    String msg = NLS.bind((String)Resources.participantDoesNotExist, (Object)string, (Object)extension.getId());
                    LoggingService.logError((String)"oracle.eclipse.tools.common.upgrade", (String)msg);
                    continue;
                }
                extension.addRequiredParticipant(requiredParticipant);
            }
        }
        boolean bl3 = true;
        while (bl) {
            bl = false;
            block8: for (Extension extension : participants) {
                if (toRemove.contains(extension)) continue;
                for (Extension extension2 : extension.getRequiredParticipants()) {
                    if (!toRemove.contains(extension2)) continue;
                    toRemove.add(extension);
                    bl = true;
                    continue block8;
                }
            }
        }
        for (Extension extension : toRemove) {
            participants.remove(extension);
            String string = NLS.bind((String)Resources.unsatisfiedDependencies, (Object)extension.getId());
            LoggingService.logError((String)"oracle.eclipse.tools.common.upgrade", (String)string);
        }
        return UpgradeFrameworkImpl.sort(participants);
    }

    private static <T> Extension<T> find(Set<Extension<T>> participants, String id) {
        for (Extension<T> pext : participants) {
            if (!pext.getId().equals(id)) continue;
            return pext;
        }
        return null;
    }

    private static <T> List<Set<Extension<T>>> sort(Set<Extension<T>> extensions) {
        HashSet<Extension<T>> participants = new HashSet<Extension<T>>(extensions);
        ArrayList<Set<Extension<T>>> sorted = new ArrayList<Set<Extension<T>>>();
        while (!participants.isEmpty()) {
            HashSet<Extension> bucket = new HashSet<Extension>();
            for (Extension extension : participants) {
                boolean foundAllRequired = true;
                for (Extension required : extension.getRequiredParticipants()) {
                    if (UpgradeFrameworkImpl.contains(sorted, required)) continue;
                    foundAllRequired = false;
                    break;
                }
                if (!foundAllRequired) continue;
                if (bucket.isEmpty()) {
                    bucket.add(extension);
                    continue;
                }
                boolean addToBucket = true;
                Iterator iterator = bucket.iterator();
                while (iterator.hasNext()) {
                    Extension i = (Extension)iterator.next();
                    if (i.getPriority() < extension.getPriority()) {
                        addToBucket = false;
                        break;
                    }
                    if (i.getPriority() <= extension.getPriority()) continue;
                    iterator.remove();
                }
                if (!addToBucket) continue;
                bucket.add(extension);
            }
            if (!bucket.isEmpty()) {
                sorted.add(bucket);
                participants.removeAll(bucket);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Extension extension : participants) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"');
                stringBuilder.append(extension.getId());
                stringBuilder.append('\"');
            }
            String string = NLS.bind((String)Resources.cycleDetected, (Object)stringBuilder.toString());
            LoggingService.logError((String)"oracle.eclipse.tools.common.upgrade", (String)string);
            participants.clear();
        }
        UpgradeFrameworkImpl.traceSortResults(extensions, sorted);
        return sorted;
    }

    private static <T> void traceSortResults(Set<Extension<T>> input, List<Set<Extension<T>>> output) {
        if (Tracing.isTracingEnabled(Tracing.Flag.INITIALIZATION)) {
            StringBuilder msg = new StringBuilder();
            msg.append("Sorting upgrade participants: \n\n");
            msg.append("  Input:\n\n");
            for (Extension<T> extension : input) {
                msg.append("    ");
                msg.append(extension.getParticipantInstance().getClass().getName());
                msg.append(" (");
                msg.append(extension.getPluginId());
                msg.append(")\n");
            }
            msg.append("\n  Output:\n\n");
            int counter = 1;
            for (Set<Extension<T>> bucket : output) {
                if (counter > 1) {
                    msg.append('\n');
                }
                msg.append("    Bucket ");
                msg.append(counter);
                msg.append(":\n\n");
                for (Extension<T> extension : bucket) {
                    msg.append("      ");
                    msg.append(extension.getParticipantInstance().getClass().getName());
                    msg.append(" (");
                    msg.append(extension.getPluginId());
                    msg.append(")\n");
                }
                ++counter;
            }
            Tracing.output(msg.toString());
        }
    }

    private static <T> boolean contains(List<Set<Extension<T>>> extensions, Extension<T> extension) {
        for (Set<Extension<T>> set : extensions) {
            if (!set.contains(extension)) continue;
            return true;
        }
        return false;
    }

    private static <T> int size(List<Set<Extension<T>>> extensions) {
        int size = 0;
        for (Set<Extension<T>> set : extensions) {
            size += set.size();
        }
        return size;
    }

    private static IStatus createErrorStatus(Throwable e) {
        return new Status(4, "oracle.eclipse.tools.common.upgrade", 0, Resources.unexpectedException, e);
    }

    private static final class AbortUpgradeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private AbortUpgradeException() {
        }
    }

    private static final class BroadcastProgressMonitor
    implements IProgressMonitor {
        private final IProgressMonitor monitor1;
        private final IProgressMonitor monitor2;

        public BroadcastProgressMonitor(IProgressMonitor monitor1, IProgressMonitor monitor2) {
            this.monitor1 = monitor1;
            this.monitor2 = monitor2;
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
            this.monitor1.done();
            this.monitor2.done();
        }

        public void internalWorked(double work) {
            this.monitor1.internalWorked(work);
            this.monitor2.internalWorked(work);
        }

        public boolean isCanceled() {
            return this.monitor1.isCanceled() || this.monitor2.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.monitor1.setCanceled(value);
            this.monitor2.setCanceled(value);
        }

        public void setTaskName(String name) {
            this.monitor1.setTaskName(name);
            this.monitor2.setTaskName(name);
        }

        public void subTask(String name) {
            this.monitor1.subTask(name);
            this.monitor2.subTask(name);
        }

        public void worked(int work) {
            this.monitor1.worked(work);
            this.monitor2.worked(work);
        }
    }

    private final class CheckerThread
    extends Thread {
        private final Set<IProject> projectsToCheck = new HashSet<IProject>();

        public CheckerThread(Collection<IProject> projectsToCheck) {
            this.projectsToCheck.addAll(projectsToCheck);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SwtUtil.waitOnModalShells();
            EclipseThreadingUtil.waitForResourceChangesToCease((int)5);
            SwtUtil.waitOnModalShells();
            Object object = UpgradeFrameworkImpl.this.lock;
            synchronized (object) {
                UpgradeFrameworkImpl.this.checkerThread = null;
            }
            HashSet<IProject> projectsToUpgrade = new HashSet<IProject>();
            for (IProject project : this.projectsToCheck) {
                if (!this.checkProject(project)) continue;
                projectsToUpgrade.add(project);
            }
            if (!projectsToUpgrade.isEmpty()) {
                UpgradeJob upgradeJob = new UpgradeJob(projectsToUpgrade);
                upgradeJob.schedule();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjects(Collection<IProject> projects) {
            Object object = UpgradeFrameworkImpl.this.lock;
            synchronized (object) {
                this.projectsToCheck.addAll(projects);
            }
        }

        private boolean checkProject(IProject project) {
            for (Set bucket : UpgradeFrameworkImpl.this.getProjectUpgradeParticipants()) {
                for (Extension participant : bucket) {
                    if (!project.isAccessible()) {
                        return false;
                    }
                    try {
                        if (!((IProjectUpgradeParticipant)participant.getParticipantInstance()).check(project)) continue;
                        return true;
                    }
                    catch (Throwable e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.common.upgrade", (Throwable)e);
                    }
                }
            }
            return false;
        }
    }

    private static final class Extension<T> {
        private final String pluginId;
        private final String pluginVersion;
        private final String id;
        private final T participant;
        private final int priority;
        private final Set<Extension<T>> requiredParticipants;
        private final Set<Extension<T>> requiredParticipantsReadOnly;

        public Extension(String pluginId, String pluginVersion, String id, T participant, int priority) {
            this.pluginId = pluginId;
            this.pluginVersion = pluginVersion != null ? pluginVersion : "N/A";
            this.id = id;
            this.participant = participant;
            this.priority = priority;
            this.requiredParticipants = new HashSet<Extension<T>>();
            this.requiredParticipantsReadOnly = Collections.unmodifiableSet(this.requiredParticipants);
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public String getId() {
            return this.id;
        }

        public T getParticipantInstance() {
            return this.participant;
        }

        public int getPriority() {
            return this.priority;
        }

        public Set<Extension<T>> getRequiredParticipants() {
            return this.requiredParticipantsReadOnly;
        }

        public void addRequiredParticipant(Extension<T> pdesc) {
            this.requiredParticipants.add(pdesc);
        }

        public String toString() {
            return this.id;
        }
    }

    private final class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            HashSet<IProject> projectsToCheck = null;
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta d = iResourceDeltaArray[n2];
                IProject pj = (IProject)d.getResource();
                int kind = d.getKind();
                boolean addProjectToQueue = false;
                if (kind == 1) {
                    addProjectToQueue = true;
                } else if (kind == 4 && (d.getFlags() & 0x4000) != 0 && pj.isAccessible()) {
                    addProjectToQueue = true;
                }
                if (addProjectToQueue) {
                    if (projectsToCheck == null) {
                        projectsToCheck = new HashSet<IProject>();
                    }
                    projectsToCheck.add(pj);
                }
                ++n2;
            }
            UpgradeFrameworkImpl.this.checkProjects(projectsToCheck);
        }
    }

    private static final class Resources
    extends NLS {
        public static String unexpectedException;
        public static String upgradeJobTitle;
        public static String upgradeTaskLabel;
        public static String failedWhileUpgrading;
        public static String participantDoesNotExist;
        public static String unsatisfiedDependencies;
        public static String cycleDetected;
        public static String upgradeWorkspaceDialogTitle;
        public static String upgradeWorkspaceDialogMessage;
        public static String upgradeCancelWarningDialogTitle;
        public static String upgradeCancelWarningMessage;
        public static String invalidPriority;

        static {
            Resources.initializeMessages((String)UpgradeFrameworkImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private final class UpgradeJob
    extends Job {
        private final Set<IProject> projects;

        public UpgradeJob(Set<IProject> projects) {
            super(Resources.upgradeJobTitle);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.projects = projects;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status;
            final MutableReference result = new MutableReference();
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    result.set((Object)UpgradeJob.this.executeUpgrade(monitor));
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(wr, monitor);
                status = (IStatus)result.get();
            }
            catch (CoreException e) {
                UpgradePlugin.logException((Exception)((Object)e));
                status = e.getStatus();
            }
            return status;
        }

        private IStatus executeUpgrade(IProgressMonitor monitor) {
            List buckets = UpgradeFrameworkImpl.this.getProjectUpgradeParticipants();
            HashSet<IStatus> problems = new HashSet<IStatus>();
            int workItemsCount = this.projects.size() * UpgradeFrameworkImpl.size(buckets) + 4;
            monitor.beginTask(Resources.upgradeTaskLabel, workItemsCount);
            IProgressMonitor wizardProgressMonitor = null;
            try {
                UpgradeWizard wizard = new UpgradeWizard(this.projects);
                wizard.show();
                if (wizard.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                wizardProgressMonitor = wizard.getProgressMonitor();
                wizardProgressMonitor.beginTask(Resources.upgradeTaskLabel, workItemsCount);
                BroadcastProgressMonitor combinedMonitor = new BroadcastProgressMonitor(monitor, wizardProgressMonitor);
                for (IProject project : this.projects) {
                    try {
                        project.refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        if (wizardProgressMonitor != null) {
                            wizardProgressMonitor.done();
                        }
                        return iStatus;
                    }
                }
                combinedMonitor.worked(1);
                for (Set bucket : buckets) {
                    try {
                        this.processUpgradeParticipants(bucket, combinedMonitor, problems);
                    }
                    catch (AbortUpgradeException abortUpgradeException) {
                        IStatus iStatus = Status.OK_STATUS;
                        monitor.done();
                        if (wizardProgressMonitor != null) {
                            wizardProgressMonitor.done();
                        }
                        return iStatus;
                    }
                }
                ProjectUtil.scheduleCleanBuild(this.projects);
                combinedMonitor.worked(1);
            }
            finally {
                monitor.done();
                if (wizardProgressMonitor != null) {
                    wizardProgressMonitor.done();
                }
            }
            Object status = problems.isEmpty() ? Status.OK_STATUS : new MultiStatus("oracle.eclipse.tools.common.upgrade", 0, problems.toArray(new IStatus[problems.size()]), Resources.failedWhileUpgrading, null);
            return status;
        }

        private void processUpgradeParticipants(Set<Extension<IProjectUpgradeParticipant>> bucket, IProgressMonitor combinedMonitor, Set<IStatus> problems) throws AbortUpgradeException {
            HashMap activeParticipants = new HashMap();
            HashSet<IFile> filesToBeEdited = new HashSet<IFile>();
            for (IProject project : this.projects) {
                filesToBeEdited.add(UpgradeFrameworkImpl.this.getProjectUpgradeLog(project).getLogFile());
                HashSet<Extension<IProjectUpgradeParticipant>> activeParticipantsForProject = new HashSet<Extension<IProjectUpgradeParticipant>>();
                activeParticipants.put(project, activeParticipantsForProject);
                for (Extension<IProjectUpgradeParticipant> participant : bucket) {
                    try {
                        Set<IProjectUpgradeParticipant.Action> participantActions = participant.getParticipantInstance().prepare(project);
                        if (participantActions.isEmpty()) continue;
                        activeParticipantsForProject.add(participant);
                        for (IProjectUpgradeParticipant.Action action : participantActions) {
                            if (action.getType() != IProjectUpgradeParticipant.Action.Type.EDIT && action.getType() != IProjectUpgradeParticipant.Action.Type.DELETE) continue;
                            filesToBeEdited.add(action.getFile());
                        }
                    }
                    catch (CoreException e) {
                        problems.add(e.getStatus());
                    }
                    catch (Throwable e) {
                        problems.add(UpgradeFrameworkImpl.createErrorStatus(e));
                    }
                }
            }
            combinedMonitor.worked(1);
            final Display display = PlatformUI.getWorkbench().getDisplay();
            final IWorkspace ws = ResourcesPlugin.getWorkspace();
            final IFile[] filesToBeEditedArray = filesToBeEdited.toArray(new IFile[filesToBeEdited.size()]);
            final MutableReference validateEditResult = new MutableReference();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IStatus st = ws.validateEdit(filesToBeEditedArray, (Object)display.getActiveShell());
                    validateEditResult.set((Object)st);
                }
            });
            if (((IStatus)validateEditResult.get()).getSeverity() == 4) {
                throw new AbortUpgradeException();
            }
            combinedMonitor.worked(1);
            for (IProject project : this.projects) {
                Set activeParticipantsForProject = (Set)activeParticipants.get(project);
                ProjectUpgradeLog upgradeLog = UpgradeFrameworkImpl.this.getProjectUpgradeLog(project);
                for (Extension participant : activeParticipantsForProject) {
                    try {
                        NullProgressMonitor npm = new NullProgressMonitor();
                        IProjectUpgradeParticipant p = (IProjectUpgradeParticipant)participant.getParticipantInstance();
                        p.execute(project, (IProgressMonitor)npm);
                        upgradeLog.addEntry(participant.getPluginId(), participant.getPluginVersion(), p.getClass().getName());
                    }
                    catch (CoreException e) {
                        problems.add(e.getStatus());
                    }
                    catch (Throwable e) {
                        problems.add(UpgradeFrameworkImpl.createErrorStatus(e));
                    }
                    combinedMonitor.worked(1);
                }
                int i = 0;
                int n = bucket.size() - activeParticipantsForProject.size();
                while (i < n) {
                    combinedMonitor.worked(1);
                    ++i;
                }
            }
        }
    }
}

