/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.preferences;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.glassfish.GlassFishInstall;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public class GlassFishFRuntimeLocatorDelegate
extends RuntimeLocatorDelegate {
    public static final String ID = "glassfish";
    public static final IRuntimeComponentType INSTANCE = RuntimeManager.getRuntimeComponentType((String)"glassfish");
    public static final IRuntimeComponentVersion VERSION_3_1 = INSTANCE.getVersion("3.1");
    public static final IRuntimeComponentVersion VERSION_4_0 = INSTANCE.getVersion("4");
    static final IRuntimeType RUNTIME_TYPE_3_1 = ServerCore.findRuntimeType((String)"org.glassfish.jst.server.runtime.glassfish31");
    static final IRuntimeType RUNTIME_TYPE_4_0 = ServerCore.findRuntimeType((String)"org.glassfish.jst.server.runtime.glassfish4");
    private static Map<IRuntimeComponentVersion, IRuntimeType> RCV_TO_TYPE = new HashMap<IRuntimeComponentVersion, IRuntimeType>();

    static {
        RCV_TO_TYPE.put(VERSION_3_1, RUNTIME_TYPE_3_1);
        RCV_TO_TYPE.put(VERSION_4_0, RUNTIME_TYPE_4_0);
    }

    public void searchForRuntimes(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        File f = path.toFile();
        if (!f.isDirectory()) {
            return;
        }
        this.searchForGFRuntime(f, listener);
    }

    private void searchForGFRuntime(File f, RuntimeLocatorDelegate.IRuntimeSearchListener listener) {
        try {
            IRuntime rt;
            if (f.getName().equals(ID) && (rt = GlassFishFRuntimeLocatorDelegate.createGlassFishRuntime(f, true)) != null) {
                IRuntimeWorkingCopy wc = rt.createWorkingCopy();
                listener.runtimeFound(wc);
                return;
            }
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    this.searchForGFRuntime(child, listener);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IRuntime createGlassFishRuntime(File gfhome, boolean save) throws CoreException {
        IStatus validationResult;
        GlassFishInstall install = GlassFishInstall.find(gfhome);
        if (install == null) {
            return null;
        }
        IRuntimeComponentVersion rcv = null;
        if (install.version().matches("[3.1-4.0)")) {
            rcv = VERSION_3_1;
        } else if (install.version().matches("[4.0")) {
            rcv = VERSION_4_0;
        }
        if (rcv == null) {
            return null;
        }
        IRuntimeType rtype = RCV_TO_TYPE.get(rcv);
        String name = String.valueOf(rtype.getName()) + " at localhost";
        if (ResourceManager.getInstance().getRuntime(name) != null) {
            name = String.valueOf(name) + "(" + System.currentTimeMillis() + ")";
        }
        IRuntimeWorkingCopy created = rtype.createRuntime(name, null);
        created.setName(name != null ? name : rtype.toString());
        created.setLocation((IPath)new Path(gfhome.getAbsolutePath()));
        if (rcv == VERSION_3_1 || rcv == VERSION_4_0) {
            RuntimeWorkingCopy rwc = (RuntimeWorkingCopy)created;
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sunappserver.rootdirectory", rwc.getLocation().toPortableString());
            rwc.setAttribute("generic_server_instance_properties", props);
        }
        if ((validationResult = created.validate(null)).getSeverity() == 4) {
            throw new CoreException(validationResult);
        }
        if (save) {
            created.save(true, null);
            FacetUtil.getRuntime((IRuntime)created.getOriginal()).getRuntimeComponents();
            return created.getOriginal();
        }
        return created;
    }
}

