/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.log.AbstractGlassfishConsole;
import oracle.eclipse.tools.glassfish.log.IGlassFishConsole;
import oracle.eclipse.tools.glassfish.log.ILogFilter;
import oracle.eclipse.tools.glassfish.log.LogReader;
import org.glassfish.tools.ide.server.FetchLog;

public class GlassfishConsole
extends AbstractGlassfishConsole
implements IGlassFishConsole {
    private static ScheduledExecutorService stopService = Executors.newSingleThreadScheduledExecutor();
    private StopJob job = new StopJob();

    GlassfishConsole(String name, ILogFilter filter) {
        super(name, GlassfishToolsPlugin.getInstance().getImageRegistry().getDescriptor("gf-server.img"), filter);
    }

    @Override
    public void startLogging() {
    }

    @Override
    public synchronized void startLogging(FetchLog ... logFetchers) {
        if (this.stopJobResult != null) {
            try {
                this.stopJobResult.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            this.stopJobResult = null;
        } else {
            System.out.println("stopJobResult is null in console " + this.getName());
            this.stopLoggingImpl();
        }
        this.readers = new ArrayList(logFetchers.length);
        this.latch = new CountDownLatch(logFetchers.length);
        this.filter.reset();
        int i = 0;
        FetchLog[] fetchLogArray = logFetchers;
        int n = logFetchers.length;
        int n2 = 0;
        while (n2 < n) {
            FetchLog logFetcher = fetchLogArray[n2];
            LogReader reader = new LogReader(logFetcher, this.out, this.latch, this.filter);
            this.readers.add(reader);
            Thread t = new Thread((Runnable)reader, "LogReader Thread" + i++);
            t.start();
            ++n2;
        }
    }

    @Override
    public synchronized void stopLogging() {
        if (this.isLogging()) {
            this.stopLoggingImpl();
        }
    }

    private void stopLoggingImpl() {
        if (this.readers == null) {
            return;
        }
        for (LogReader r : this.readers) {
            r.stop();
        }
        this.readers = null;
    }

    @Override
    public synchronized void stopLogging(int afterSeconds) {
        if (this.isLogging()) {
            this.stopJobResult = stopService.schedule(this.job, (long)afterSeconds, TimeUnit.SECONDS);
        }
    }

    protected void dispose() {
        super.dispose();
        this.stopLogging();
        try {
            this.latch.await();
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized boolean isLogging() {
        boolean isLogging = this.readers != null && this.readers.size() > 0 && this.stopJobResult == null;
        return isLogging;
    }

    @Override
    public void setLogFilter(ILogFilter filter) {
        this.filter = filter;
    }

    class StopJob
    implements Runnable {
        StopJob() {
        }

        @Override
        public void run() {
            GlassfishConsole.this.stopLoggingImpl();
        }
    }
}

