/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.eclipse.tools.glassfish.GlassFishInstall;
import oracle.eclipse.tools.glassfish.GlassFishTools;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.internal.Library;
import oracle.eclipse.tools.glassfish.internal.SystemLibrariesSetting;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;

public final class SystemLibrariesContainer
implements IClasspathContainer {
    public static final String ID = "oracle.eclipse.tools.glassfish.lib.system";
    private static final IPath PATH = new Path("oracle.eclipse.tools.glassfish.lib.system");
    private static final String FPROJ_METADATA_FILE = ".settings/org.eclipse.wst.common.project.facet.core.xml";
    private static boolean initialized;
    private static ContainersRefresherThread containersRefresherThread;
    private final List<IClasspathEntry> entries;

    private static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            RuntimeLifecycleListener.register();
            ResourceChangeListener.register();
            containersRefresherThread = new ContainersRefresherThread();
            containersRefresherThread.start();
        }
    }

    private SystemLibrariesContainer(IJavaProject project) {
        GlassFishInstall gf = GlassFishInstall.find(project);
        this.entries = gf == null ? Collections.emptyList() : gf.classpath(project.getProject());
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entries.toArray(new IClasspathEntry[this.entries.size()]);
    }

    public String getDescription() {
        return Resources.containerLabel;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return PATH;
    }

    private static boolean isOnClasspath(IProject project) throws CoreException {
        if (SystemLibrariesContainer.isJavaProject(project)) {
            return SystemLibrariesContainer.isOnClasspath(JavaCore.create((IProject)project));
        }
        return false;
    }

    private static boolean isOnClasspath(IJavaProject project) throws CoreException {
        IClasspathEntry[] cp;
        IClasspathEntry[] iClasspathEntryArray = cp = project.getRawClasspath();
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (SystemLibrariesContainer.isSystemLibrariesContainer(cpe)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSystemLibrariesContainer(IClasspathEntry cpe) {
        return cpe.getPath().equals((Object)PATH);
    }

    private static void refresh(IProject project) throws CoreException {
        if (SystemLibrariesContainer.isJavaProject(project)) {
            SystemLibrariesContainer.refresh(JavaCore.create((IProject)project));
        }
    }

    private static void refresh(IJavaProject project) throws CoreException {
        SystemLibrariesContainer newContainer;
        IClasspathContainer cont;
        SystemLibrariesContainer existingContainer;
        IClasspathEntry[] cp = project.getRawClasspath();
        IPath containerPath = null;
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (SystemLibrariesContainer.isSystemLibrariesContainer(cpe)) {
                containerPath = cpe.getPath();
                break;
            }
            ++n2;
        }
        if (containerPath != null && !(existingContainer = (SystemLibrariesContainer)(cont = JavaCore.getClasspathContainer(containerPath, (IJavaProject)project))).equals(newContainer = new SystemLibrariesContainer(project))) {
            IJavaProject[] projectsArray = new IJavaProject[]{project};
            IClasspathContainer[] containersArray = new IClasspathContainer[]{newContainer};
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])projectsArray, (IClasspathContainer[])containersArray, null);
        }
    }

    private static boolean isJavaProject(IProject project) {
        try {
            return project.getNature("org.eclipse.jdt.core.javanature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    /* synthetic */ SystemLibrariesContainer(IJavaProject iJavaProject, SystemLibrariesContainer systemLibrariesContainer) {
        this(iJavaProject);
    }

    private static final class ContainersRefresherThread
    extends Thread {
        private final LinkedList<IProject> projects = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProject getProjectFromQueue() {
            LinkedList<IProject> linkedList = this.projects;
            synchronized (linkedList) {
                block6: {
                    if (!this.projects.isEmpty()) break block6;
                    try {
                        this.projects.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return this.projects.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectToQueue(IProject project) {
            LinkedList<IProject> linkedList = this.projects;
            synchronized (linkedList) {
                this.projects.addLast(project);
                this.projects.notify();
            }
        }

        @Override
        public void run() {
            IProject project;
            while ((project = this.getProjectFromQueue()) != null) {
                try {
                    IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            SystemLibrariesContainer.refresh(project);
                        }
                    };
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wsr, (ISchedulingRule)ws.getRoot(), 0, null);
                    continue;
                }
                catch (CoreException e) {
                    GlassfishToolsPlugin.logMessage("Error", (Exception)((Object)e));
                    continue;
                }
                break;
            }
            return;
        }
    }

    public static final class Initializer
    extends ClasspathContainerInitializer {
        public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
            SystemLibrariesContainer.initialize();
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{new SystemLibrariesContainer(project, null)}, null);
        }

        public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
            return true;
        }

        public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
            super.requestClasspathContainerUpdate(containerPath, project, containerSuggestion);
            IProject proj = project.getProject();
            SystemLibrariesSetting settings = SystemLibrariesSetting.load(proj);
            if (settings == null) {
                settings = new SystemLibrariesSetting();
            }
            ArrayList<Library> libsList = settings.getLibraryList();
            boolean needUpdate = false;
            IClasspathEntry[] iClasspathEntryArray = containerSuggestion.getClasspathEntries();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IClasspathEntry cpe;
                    block5: {
                        cpe = iClasspathEntryArray[n2];
                        IPath srcPath = cpe.getSourceAttachmentPath();
                        if (srcPath == null) break block5;
                        needUpdate = true;
                        boolean foudEntry = false;
                        for (Library lib : libsList) {
                            String cpePath = cpe.getPath().toString();
                            if (!lib.getPath().equals(cpePath)) continue;
                            lib.setSource(srcPath.toPortableString());
                            foudEntry = true;
                            break;
                        }
                        if (foudEntry) break block6;
                        Library newLib = new Library();
                        newLib.setPath(cpe.getPath().toString());
                        newLib.setSource(srcPath.toString());
                        libsList.add(newLib);
                        break block6;
                    }
                    Iterator<Library> it = libsList.iterator();
                    while (it.hasNext()) {
                        Library lib;
                        lib = it.next();
                        String cpePath = cpe.getPath().toString();
                        if (!lib.getPath().equals(cpePath)) continue;
                        it.remove();
                        needUpdate = true;
                        break;
                    }
                }
                ++n2;
            }
            if (needUpdate) {
                SystemLibrariesSetting.save(proj, settings);
                this.initialize(containerPath, project);
            }
        }
    }

    private static final class ResourceChangeListener
    implements IResourceChangeListener {
        private final List<IPath> triggerFiles = new ArrayList<IPath>();

        public static void register() {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 1);
        }

        private ResourceChangeListener() {
            this.triggerFiles.add((IPath)new Path(SystemLibrariesContainer.FPROJ_METADATA_FILE));
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta subdelta = iResourceDeltaArray[n2];
                IProject project = (IProject)subdelta.getResource();
                boolean relevant = false;
                for (IPath p : this.triggerFiles) {
                    if (subdelta.findMember(p) == null) continue;
                    try {
                        if (!SystemLibrariesContainer.isOnClasspath(project)) break;
                        relevant = true;
                    }
                    catch (CoreException e) {
                        GlassfishToolsPlugin.logMessage("Error", (Exception)((Object)e));
                    }
                    break;
                }
                if (relevant) {
                    containersRefresherThread.addProjectToQueue(project);
                }
                ++n2;
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String containerLabel;

        static {
            Resources.initializeMessages((String)SystemLibrariesContainer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class RuntimeLifecycleListener
    implements IRuntimeLifecycleListener {
        private RuntimeLifecycleListener() {
        }

        public static void register() {
            ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)new RuntimeLifecycleListener());
        }

        public void runtimeAdded(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        public void runtimeChanged(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        public void runtimeRemoved(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        private void handleEvent(IRuntime runtime) {
            if (GlassFishTools.isGlassFish(runtime)) {
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    try {
                        if (SystemLibrariesContainer.isOnClasspath(project)) {
                            containersRefresherThread.addProjectToQueue(project);
                        }
                    }
                    catch (CoreException e) {
                        GlassfishToolsPlugin.logMessage("Error", (Exception)((Object)e));
                    }
                    ++n2;
                }
            }
        }
    }
}

