/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipFile;

public final class ManifestUtil {
    public static final String MANIFEST_FILE_NAME = "MANIFEST.MF";
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    private ManifestUtil() {
    }

    public static Manifest readManifest(File library) throws IOException {
        if (library.isFile()) {
            Manifest manifest;
            ZipFile zip = ManifestUtil.openZipFile(library);
            try {
                manifest = ManifestUtil.readManifest(zip);
            }
            catch (Throwable throwable) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            return manifest;
        }
        File manifestFile = new File(library, MANIFEST_PATH);
        if (manifestFile.exists()) {
            Manifest manifest;
            FileInputStream in = new FileInputStream(manifestFile);
            try {
                manifest = ManifestUtil.readManifest(new BufferedInputStream(in));
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
            return manifest;
        }
        return null;
    }

    public static Manifest readManifest(ZipFile zip) throws IOException {
        ZipEntry zipentry = ManifestUtil.getZipEntry(zip, MANIFEST_PATH);
        if (zipentry != null) {
            Manifest manifest;
            InputStream in = zip.getInputStream(zipentry);
            try {
                manifest = ManifestUtil.readManifest(in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            return manifest;
        }
        return null;
    }

    public static Manifest readManifest(InputStream stream) throws IOException {
        Manifest manifest = new Manifest();
        manifest.read(stream);
        return manifest;
    }

    public static String readManifestEntry(File location, String key) throws IOException {
        Manifest manifest = ManifestUtil.readManifest(location);
        if (manifest != null) {
            return ManifestUtil.readManifestEntry(manifest, key);
        }
        return null;
    }

    public static String readManifestEntry(Manifest manifest, String key) {
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            String name = ((Attributes.Name)entry.getKey()).toString();
            if (!key.equals(name)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private static ZipFile openZipFile(File file) throws IOException {
        try {
            return new ZipFile(file);
        }
        catch (FileNotFoundException e) {
            FileNotFoundException fnfe = new FileNotFoundException(file.getAbsolutePath());
            fnfe.initCause(e);
            throw fnfe;
        }
    }

    private static ZipEntry getZipEntry(ZipFile zip, String name) throws IOException {
        String lcasename = name.toLowerCase();
        try {
            Enumeration<? extends ZipEntry> itr = zip.entries();
            while (itr.hasMoreElements()) {
                ZipEntry zipentry = itr.nextElement();
                if (!zipentry.getName().toLowerCase().equals(lcasename)) continue;
                return zipentry;
            }
        }
        catch (ZipError e) {
            throw new IOException(e);
        }
        return null;
    }
}

