/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.handlers;

import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.ServerStatus;
import oracle.eclipse.tools.glassfish.handlers.AbstractGlassfishSelectionHandler;
import oracle.eclipse.tools.glassfish.log.GlassfishConsoleManager;
import oracle.eclipse.tools.glassfish.log.IGlassFishConsole;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.server.core.IServer;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.server.FetchLog;
import org.glassfish.tools.ide.server.FetchLogPiped;

public class ViewLogHandler
extends AbstractGlassfishSelectionHandler {
    @Override
    public void processSelection(IStructuredSelection selection) {
        IServer server = (IServer)selection.getFirstElement();
        try {
            GlassfishGenericServer serverAdapter = (GlassfishGenericServer)((Object)server.loadAdapter(GlassfishGenericServer.class, null));
            if (serverAdapter.isRemote()) {
                if (!serverAdapter.getServerBehaviourAdapter().getServerStatus(true).equals((Object)ServerStatus.RUNNING_DOMAIN_MATCHING)) {
                    this.showMessageDialog();
                    return;
                }
                GlassfishConsoleManager.removeServerLogFileConsole(serverAdapter);
            }
            IGlassFishConsole console = GlassfishConsoleManager.getServerLogFileConsole(serverAdapter);
            GlassfishConsoleManager.showConsole(console);
            if (!console.isLogging()) {
                console.startLogging(new FetchLog[]{FetchLogPiped.create((GlassFishServer)serverAdapter, (boolean)false)});
            }
        }
        catch (Exception e) {
            GlassfishToolsPlugin.logMessage("Error opening log: " + e.getMessage());
        }
    }
}

