/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.handlers;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import oracle.eclipse.tools.glassfish.utils.Utils;
import org.glassfish.tools.ide.data.GlassFishServer;

public class URIHelper {
    public static final void showURI(String uriParam) throws URISyntaxException, IOException {
        URI u = new URI(uriParam);
        Desktop d = Desktop.getDesktop();
        d.browse(u);
    }

    public static final void showURI(URI uri) throws IOException {
        Desktop d = Desktop.getDesktop();
        d.browse(uri);
    }

    public static final URI getServerAdminURI(GlassFishServer server) throws URISyntaxException {
        return new URI(Utils.getHttpListenerProtocol(server.getHost(), server.getAdminPort()), null, server.getHost(), server.getAdminPort(), null, null, null);
    }

    public static final URI getServerHomeURI(GlassFishServer server) throws URISyntaxException {
        return new File(server.getServerHome()).toURI();
    }

    public static final URI getDomainHomeURI(GlassFishServer server) throws URISyntaxException {
        return new File(String.valueOf(server.getDomainsFolder()) + File.separator + server.getDomainName()).toURI();
    }
}

