/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.facets.internal;

import oracle.eclipse.tools.glassfish.GlassFishInstall;
import oracle.eclipse.tools.glassfish.facets.internal.GlassfishDescriptorType;
import oracle.eclipse.tools.glassfish.facets.internal.GlassfishRootElementInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class GlassfishDescriptorRootController
extends StandardRootElementController {
    private GlassfishDescriptorType type;

    public void init(XmlResource resource) {
        super.init(resource);
        this.type = GlassfishDescriptorType.getDescriptorType(resource.element().type());
    }

    public void createRootElement() {
        Document document = ((RootXmlResource)this.resource().root()).getDomDocument();
        this.createRootElement(document);
    }

    protected void createRootElement(Document document) {
        GlassfishRootElementInfo gfRootInfo = this.getGlassfishRootElementInfo();
        Element root = document.createElementNS(null, gfRootInfo.getRootElementName());
        DocumentType doctype = null;
        doctype = gfRootInfo.getPublicId() != null ? document.getImplementation().createDocumentType(gfRootInfo.getRootElementName(), gfRootInfo.getPublicId(), gfRootInfo.getSystemId()) : document.getImplementation().createDocumentType(gfRootInfo.getRootElementName(), null, gfRootInfo.getSystemId());
        if (doctype != null) {
            document.appendChild(doctype);
            document.insertBefore(root, doctype);
        }
        document.appendChild(root);
    }

    public boolean checkRootElement() {
        DocumentType documentType;
        Document document = ((RootXmlResource)this.resource().root()).getDomDocument();
        Element root = document.getDocumentElement();
        GlassfishRootElementInfo gfRootInfo = this.getGlassfishRootElementInfo();
        return MiscUtil.equal((Object)root.getLocalName(), (Object)gfRootInfo.getRootElementName()) && (documentType = document.getDoctype()) != null && gfRootInfo.getSystemId().equals(documentType.getSystemId()) && MiscUtil.equal((Object)gfRootInfo.getPublicId(), (Object)MiscUtil.normalizeToNull((String)documentType.getPublicId()));
    }

    private GlassfishRootElementInfo getGlassfishRootElementInfo() {
        GlassfishRootElementInfo defaultInfo = GlassfishDescriptorType.getGlassfishRootElementInfo(this.type, GlassFishVersion.GF_4);
        GlassFishInstall gfInstall = GlassFishInstall.find((IProject)this.resource().adapt(IProject.class));
        if (gfInstall == null) {
            return defaultInfo;
        }
        Version v = gfInstall.version();
        GlassFishVersion gfVersion = GlassFishVersion.toValue((String)v.toString());
        if (gfVersion == null) {
            return defaultInfo;
        }
        GlassfishRootElementInfo rootInfo = GlassfishDescriptorType.getGlassfishRootElementInfo(this.type, gfVersion);
        return rootInfo != null ? rootInfo : defaultInfo;
    }
}

