/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import oracle.eclipse.tools.glassfish.AssembleModules;
import oracle.eclipse.tools.glassfish.ExportJavaEEArchive;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.Messages;
import oracle.eclipse.tools.glassfish.utils.Utils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.server.core.IModule;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandDeploy;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.ServerAdmin;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;

public class GlassfishV4ServerBehavior
extends GlassfishGenericServerBehaviour {
    public void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        File serverloc = new File(this.getSunAppServer().getServerInstallationDirectory());
        if (!serverloc.exists()) {
            GlassfishToolsPlugin.logMessage(NLS.bind((String)Messages.serverDirectoryGone, (Object)serverloc.getAbsolutePath()), null);
            return;
        }
        this.needARedeploy = true;
        long t = System.currentTimeMillis();
        if (module.length > 1) {
            this.setModulePublishState(module, 1);
        } else {
            this.publishModuleForGlassFishV3(kind, deltaKind, module, monitor);
            GlassfishToolsPlugin.logMessage("done publishModule in " + (System.currentTimeMillis() - t) + " ms");
        }
    }

    protected void publishModuleForGlassFishV3(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        block30: {
            Properties prop;
            IPath path;
            block28: {
                if (module.length > 1) {
                    this.setModulePublishState(module, 1);
                    return;
                }
                if (!this.publishNeeded(kind, deltaKind, module) || monitor.isCanceled()) {
                    return;
                }
                path = this.getTempDirectory().append("publish.txt");
                FileInputStream fis = null;
                prop = new Properties();
                try {
                    try {
                        fis = new FileInputStream(path.toFile());
                        prop.load(fis);
                    }
                    catch (Exception exception) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception2) {}
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (!this.getSunAppServer().isRemote() && this.getSunAppServer().getJarDeploy().equalsIgnoreCase("false")) {
                this.publishDeployedDirectory(deltaKind, prop, module, monitor);
            } else {
                this.publishJarFile(kind, deltaKind, prop, module, monitor);
            }
            this.setModulePublishState(module, 1);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(path.toFile());
                    prop.store(fos, "GlassFish 3");
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logMessage(" error in PUBLISH_STATE_NONE", e);
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void publishJarFile(int kind, int deltaKind, Properties p, IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (deltaKind == 3) {
            this.publishDeployedDirectory(deltaKind, p, module, monitor);
        } else {
            try {
                File archivePath = ExportJavaEEArchive.export(module[0], monitor);
                String name = Utils.simplifyModuleID(module[0].getName());
                String contextRoot = null;
                if (AssembleModules.isModuleType(module[0], "jst.web")) {
                    String projectContextRoot = ComponentUtilities.getServerContextRoot((IProject)module[0].getProject());
                    contextRoot = projectContextRoot != null && projectContextRoot.length() > 0 ? projectContextRoot : module[0].getName();
                }
                HashMap properties = new HashMap();
                File[] libraries = new File[]{};
                CommandDeploy command = new CommandDeploy(name, null, archivePath, contextRoot, properties, libraries);
                try {
                    Future future = ServerAdmin.exec((GlassFishServer)this.getSunAppServer(), (Command)command, (IdeContext)new IdeContext());
                    ResultString result = (ResultString)future.get(520L, TimeUnit.SECONDS);
                    if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                        GlassfishToolsPlugin.logMessage("deploy is failing=" + result.getValue());
                        throw new Exception("deploy is failing=" + result.getValue());
                    }
                }
                catch (Exception ex) {
                    GlassfishToolsPlugin.logMessage("deploy is failing=", ex);
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.glassfish", 0, "cannot Deploy " + name, (Throwable)ex));
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

