/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.BundleContext;

public class GlassfishToolsPlugin
extends AbstractUIPlugin {
    public static final String V31_RUNTIME = "org.glassfish.jst.server.runtime.glassfish31";
    public static final String V4_RUNTIME = "org.glassfish.jst.server.runtime.glassfish4";
    public static final String GF_SERVER_IMG = "gf-server.img";
    public static final String PLUGIN_ID = "oracle.eclipse.tools.glassfish";
    private static GlassfishToolsPlugin singleton;
    private static HashSet<String[]> commandsToExecuteAtExit;

    static {
        commandsToExecuteAtExit = new HashSet();
    }

    public GlassfishToolsPlugin() {
        singleton = this;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(GF_SERVER_IMG, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("icons/obj16/glassfishserver.gif")));
    }

    public void stop(BundleContext v) throws Exception {
        GlassfishToolsPlugin.logMessage("STOP IS CALLED!!!!!!!!!!!!!!!!");
        for (String[] command : commandsToExecuteAtExit) {
            try {
                GlassfishToolsPlugin.logMessage(">>> " + command[0], null);
                BufferedReader input = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream(), Charset.defaultCharset()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    GlassfishToolsPlugin.logMessage(">>> " + line, null);
                }
                input.close();
            }
            catch (Exception ex) {
                GlassfishToolsPlugin.logMessage("Error executing process:\n" + ex);
            }
        }
        super.stop(v);
    }

    public static GlassfishToolsPlugin getInstance() {
        return singleton;
    }

    public void addCommandToExecuteAtExit(String[] command) {
        for (Object[] objectArray : commandsToExecuteAtExit) {
            if (!Arrays.equals(objectArray, command)) continue;
            GlassfishToolsPlugin.logMessage("Command already there");
            return;
        }
        commandsToExecuteAtExit.add(command);
        GlassfishToolsPlugin.logMessage("addCommandToExecuteAtExit size=" + commandsToExecuteAtExit.size());
    }

    public static void logMessage(String mess) {
        IPreferenceStore store = GlassfishToolsPlugin.getInstance().getPreferenceStore();
        boolean trace = store.getBoolean("EnableLogPreference");
        if (trace) {
            Status status = new Status(1, PLUGIN_ID, 1, "GlassFish: " + mess, null);
            GlassfishToolsPlugin.getInstance().getLog().log((IStatus)status);
        }
    }

    public static void logMessage(String mess, Exception e) {
        Status status = new Status(4, PLUGIN_ID, 1, "GlassFish: " + mess, (Throwable)e);
        GlassfishToolsPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static IStatus createErrorStatus(String mess, Exception e) {
        return new Status(4, PLUGIN_ID, -1, mess, (Throwable)e);
    }

    public static boolean is31OrAbove(IRuntime runtime) {
        if (runtime.getRuntimeType().getId().equals(V31_RUNTIME)) {
            return true;
        }
        return runtime.getRuntimeType().getId().equals(V4_RUNTIME);
    }
}

