/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.ServerStatus;
import oracle.eclipse.tools.glassfish.StartupArgsImpl;
import oracle.eclipse.tools.glassfish.exceptions.HttpPortUpdateException;
import oracle.eclipse.tools.glassfish.log.GlassfishConsoleManager;
import oracle.eclipse.tools.glassfish.log.IGlassFishConsole;
import org.apache.tools.ant.taskdefs.Execute;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.glassfish.tools.ide.admin.ResultProcess;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.server.FetchLog;
import org.glassfish.tools.ide.server.FetchLogPiped;
import org.glassfish.tools.ide.server.ServerTasks;
import org.glassfish.tools.ide.utils.ServerUtils;
import org.glassfish.tools.ide.utils.Utils;

public class GlassfishServerLaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String GFV3_MODULES_DIR_NAME = "modules";
    private static final int MONITOR_TOTAL_WORK = 1000;
    private static final int WORK_STEP = 200;
    private static Pattern debugPortPattern = Pattern.compile("-\\S+jdwp[:=]\\S*address=([0-9]+)");

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.glassfish", code, message, exception));
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        GlassfishGenericServerBehaviour serverBehavior;
        block14: {
            GlassfishToolsPlugin.logMessage("in SUN SunAppServerLaunch launch");
            monitor.beginTask("Starting GlassFish", 1000);
            IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
            if (server == null) {
                this.abort("missing Server", null, 150);
            }
            serverBehavior = (GlassfishGenericServerBehaviour)server.loadAdapter(ServerBehaviourDelegate.class, null);
            GlassfishGenericServer serverAdapter = serverBehavior.getSunAppServer();
            try {
                this.checkMonitorAndProgress(monitor, 200);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            boolean isRunning = this.isRunning(serverBehavior);
            if (isRunning) {
                GlassfishToolsPlugin.logMessage("server is already started!!!");
            }
            try {
                if (serverAdapter.isRemote()) {
                    if (!isRunning) {
                        this.abort("GlassFish Remote Servers cannot be start from this machine.", null, 150);
                    }
                } else if (!isRunning) {
                    this.startDASAndTarget(serverAdapter, serverBehavior, configuration, launch, mode, monitor);
                }
            }
            catch (InterruptedException e) {
                IGlassFishConsole console = GlassfishConsoleManager.getStandardConsole(serverAdapter);
                console.stopLogging(3);
                GlassfishToolsPlugin.logMessage("Server start interrupted.", e);
                serverBehavior.setGFServerState(4);
                this.abort("Unable to start server due interruption.", e, 150);
                monitor.done();
                break block14;
            }
            catch (CoreException e) {
                try {
                    IGlassFishConsole console = GlassfishConsoleManager.getStandardConsole(serverAdapter);
                    console.stopLogging(3);
                    serverBehavior.setGFServerState(4);
                    throw e;
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
        }
        ((Server)serverBehavior.getServer()).setMode(mode);
    }

    private void startDASAndTarget(GlassfishGenericServer serverAdapter, GlassfishGenericServerBehaviour serverBehavior, ILaunchConfiguration configuration, ILaunch launch, String mode, IProgressMonitor monitor) throws CoreException, InterruptedException {
        String domain = serverAdapter.getDomainName();
        String domainAbsolutePath = serverAdapter.getDomainPath();
        File bootstrapJar = ServerUtils.getJarName((String)serverAdapter.getServerInstallationDirectory(), (String)"glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (bootstrapJar == null) {
            this.abort("bootstrap jar not found", null, 150);
        }
        AbstractVMInstall vm = (AbstractVMInstall)serverBehavior.getRuntimeDelegate().getVMInstall();
        StartupArgsImpl startArgs = new StartupArgsImpl();
        startArgs.setJavaHome(vm.getInstallLocation().getAbsolutePath());
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        ServerTasks.StartMode startMode = ServerTasks.StartMode.START;
        if ("debug".equals(mode)) {
            startMode = ServerTasks.StartMode.DEBUG;
        } else {
            vmArgs = this.ignoreDebugArgs(vmArgs);
        }
        startArgs.addJavaArgs(vmArgs);
        startArgs.addGlassfishArgs(pgmArgs);
        startArgs.addGlassfishArgs("--domain " + domain);
        startArgs.addGlassfishArgs("--domaindir " + Utils.quote((String)domainAbsolutePath));
        IPreferenceStore store = GlassfishToolsPlugin.getInstance().getPreferenceStore();
        this.setDefaultSourceLocator(launch, configuration);
        boolean javaDBStart = store.getBoolean("EnableStartJavaDBPreference");
        this.checkMonitorAndProgress(monitor, 200);
        Process processDB = null;
        Process processGF = null;
        if (javaDBStart) {
            String[] stringArray;
            String sampleDBDir = store.getString("JavaDBLocation");
            if (sampleDBDir == null) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = vm.getInstallLocation() + "/bin/java";
                stringArray2[1] = "-jar";
                stringArray2[2] = String.valueOf(serverAdapter.getServerInstallationDirectory()) + "/modules/admin-cli.jar";
                stringArray = stringArray2;
                stringArray2[3] = "start-database";
            } else {
                String[] stringArray3 = new String[6];
                stringArray3[0] = vm.getInstallLocation() + "/bin/java";
                stringArray3[1] = "-jar";
                stringArray3[2] = String.valueOf(serverAdapter.getServerInstallationDirectory()) + "/modules/admin-cli.jar";
                stringArray3[3] = "start-database";
                stringArray3[4] = "--dbhome";
                stringArray = stringArray3;
                stringArray3[5] = sampleDBDir;
            }
            String[] command = stringArray;
            try {
                processDB = Execute.launch(null, (String[])command, null, (File)new File(serverAdapter.getServerInstallationDirectory()), (boolean)true);
                DebugPlugin.newProcess((ILaunch)launch, (Process)processDB, (String)"Derby Database");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.abort("Unable to start database!", e, 116);
            }
            GlassfishToolsPlugin.getInstance().addCommandToExecuteAtExit(new String[]{vm.getInstallLocation() + "/bin/java", "-jar", String.valueOf(serverAdapter.getServerInstallationDirectory()) + "/modules/admin-cli.jar", "stop-database"});
        }
        this.checkMonitorAndProgress(monitor, 200);
        this.startLogging(serverAdapter, serverBehavior);
        ResultProcess process = null;
        try {
            process = serverBehavior.launchServer(startArgs, startMode, monitor);
            processGF = process.getValue().getProcess();
        }
        catch (TimeoutException e) {
            this.killProcesses(processDB);
            this.abort("Unable to start server on time.", e, 150);
        }
        catch (ExecutionException e) {
            this.killProcesses(processDB);
            this.abort("Unable to start server due following issues:", e.getCause(), 150);
        }
        catch (HttpPortUpdateException e) {
            this.killProcesses(processDB);
            this.abort("Unable to update http port. Server shut down.", e, 150);
        }
        try {
            this.checkMonitorAndProgress(monitor, 200);
        }
        catch (InterruptedException e) {
            this.killProcesses(processGF, processDB);
            throw e;
        }
        this.setDefaultSourceLocator(launch, configuration);
        if (mode.equals("debug")) {
            HashMap<String, String> arg = new HashMap<String, String>();
            Integer debugPort = null;
            try {
                debugPort = GlassfishServerLaunchDelegate.getDebugPort(process.getValue().getArguments());
            }
            catch (NumberFormatException e) {
                this.killProcesses(processGF, processDB);
                this.abort("Server run in debug mode but the debug port couldn't be determined!", e, 150);
            }
            catch (IllegalArgumentException e) {
                this.killProcesses(processGF, processDB);
                this.abort("Server run in debug mode but the debug port couldn't be determined!", e, 150);
            }
            arg.put("hostname", "localhost");
            arg.put("port", debugPort.toString());
            arg.put("timeout", "25000");
            String connectorId = this.getVMConnectorId(configuration);
            IVMConnector connector = null;
            connector = connectorId == null ? JavaRuntime.getDefaultVMConnector() : JavaRuntime.getVMConnector((String)connectorId);
            connector.connect(arg, monitor, launch);
            Server server = (Server)ServerUtil.getServer((ILaunchConfiguration)configuration);
            server.setServerStatus((IStatus)new Status(0, "oracle.eclipse.tools.glassfish", "Debugging"));
        }
    }

    private String ignoreDebugArgs(String vmArgs) {
        StringBuilder args = new StringBuilder(vmArgs.length());
        String[] stringArray = vmArgs.split("\\s");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if ("-Xdebug".equalsIgnoreCase(a) || a.startsWith("-agentlib") || a.startsWith("-Xrunjdwp")) break;
            args.append(a);
            args.append(" ");
            ++n2;
        }
        return args.toString();
    }

    private void killProcesses(Process ... process) {
        Process[] processArray = process;
        int n = process.length;
        int n2 = 0;
        while (n2 < n) {
            Process p = processArray[n2];
            if (p != null) {
                p.destroy();
            }
            ++n2;
        }
    }

    private boolean isRunning(GlassfishGenericServerBehaviour serverBehavior) throws CoreException {
        ServerStatus status = serverBehavior.getServerStatus(true);
        switch (status) {
            case RUNNING_CONNECTION_ERROR: {
                this.abort("The Eclipse plugin cannot communicate with the GlassFish server....", new RuntimeException("The Eclipse plugin cannot communicate with the GlassFish server.Please, check for antivirus software blocking or monitoring this port, or firewall configuration, or VPN setup which might block some ports..."), 150);
                break;
            }
            case RUNNING_CREDENTIAL_PROBLEM: {
                this.abort("The Eclipse plugin cannot communicate with the GlassFish server....", new RuntimeException("The Eclipse plugin cannot communicate with the GlassFish server.Wrong user name or password."), 150);
                break;
            }
            case RUNNING_DOMAIN_MATCHING: {
                return true;
            }
            case RUNNING_PROXY_ERROR: {
                this.abort("The Eclipse plugin cannot communicate with the GlassFish server....", new RuntimeException("The Eclipse plugin cannot communicate with the GlassFish server. The response code BAD GATEWAY was returned. Please check your proxy settings."), 150);
                break;
            }
            case STOPPED_DOMAIN_NOT_MATCHING: {
                this.abort("Please, check the other GlassFish Application Server process and stop it.", new RuntimeException("A GlassFish Enterprise Server is running on this port, but with a different root installation..."), 150);
                break;
            }
            case STOPPED_NOT_LISTENING: {
                return false;
            }
        }
        return false;
    }

    private void startLogging(final GlassfishGenericServer serverAdapter, GlassfishGenericServerBehaviour serverBehavior) {
        try {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    File logFile = new File(String.valueOf(serverAdapter.getDomainPath()) + "/logs/server.log");
                    try {
                        logFile.createNewFile();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    IGlassFishConsole console = GlassfishConsoleManager.getStandardConsole(serverAdapter);
                    GlassfishConsoleManager.showConsole(console);
                    if (!console.isLogging()) {
                        console.startLogging(new FetchLog[]{FetchLogPiped.create((GlassFishServer)serverAdapter, (boolean)true)});
                    }
                }
            });
        }
        catch (Exception e) {
            GlassfishToolsPlugin.logMessage("page.showView", e);
        }
    }

    private void checkMonitorAndProgress(IProgressMonitor monitor, int work) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.worked(work);
    }

    private static Integer getDebugPort(String startArgs) {
        Matcher m = debugPortPattern.matcher(startArgs);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        throw new IllegalArgumentException("Debug port not found in process args!");
    }

    class GlassfishServerDebugListener
    implements IDebugEventSetListener {
        private GlassfishGenericServerBehaviour serverBehavior;
        private String debugTargetIdentifier;

        public GlassfishServerDebugListener(GlassfishGenericServerBehaviour serverBehavior, String debugTargetIdentifier) {
            this.serverBehavior = serverBehavior;
            this.debugTargetIdentifier = debugTargetIdentifier;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (events != null) {
                int size = events.length;
                int i = 0;
                while (i < size) {
                    if (events[i].getSource() instanceof JDIDebugTarget) {
                        JDIDebugTarget dt = (JDIDebugTarget)events[i].getSource();
                        try {
                            GlassfishToolsPlugin.logMessage("JDIDebugTarget=" + dt.getName());
                            if (dt.getName().indexOf(this.debugTargetIdentifier) != -1 && events[i].getKind() == 8) {
                                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                                if (!dt.isTerminated()) {
                                    this.serverBehavior.stop(true);
                                }
                                Server server = (Server)this.serverBehavior.getServer();
                                server.setServerStatus(null);
                            }
                        }
                        catch (DebugException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

