/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.utils.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public class GlassfishLaunchableAdapterDelegate
extends LaunchableAdapterDelegate {
    public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        WebResource resource;
        String path;
        URL url;
        block15: {
            IURLProvider delegate;
            block14: {
                if (server == null) {
                    return null;
                }
                String serverTypeId = server.getServerType().getId();
                if (!serverTypeId.startsWith("org.glassfish.jst.server")) {
                    return null;
                }
                GlassfishGenericServer glassfish = (GlassfishGenericServer)((Object)server.loadAdapter(GlassfishGenericServer.class, (IProgressMonitor)new NullProgressMonitor()));
                if (glassfish == null) {
                    return null;
                }
                if (!(moduleArtifact instanceof Servlet) && !(moduleArtifact instanceof WebResource)) {
                    return null;
                }
                if (!Utils.hasProjectFacet(moduleArtifact.getModule(), ProjectFacetsManager.getProjectFacet((String)"jst.web"))) {
                    return null;
                }
                try {
                    delegate = (IURLProvider)server.loadAdapter(IURLProvider.class, null);
                    if (delegate != null) break block14;
                    return null;
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logMessage("Error getting URL for " + moduleArtifact, e);
                    return null;
                }
            }
            url = delegate.getModuleRootURL(moduleArtifact.getModule());
            if (url != null) break block15;
            return null;
        }
        if (moduleArtifact instanceof Servlet) {
            String path2;
            String base;
            Servlet servlet = (Servlet)moduleArtifact;
            if (servlet.getAlias() != null) {
                base = this.normalize(url.getFile());
                path2 = this.normalize(servlet.getAlias());
                url = new URL(url, String.valueOf(base) + path2);
            } else {
                base = "/servlet";
                path2 = servlet.getServletClassName();
            }
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(base) + path2);
        } else if (moduleArtifact instanceof WebResource && (path = this.normalize((resource = (WebResource)moduleArtifact).getPath().toPortableString())).length() != 0) {
            String base = this.normalize(url.getFile());
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(base) + path);
        }
        return new HttpLaunchable(new UrlPathEncoder(url).asURL());
    }

    private String normalize(String path) {
        if (path == null) {
            return "";
        }
        if (path.equals("/")) {
            return "";
        }
        if (path.length() > 0 && path.endsWith("/")) {
            return path.substring(0, path.length() - 2);
        }
        if (path.length() > 0 && !path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    static class UrlPathEncoder {
        private URL _url = null;

        public UrlPathEncoder(URL theUrl) throws MalformedURLException {
            this(theUrl.toString());
        }

        public UrlPathEncoder(String urlString) throws MalformedURLException {
            try {
                String urlStringDecoded = URLDecoder.decode(urlString, "UTF-8");
                URL tmpUrl = new URL(urlStringDecoded);
                String query = tmpUrl.getQuery();
                StringBuilder path = new StringBuilder();
                path.append(URLEncoder.encode(tmpUrl.getPath(), "UTF-8").replaceAll("%2[fF]", "/"));
                if (query != null) {
                    path.append("?").append(URLEncoder.encode(query, "UTF-8"));
                }
                this._url = new URL(tmpUrl.getProtocol(), tmpUrl.getHost(), tmpUrl.getPort(), path.toString());
            }
            catch (UnsupportedEncodingException uee) {
                GlassfishToolsPlugin.logMessage("Fatal: Unsupported encoding", uee);
            }
        }

        public String asString() {
            return this._url.toString();
        }

        public URL asURL() {
            return this._url;
        }
    }
}

