/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.eclipse.tools.glassfish.AssembleModules;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.ServerStatus;
import oracle.eclipse.tools.glassfish.StartupArgsImpl;
import oracle.eclipse.tools.glassfish.derby.DerbyConfigurator;
import oracle.eclipse.tools.glassfish.exceptions.GlassfishLaunchException;
import oracle.eclipse.tools.glassfish.exceptions.HttpPortUpdateException;
import oracle.eclipse.tools.glassfish.internal.GlassfishStateResolver;
import oracle.eclipse.tools.glassfish.internal.ServerStateListener;
import oracle.eclipse.tools.glassfish.internal.ServerStatusMonitor;
import oracle.eclipse.tools.glassfish.log.GlassfishConsoleManager;
import oracle.eclipse.tools.glassfish.log.IGlassFishConsole;
import oracle.eclipse.tools.glassfish.utils.ResourceUtils;
import oracle.eclipse.tools.glassfish.utils.Utils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.generic.core.internal.GenericServerBehaviour;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.util.PublishHelper;
import org.glassfish.tools.ide.GlassFishIdeException;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandAddResources;
import org.glassfish.tools.ide.admin.CommandDeploy;
import org.glassfish.tools.ide.admin.CommandGetProperty;
import org.glassfish.tools.ide.admin.CommandStopDAS;
import org.glassfish.tools.ide.admin.CommandUndeploy;
import org.glassfish.tools.ide.admin.CommandVersion;
import org.glassfish.tools.ide.admin.ResultMap;
import org.glassfish.tools.ide.admin.ResultProcess;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.ServerAdmin;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.data.StartupArgs;
import org.glassfish.tools.ide.server.FetchLog;
import org.glassfish.tools.ide.server.FetchLogSimple;
import org.glassfish.tools.ide.server.ServerTasks;

public abstract class GlassfishGenericServerBehaviour
extends GenericServerBehaviour
implements ServerStateListener {
    private static final String DEFAULT_DOMAIN_DIR_NAME = "domains";
    private static final String DEFAULT_DOMAIN_NAME = "domain1";
    protected boolean needARedeploy = true;
    private GlassfishStateResolver stateResolver = new GlassfishStateResolver();
    private ServerStatusMonitor statusMonitor;
    private static final ExecutorService asyncJobsService = Executors.newCachedThreadPool();

    public GlassfishGenericServerBehaviour() {
        GlassfishToolsPlugin.logMessage("in SunAppServerBehaviour CTOR ");
    }

    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        GlassfishToolsPlugin.logMessage("in Behaviour initialize for " + this.getSunAppServer().getName());
        GlassfishGenericServer sunserver = this.getSunAppServer();
        this.statusMonitor = ServerStatusMonitor.getInstance(sunserver, this);
        this.statusMonitor.start();
        try {
            if (!sunserver.isRemote()) {
                DerbyConfigurator.configure(null, new File(sunserver.getServerInstallationDirectory()), sunserver.getDomainConfigurationFilePath());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        this.statusMonitor.stop();
        GlassfishToolsPlugin.logMessage("in Behaviour dispose for " + this.getSunAppServer().getName());
    }

    public IStatus canRestart(String mode) {
        if (this.getSunAppServer().isRemote()) {
            return new Status(4, "oracle.eclipse.tools.glassfish", "Restart remote Glassfish server is not supported");
        }
        return super.canRestart(mode);
    }

    public IStatus canStart(String launchMode) {
        if (this.getSunAppServer().isRemote()) {
            return new Status(4, "oracle.eclipse.tools.glassfish", "Start remote Glassfish server is not supported");
        }
        return super.canStart(launchMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStatusChanged(ServerStatus newStatus) {
        GlassfishGenericServerBehaviour glassfishGenericServerBehaviour = this;
        synchronized (glassfishGenericServerBehaviour) {
            int currentState = this.getServer().getServerState();
            int nextState = this.stateResolver.resolve(newStatus, currentState);
            if (currentState != nextState) {
                this.setGFServerState(nextState);
                this.serverStateChanged(nextState);
                this.updateServerStatus(newStatus);
            }
            this.notify();
        }
    }

    private void serverStateChanged(int serverState) {
        switch (serverState) {
            case 2: {
                try {
                    this.updateHttpPort();
                }
                catch (HttpPortUpdateException e) {
                    GlassfishToolsPlugin.logMessage("Unable to update HTTP port for server startedoutside of IDE!", e);
                }
                break;
            }
        }
    }

    public ServerStatus getServerStatus(boolean forceUpdate) {
        return this.statusMonitor.getServerStatus(forceUpdate);
    }

    public GlassfishGenericServer getSunAppServer() {
        GlassfishGenericServer sunserver = (GlassfishGenericServer)((Object)this.getServer().getAdapter(GlassfishGenericServer.class));
        if (sunserver == null) {
            sunserver = (GlassfishGenericServer)((Object)this.getServer().loadAdapter(GlassfishGenericServer.class, (IProgressMonitor)new NullProgressMonitor()));
        }
        return sunserver;
    }

    ResultProcess launchServer(StartupArgsImpl gfStartArguments, ServerTasks.StartMode launchMode, IProgressMonitor monitor) throws TimeoutException, InterruptedException, ExecutionException, HttpPortUpdateException {
        this.setGFServerState(1);
        ResultProcess p = null;
        StartJob j = new StartJob(gfStartArguments, launchMode);
        Future<ResultProcess> res = asyncJobsService.submit(j);
        try {
            p = res.get(this.getServer().getStartTimeout(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            res.cancel(true);
            throw e;
        }
        this.updateHttpPort();
        return p;
    }

    protected synchronized void setGFServerState(int state) {
        this.setServerState(state);
    }

    private void resetStatus(int state) {
        if (state == 0) {
            this.setServerStatus(null);
        }
    }

    public GenericServerRuntime getRuntimeDelegate() {
        return (GenericServerRuntime)this.getServer().getRuntime().loadAdapter(GenericServerRuntime.class, null);
    }

    public static String getVersion(GlassfishGenericServer server) throws GlassFishIdeException {
        CommandVersion command = new CommandVersion();
        IdeContext ide = new IdeContext();
        Future future = ServerAdmin.exec((GlassFishServer)server, (Command)command, (IdeContext)ide);
        try {
            ResultString result = (ResultString)future.get(30L, TimeUnit.SECONDS);
            return result.getValue();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("Exception by calling getVersion", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("Exception by calling getVersion", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new GlassFishIdeException("Timeout for getting version command exceeded", (Throwable)e);
        }
    }

    public void restart(final String launchMode) throws CoreException {
        GlassfishToolsPlugin.logMessage("in SunAppServerBehaviour restart");
        this.stopServer(false);
        Thread thread = new Thread("Synchronous server start"){

            @Override
            public void run() {
                try {
                    GlassfishGenericServerBehaviour.this.getServer().getLaunchConfiguration(true, null).launch(launchMode, (IProgressMonitor)new NullProgressMonitor());
                    GlassfishToolsPlugin.logMessage("in SunAppServerBehaviour restart done");
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logMessage("in SunAppServerBehaviour restart", e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void stop(boolean force) {
        GlassfishToolsPlugin.logMessage("in SunAppServerBehaviour stop");
        this.stopServer(true);
    }

    protected void stopServer(boolean stopLogging) {
        final GlassfishGenericServer server = this.getSunAppServer();
        if (server.isRemote()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean answer = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Stopping a remote sever", (String)"Are you sure you want to stop a remote domain? \nYou will not be able to start it again from this machine...");
                    if (answer) {
                        GlassfishGenericServerBehaviour.this.stopImpl(server);
                    }
                }
            });
            return;
        }
        this.stopImpl(server);
        if (stopLogging) {
            GlassfishConsoleManager.getStandardConsole(server).stopLogging(3);
        }
    }

    private void stopImpl(GlassfishGenericServer server) {
        this.setGFServerState(3);
        StopJob j = new StopJob();
        Future<Object> res = asyncJobsService.submit(j);
        try {
            res.get(this.getServer().getStopTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            GlassfishToolsPlugin.logMessage("Stop server could not be finished because of exception.", e);
        }
        catch (TimeoutException timeoutException) {
            res.cancel(true);
            GlassfishToolsPlugin.logMessage("Stop server could not be finished in time.");
        }
    }

    protected String getConfigTypeID() {
        return "oracle.eclipse.tools.glassfish.SunAppServerLaunchConfigurationType";
    }

    public void undeploy(String moduleName, IProgressMonitor monitor) throws CoreException {
        this.undeploy(moduleName);
        List moduleList = this.getAllModules();
        IModule[] module = null;
        for (IModule[] m : moduleList) {
            if (m.length != 1 || !m[0].getName().equals(moduleName)) continue;
            module = m;
            break;
        }
        if (module != null) {
            this.setModulePublishState(module, 3);
        }
    }

    public void undeploy(String moduleName) throws CoreException {
        CommandUndeploy cmd = new CommandUndeploy(moduleName, null);
        try {
            Future future = ServerAdmin.exec((GlassFishServer)this.getSunAppServer(), (Command)cmd, (IdeContext)new IdeContext());
            ResultString result = (ResultString)future.get(520L, TimeUnit.SECONDS);
            if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                GlassfishToolsPlugin.logMessage("undeploy is failing=" + result.getValue());
                throw new Exception("undeploy is failing=" + result.getValue());
            }
        }
        catch (Exception ex) {
            GlassfishToolsPlugin.logMessage("Undeploy is failing=", ex);
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.glassfish", 0, "cannot UnDeploy " + moduleName, (Throwable)ex));
        }
    }

    protected boolean publishNeeded(int kind, int deltaKind, IModule[] module) {
        if (kind != 1 && kind != 3) {
            return true;
        }
        if (deltaKind != 0) {
            return true;
        }
        if (module[0] instanceof DeletedModule) {
            return false;
        }
        if (AssembleModules.isModuleType(module[0], "jst.ear")) {
            IEnterpriseApplication earModule = (IEnterpriseApplication)module[0].loadAdapter(IEnterpriseApplication.class, (IProgressMonitor)new NullProgressMonitor());
            IModule[] childModules = earModule.getModules();
            int i = 0;
            while (i < childModules.length) {
                IModule m = childModules[i];
                IModule[] modules = new IModule[]{module[0], m};
                if (1 != this.getSunAppServer().getServer().getModulePublishState(modules)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void publishDeployedDirectory(int deltaKind, Properties p, IModule[] module, IProgressMonitor monitor) throws CoreException {
        PublishHelper helper = new PublishHelper(new Path(String.valueOf(this.getSunAppServer().getDomainPath()) + "/eclipseAppsTmp").toFile());
        if (deltaKind == 3) {
            String publishPath = (String)p.get(module[0].getId());
            GlassfishToolsPlugin.logMessage("REMOVED in publishPath" + publishPath);
            String name = Utils.simplifyModuleID(module[0].getName());
            try {
                this.undeploy(name);
            }
            catch (Exception exception) {}
            if (publishPath == null) return;
            try {
                File pub = new File(publishPath);
                if (!pub.exists()) return;
                GlassfishToolsPlugin.logMessage("PublishUtil.deleteDirectory called");
                IStatus[] stat = PublishHelper.deleteDirectory((File)pub, (IProgressMonitor)monitor);
                this.analyseReturnedStatus(stat);
                return;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(2, "oracle.eclipse.tools.glassfish", 0, "cannot remove " + module[0].getName(), (Throwable)e));
            }
        }
        Path path = new Path(String.valueOf(this.getSunAppServer().getDomainPath()) + "/eclipseApps/" + module[0].getName());
        String contextRoot = null;
        AssembleModules assembler = new AssembleModules(module, (IPath)path, this.getSunAppServer(), helper);
        GlassfishToolsPlugin.logMessage("PublishUtil.publishSmart called");
        if (module[0] instanceof DeletedModule) {
            return;
        }
        if (AssembleModules.isModuleType(module[0], "jst.web")) {
            GlassfishToolsPlugin.logMessage("is WEB");
            assembler.assembleWebModule(monitor);
            this.needARedeploy = assembler.needsARedeployment();
            String projectContextRoot = ComponentUtilities.getServerContextRoot((IProject)module[0].getProject());
            contextRoot = projectContextRoot != null && projectContextRoot.length() > 0 ? projectContextRoot : module[0].getName();
        } else if (AssembleModules.isModuleType(module[0], "jst.ear")) {
            GlassfishToolsPlugin.logMessage("is EAR");
            assembler.assembleDirDeployedEARModule(monitor);
            this.needARedeploy = assembler.needsARedeployment();
        } else {
            assembler.assembleNonWebOrNonEARModule(monitor);
            this.needARedeploy = assembler.needsARedeployment();
        }
        this.registerSunResource(module, p, (IPath)path);
        String spath = "" + path;
        if (this.needARedeploy) {
            String name = Utils.simplifyModuleID(module[0].getName());
            HashMap properties = new HashMap();
            File[] libraries = new File[]{};
            CommandDeploy command = new CommandDeploy(name, null, new File(spath), contextRoot, properties, libraries);
            try {
                Future future = ServerAdmin.exec((GlassFishServer)this.getSunAppServer(), (Command)command, (IdeContext)new IdeContext());
                ResultString result = (ResultString)future.get(300L, TimeUnit.SECONDS);
                if (TaskState.COMPLETED.equals((Object)result.getState())) return;
                GlassfishToolsPlugin.logMessage("deploy is failing=" + result.getValue());
                throw new Exception("deploy is failing=" + result.getValue());
            }
            catch (Exception ex) {
                GlassfishToolsPlugin.logMessage("deploy is failing=", ex);
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.glassfish", 0, "cannot Deploy " + name, (Throwable)ex));
            }
        }
        GlassfishToolsPlugin.logMessage("optimal: NO NEED TO TO A REDEPLOYMENT, !!!");
    }

    public void updateHttpPort() throws HttpPortUpdateException {
        GlassfishGenericServer server = this.getSunAppServer();
        CommandGetProperty cgp = new CommandGetProperty("*.server-config.*.http-listener-1.port");
        Future future = ServerAdmin.exec((GlassFishServer)this.getSunAppServer(), (Command)cgp, (IdeContext)new IdeContext());
        ResultMap result = null;
        try {
            result = (ResultMap)future.get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            GlassfishToolsPlugin.logMessage("Unable to retrieve server http port for server ", e);
            throw new HttpPortUpdateException(e);
        }
        catch (ExecutionException e) {
            GlassfishToolsPlugin.logMessage("Unable to retrieve server http port for target ", e);
            throw new HttpPortUpdateException(e);
        }
        catch (TimeoutException e) {
            GlassfishToolsPlugin.logMessage("Unable to retrieve server http port for target ", e);
            throw new HttpPortUpdateException(e);
        }
        if (result != null && TaskState.COMPLETED.equals((Object)result.getState())) {
            for (Map.Entry entry : result.getValue().entrySet()) {
                String val = (String)entry.getValue();
                try {
                    if (val == null || val.trim().length() <= 0) continue;
                    Integer.parseInt(val);
                    server.getProps().put("sunappserver.serverportnumber", val);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new HttpPortUpdateException(nfe);
                }
            }
        }
    }

    protected void registerSunResource(IModule[] module, Properties p, IPath path) throws CoreException {
        IProject project = module[0].getProject();
        String location = ResourceUtils.getRuntimeResourceLocation(project);
        if (location != null) {
            location = location.trim().length() > 0 ? String.valueOf(location) + File.separatorChar + "sun-resources.xml" : "sun-resources.xml";
            File sunResource = new File("" + path, location);
            if (sunResource.exists()) {
                ResourceUtils.checkUpdateServerResources(sunResource, this.getSunAppServer());
                CommandAddResources command = new CommandAddResources(sunResource, null);
                try {
                    Future future = ServerAdmin.exec((GlassFishServer)this.getSunAppServer(), (Command)command, (IdeContext)new IdeContext());
                    ResultString result = (ResultString)future.get(120L, TimeUnit.SECONDS);
                    if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                        GlassfishToolsPlugin.logMessage("register resource is failing=" + result.getValue());
                        throw new Exception("register resource is failing=" + result.getValue());
                    }
                }
                catch (Exception ex) {
                    GlassfishToolsPlugin.logMessage("deploy of sun-resources is failing ", ex);
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.glassfish", 0, "cannot register sun-resource.xml for " + module[0].getName(), (Throwable)ex));
                }
            }
            p.put(module[0].getId(), path.toOSString());
        }
    }

    protected void analyseReturnedStatus(IStatus[] status) throws CoreException {
        if (status == null || status.length == 0) {
            return;
        }
        IStatus[] iStatusArray = status;
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s = iStatusArray[n2];
            GlassfishToolsPlugin.logMessage("analyseReturnedStatus: " + s.getMessage());
            ++n2;
        }
    }

    public void updateServerStatus() {
        ServerStatus status = this.getServerStatus(true);
        this.updateServerStatus(status);
    }

    private void updateServerStatus(ServerStatus status) {
        Server server2 = (Server)this.getServer();
        if (status != ServerStatus.RUNNING_DOMAIN_MATCHING) {
            server2.setServerState(4);
            switch (status) {
                case RUNNING_CREDENTIAL_PROBLEM: {
                    server2.setServerStatus(GlassfishToolsPlugin.createErrorStatus("Invalid user name or password", null));
                    break;
                }
                case STOPPED_DOMAIN_NOT_MATCHING: {
                    server2.setServerStatus(GlassfishToolsPlugin.createErrorStatus("Running Glassfish domain detected but its path does not match this server", null));
                    break;
                }
                case RUNNING_CONNECTION_ERROR: {
                    server2.setServerStatus(GlassfishToolsPlugin.createErrorStatus("Connection error when trying to communicate with server.", null));
                }
                default: {
                    server2.setServerStatus(null);
                }
            }
            server2.setServerState(4);
        } else {
            server2.setServerStatus(null);
            server2.setServerState(2);
        }
    }

    private class StartJob
    implements Callable<ResultProcess> {
        private StartupArgsImpl args;
        private ServerTasks.StartMode mode;

        StartJob(StartupArgsImpl args, ServerTasks.StartMode mode) {
            this.args = args;
            this.mode = mode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ResultProcess call() throws Exception {
            ResultProcess process = null;
            try {
                process = ServerTasks.startServer((GlassFishServer)GlassfishGenericServerBehaviour.this.getSunAppServer(), (StartupArgs)this.args, (ServerTasks.StartMode)this.mode);
            }
            catch (GlassFishIdeException e) {
                throw new GlassfishLaunchException("Exception in startup library.", e);
            }
            Process gfProcess = process.getValue().getProcess();
            IGlassFishConsole startupConsole = GlassfishConsoleManager.getStartupProcessConsole(GlassfishGenericServerBehaviour.this.getSunAppServer(), gfProcess);
            startupConsole.startLogging(new FetchLog[]{new FetchLogSimple(gfProcess.getInputStream()), new FetchLogSimple(gfProcess.getErrorStream())});
            GlassfishGenericServerBehaviour glassfishGenericServerBehaviour = GlassfishGenericServerBehaviour.this;
            synchronized (glassfishGenericServerBehaviour) {
                block15: while (true) {
                    ServerStatus status = GlassfishGenericServerBehaviour.this.getServerStatus(false);
                    switch (status) {
                        case STOPPED_NOT_LISTENING: {
                            try {
                                int exit_code = gfProcess.exitValue();
                                System.out.println("Process exit code: " + exit_code);
                                if (exit_code != 0) {
                                    GlassfishToolsPlugin.logMessage("launch failed with exit code " + exit_code);
                                    GlassfishConsoleManager.showConsole(startupConsole);
                                    throw new GlassfishLaunchException("Launch process failed with exit code " + exit_code);
                                }
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {}
                            break;
                        }
                        case RUNNING_PROXY_ERROR: {
                            startupConsole.stopLogging();
                            gfProcess.destroy();
                            throw new GlassfishLaunchException("BAD GATEWAY response code returned. Check your proxy settings. Killing startup process.", gfProcess);
                        }
                        case RUNNING_CREDENTIAL_PROBLEM: {
                            startupConsole.stopLogging();
                            gfProcess.destroy();
                            throw new GlassfishLaunchException("Wrong user name or password. Killing startup process.", gfProcess);
                        }
                        case RUNNING_DOMAIN_MATCHING: {
                            startupConsole.stopLogging();
                            break block15;
                        }
                    }
                    try {
                        GlassfishGenericServerBehaviour.this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("StartJob interrupted, killing startup process");
                        startupConsole.stopLogging();
                        gfProcess.destroy();
                        throw e;
                    }
                }
                return process;
            }
        }
    }

    private class StopJob
    implements Callable<Object> {
        private StopJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            ResultString result = null;
            try {
                result = CommandStopDAS.stopDAS((GlassFishServer)GlassfishGenericServerBehaviour.this.getSunAppServer());
            }
            catch (GlassFishIdeException e) {
                GlassfishToolsPlugin.logMessage("Stop command failed in library code." + e.getMessage());
                throw e;
            }
            if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                GlassfishToolsPlugin.logMessage("Stop call failed. Reason: " + result.getValue());
                throw new Exception("Stop call failed. Reason: " + result.getValue());
            }
            GlassfishGenericServerBehaviour glassfishGenericServerBehaviour = GlassfishGenericServerBehaviour.this;
            synchronized (glassfishGenericServerBehaviour) {
                while (!GlassfishGenericServerBehaviour.this.getServerStatus(false).equals((Object)ServerStatus.STOPPED_NOT_LISTENING)) {
                    GlassfishGenericServerBehaviour.this.wait();
                }
            }
            return null;
        }
    }
}

