/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.Messages;
import oracle.eclipse.tools.glassfish.derby.DerbyConfigurator;
import oracle.eclipse.tools.glassfish.facets.IGlassfishWebDeploymentDescriptor;
import oracle.eclipse.tools.glassfish.facets.internal.GlassfishDeploymentDescriptorFactory;
import oracle.eclipse.tools.glassfish.utils.Utils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.glassfish.tools.ide.data.GlassFishAdminInterface;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.glassfish.tools.ide.server.parser.HttpData;
import org.glassfish.tools.ide.server.parser.HttpListenerReader;
import org.glassfish.tools.ide.server.parser.NetworkListenerReader;
import org.glassfish.tools.ide.server.parser.TargetConfigNameReader;
import org.glassfish.tools.ide.server.parser.TreeParser;
import org.glassfish.tools.ide.server.parser.XMLReader;

public abstract class GlassfishGenericServer
extends GenericServer
implements GlassFishServer {
    public static final String ROOTDIR = "sunappserver.rootdirectory";
    public static final String ADDRESS = "sunappserver.serveraddress";
    public static final String SERVERPORT = "sunappserver.serverportnumber";
    public static final String ADMINSERVERPORT = "sunappserver.adminserverportnumber";
    public static final String USECUSTOMTARGET = "sunappserver.usecustomtarget";
    public static final String DOMAINPATH = "sunappserver.domainpath";
    public static final String ADMINNAME = "sunappserver.adminname";
    public static final String ADMINPASSWORD = "sunappserver.adminpassword";
    public static final String KEEPSESSIONS = "sunappserver.keepSessions";
    public static final String JARDEPLOY = "sunappserver.jarDeploy";
    public static final String USEANONYMOUSCONNECTIONS = "sunappserver.useAnonymousConnection";
    public static final String SAMPLEDBDIR = "sunappserver.sampledbdir";
    public static final String CONTEXTROOT = "sunappserver.contextroot";
    public static final String DOMAINUPDATE = "domainupdate";
    private List<PropertyChangeListener> propChangeListeners;
    String domainValidationError = null;

    public GlassfishGenericServer() {
        GlassfishToolsPlugin.logMessage("in SunAppServer CTOR");
    }

    protected void initialize() {
        GlassfishToolsPlugin.logMessage("in SunAppServer initialize" + this.getServer().getName());
        super.initialize();
        this.readDomainConfig();
    }

    public URL getModuleRootURL(IModule module) {
        String protocol = Utils.getHttpListenerProtocol(this.getHost(), this.getHttpPort());
        String path = this.getModuleRootPath(module);
        int serverPort = this.getMonitorPort(this.getHttpPort());
        String hostname = this.getHost();
        try {
            return new URL(protocol, hostname, serverPort, path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getModuleRootPath(IModule module) {
        if (module == null || module.getProject() == null) {
            return "/";
        }
        if (Utils.hasProjectFacet(module, ProjectFacetsManager.getProjectFacet((String)"jst.web"))) {
            IModule[] rootEars = this.getRootEarModulesOnThisServer(module);
            if (rootEars != null && rootEars.length > 0) {
                return this.getModuleRootPath(module, rootEars[0]);
            }
            IGlassfishWebDeploymentDescriptor webDesc = GlassfishDeploymentDescriptorFactory.getWebDeploymentDescriptor(module.getProject());
            return webDesc.getContext();
        }
        return "/" + J2EEProjectUtilities.getServerContextRoot((IProject)module.getProject());
    }

    private String getModuleRootPath(IModule module, IModule parent) {
        String context = Utils.getAppWebContextRoot(parent, module);
        if (context != null && context.length() > 0) {
            try {
                context = URLEncoder.encode(context, "UTF-8");
                return "/" + context;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return "/";
    }

    private IModule[] getRootEarModulesOnThisServer(IModule module) {
        IModule[] ear = J2EEUtil.getEnterpriseApplications((IModule)module, null);
        if (ear != null && ear.length > 0) {
            ArrayList<IModule> ret = new ArrayList<IModule>();
            HashSet<IModule> allmodules = new HashSet<IModule>(Arrays.asList(this.getServer().getModules()));
            int i = 0;
            while (i < ear.length) {
                if (allmodules.contains(ear[i])) {
                    ret.add(ear[i]);
                }
                ++i;
            }
            return ret.toArray(new IModule[ret.size()]);
        }
        return null;
    }

    private int getMonitorPort(int configedPort) {
        ServerMonitorManager manager = ServerMonitorManager.getInstance();
        IMonitoredServerPort[] iMonitoredServerPortArray = manager.getMonitoredPorts(this.getServer());
        int n = iMonitoredServerPortArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitoredServerPort port = iMonitoredServerPortArray[n2];
            if (port.getServerPort().getPort() == configedPort) {
                return port.getMonitorPort();
            }
            ++n2;
        }
        return configedPort;
    }

    public GlassfishGenericServerBehaviour getServerBehaviourAdapter() {
        GlassfishGenericServerBehaviour serverBehavior = (GlassfishGenericServerBehaviour)this.getServer().getAdapter(GlassfishGenericServerBehaviour.class);
        if (serverBehavior == null) {
            serverBehavior = (GlassfishGenericServerBehaviour)this.getServer().loadAdapter(GlassfishGenericServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return serverBehavior;
    }

    public boolean isRemote() {
        return this.getServer().getServerType().supportsRemoteHosts() && !SocketUtil.isLocalhost((String)this.getServer().getHost());
    }

    protected void readDomainConfig() {
        if (!this.isRemote()) {
            if (this.readServerConfiguration(new File(String.valueOf(this.getDomainsFolder()) + File.separator + this.getDomainName() + "/config/domain.xml"))) {
                GlassfishToolsPlugin.logMessage("in SunAppServer initialize done readServerConfiguration");
                this.syncHostAndPortsValues();
            } else {
                GlassfishToolsPlugin.logMessage("in SunAppServer could not readServerConfiguration - probably invalid domain");
            }
        }
    }

    public Map<String, String> getProps() {
        return this.getServerInstanceProperties();
    }

    public String validateDomainExists(String domainPath) {
        if (this.isRemote()) {
            return null;
        }
        if (domainPath != null && !domainPath.startsWith("${")) {
            File f = new File(domainPath);
            if (!f.exists()) {
                return MessageFormat.format(Messages.pathDoesNotExist, f.getAbsolutePath());
            }
            if (!f.isDirectory()) {
                return MessageFormat.format(Messages.pathNotDirectory, f.getAbsolutePath());
            }
            if (!Utils.canWrite(f)) {
                return MessageFormat.format(Messages.pathNotWritable, f.getAbsolutePath());
            }
            File configDir = new File(f, "config");
            if (!configDir.exists()) {
                return MessageFormat.format(Messages.pathDoesNotExist, configDir.getAbsolutePath());
            }
            if (!configDir.canWrite()) {
                return MessageFormat.format(Messages.pathNotWritable, configDir.getAbsolutePath());
            }
            File domain = new File(f, "config/domain.xml");
            if (!domain.exists()) {
                return MessageFormat.format(Messages.pathNotValidDomain, domain.getAbsolutePath());
            }
            return null;
        }
        return Messages.incompleteDomainSetup;
    }

    public boolean isDomainValid() throws CoreException {
        String domainValidationError = this.validateDomainExists(this.getDomainPath());
        if (domainValidationError != null) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.glassfish", 150, domainValidationError, (Throwable)new RuntimeException(domainValidationError)));
        }
        return true;
    }

    public IStatus validate() {
        GlassfishToolsPlugin.logMessage("in SunAppServer -------validate");
        if (!this.isRemote()) {
            String domainValidation = this.validateDomainExists(this.getDomainPath());
            if (domainValidation != null) {
                return new Status(4, "oracle.eclipse.tools.glassfish", domainValidation);
            }
            this.readDomainConfig();
            try {
                Integer.parseInt(this.getAdminServerPort());
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, "oracle.eclipse.tools.glassfish", Messages.invalidPortNumbers);
            }
        } else {
            if (this.getAdminName() == null || this.getAdminName().length() == 0) {
                return new Status(4, "oracle.eclipse.tools.glassfish", Messages.invalidAdminName);
            }
            if (this.getAdminPassword() == null || this.getAdminPassword().trim().length() == 0) {
                return new Status(4, "oracle.eclipse.tools.glassfish", Messages.invalidAdminPasswd);
            }
        }
        return new Status(0, "oracle.eclipse.tools.glassfish", 0, "", null);
    }

    public String getKeepSessions() {
        return this.getProps().get(KEEPSESSIONS);
    }

    public boolean useCustomTarget() {
        return "true".equals(this.getProps().get(USECUSTOMTARGET));
    }

    public String computePreserveSessions() {
        String ret = null;
        if (!this.getKeepSessions().equals("true")) {
            return ret;
        }
        ret = GlassfishToolsPlugin.is31OrAbove(this.getServer().getRuntime()) ? "keepstate" : "keepSessions";
        return ret;
    }

    public String getJarDeploy() {
        String s = this.getProps().get(JARDEPLOY);
        if (s == null) {
            s = Boolean.FALSE.toString();
        }
        return s;
    }

    public void getJarDeploy(String value) {
        this.getProps().put(JARDEPLOY, value);
    }

    public String getUseAnonymousConnections() {
        String s = this.getProps().get(USEANONYMOUSCONNECTIONS);
        if (s == null) {
            String pass = this.getAdminPassword();
            if (pass != null && !pass.equals("")) {
                return Boolean.FALSE.toString();
            }
            s = Boolean.TRUE.toString();
        }
        return s;
    }

    public String getServerPort() {
        String serverPort = this.getProps().get(SERVERPORT);
        return serverPort != null ? serverPort : "8080";
    }

    protected int getHttpPort() {
        return Integer.parseInt(this.getServerPort());
    }

    public String getAdminServerPort() {
        return this.getProps().get(ADMINSERVERPORT);
    }

    public String getAdminName() {
        return this.getProps().get(ADMINNAME);
    }

    public void setAdminName(String value) {
        this.getProps().put(ADMINNAME, value);
    }

    public String getDomainPath() {
        return this.getProps().get(DOMAINPATH);
    }

    public String getSampleDatabaseDir() {
        return DerbyConfigurator.getSampleDBLocation();
    }

    private void syncHostAndPortsValues() {
        Map<String, String> props = this.getProps();
        String currentHostValue = props.get(ADDRESS);
        String genericHostValue = this.getServer().getHost();
        if (currentHostValue == null || !currentHostValue.equals(genericHostValue)) {
            props.put(ADDRESS, genericHostValue);
        }
    }

    public void saveConfiguration(IProgressMonitor m) throws CoreException {
        GlassfishToolsPlugin.logMessage("in Save SunAppServer");
        super.saveConfiguration(m);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChangeListeners == null) {
            this.propChangeListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChangeListeners != null) {
            this.propChangeListeners.remove(listener);
        }
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propChangeListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
        try {
            Iterator<PropertyChangeListener> iterator = this.propChangeListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    PropertyChangeListener listener = iterator.next();
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logMessage("Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            GlassfishToolsPlugin.logMessage("Error in property event", e);
        }
    }

    public String getAdminPassword() {
        return this.getProps().get(ADMINPASSWORD);
    }

    public void setAdminPassword(String value) {
        this.getProps().put(ADMINPASSWORD, value);
        try {
            this.configurationChanged();
        }
        catch (Exception ex) {
            GlassfishToolsPlugin.logMessage("error =" + ex);
        }
    }

    public static GlassfishGenericServer getSunAppServer(IServerWorkingCopy server) {
        GlassfishGenericServer sunserver = (GlassfishGenericServer)((Object)server.getOriginal().getAdapter(GlassfishGenericServer.class));
        if (sunserver == null) {
            sunserver = (GlassfishGenericServer)((Object)server.getOriginal().loadAdapter(GlassfishGenericServer.class, (IProgressMonitor)new NullProgressMonitor()));
        }
        return sunserver;
    }

    public void setDefaults(IProgressMonitor monitor) {
        GlassfishToolsPlugin.logMessage("In  setDefaults for " + this.getServer().getServerType().getName());
        this.setDefaultPublishState();
        super.setDefaults(monitor);
    }

    public void setDefaultPublishState() {
        this.setAttribute("auto-publish-setting", 2);
        this.setAttribute("auto-publish-time", 0);
    }

    public ServerPort[] getServerPorts() {
        try {
            ServerPort[] sp = new ServerPort[]{new ServerPort("adminserver", "Admin Server Port", Integer.parseInt(this.getAdminServerPort()), "HTTP"), new ServerPort("server", "Server Port", Integer.parseInt(this.getServerPort()), "HTTP")};
            return sp;
        }
        catch (Exception exception) {
            return new ServerPort[0];
        }
    }

    public String getServerInstallationDirectory() {
        return this.getServer().getRuntime().getLocation().toString();
    }

    protected boolean readServerConfiguration(File domainXml) {
        boolean result = false;
        LinkedHashMap httpMap = new LinkedHashMap();
        if (domainXml.exists()) {
            TargetConfigNameReader configNameReader = new TargetConfigNameReader();
            TreeParser.readXml((File)domainXml, (XMLReader[])new XMLReader[]{configNameReader});
            String configName = configNameReader.getTargetConfigName();
            if (configName == null) {
                return false;
            }
            HttpListenerReader httpListenerReader = new HttpListenerReader(configName);
            NetworkListenerReader networkListenerReader = new NetworkListenerReader(configName);
            try {
                TreeParser.readXml((File)domainXml, (XMLReader[])new XMLReader[]{httpListenerReader, networkListenerReader});
                httpMap.putAll(httpListenerReader.getResult());
                httpMap.putAll(networkListenerReader.getResult());
                HttpData adminData = (HttpData)httpMap.remove("admin-listener");
                int adminPort = adminData.getPort();
                this.getProps().put(ADMINSERVERPORT, String.valueOf(adminPort));
                GlassfishToolsPlugin.logMessage("reading from domain.xml adminServerPortNumber=" + this.getAdminServerPort());
                result = adminPort != -1;
            }
            catch (IllegalStateException ex) {
                GlassfishToolsPlugin.logMessage("error IllegalStateException ", ex);
            }
        }
        return result;
    }

    public String getDomainConfigurationFilePath() {
        return String.valueOf(this.getDomainPath().trim()) + "/config/domain.xml";
    }

    public int getAdminPort() {
        return Integer.parseInt(this.getAdminServerPort());
    }

    public String getAdminUser() {
        return this.getAdminName();
    }

    public String getDomainsFolder() {
        if (!this.isRemote()) {
            return new File(this.getDomainPath()).getParent();
        }
        File domainsPath = new File(this.getServer().getRuntime().getLocation().toFile(), "/domains/");
        return domainsPath.getAbsolutePath();
    }

    public String getDomainName() {
        return this.getDomainPath() != null ? new File(this.getDomainPath()).getName() : null;
    }

    public String getHost() {
        return this.getServer().getHost();
    }

    public String getName() {
        return this.getServer().getName();
    }

    public int getPort() {
        return this.getHttpPort();
    }

    public String getUrl() {
        return null;
    }

    public abstract GlassFishVersion getVersion();

    public GlassFishAdminInterface getAdminInterface() {
        return GlassFishAdminInterface.HTTP;
    }

    public String getServerHome() {
        return new File(this.getServer().getRuntime().getLocation().toString()).getAbsolutePath();
    }

    public String getServerRoot() {
        return null;
    }
}

