/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wpe;

import java.util.Map;
import oracle.eclipse.tools.application.common.services.documentservices.DOMUtil;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.document.IDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.editors.IDesignViewer;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;

public class WPERangeUpdater {
    private final boolean _debug;
    private final DOMUtil _domUtil;
    private final IDocument _document;
    private final IDesignViewer _adapter;
    private final Map _editPartRegistry;
    private final DocumentEditPart _documentEditPart;

    public WPERangeUpdater(IFile file, IEditorPart editor, boolean debug) throws IllegalStateException {
        this._debug = debug;
        this._domUtil = new DOMUtil();
        this._document = (IDocument)file.getAdapter(IDocument.class);
        if (this._document == null) {
            if (debug) {
                System.out.println("WPERangeUpdater: document was null for file: " + file);
            }
            throw new IllegalStateException();
        }
        this._adapter = (IDesignViewer)editor.getAdapter(IDesignViewer.class);
        if (this._adapter == null) {
            if (debug) {
                System.out.println("WPERangeUpdater: adapter was null for file: " + file);
            }
            throw new IllegalStateException();
        }
        this._editPartRegistry = this._adapter.getGraphicViewer().getEditPartRegistry();
        if (this._editPartRegistry == null) {
            if (debug) {
                System.out.println("WPERangeUpdater: edit part registry was null for file: " + file);
            }
            throw new IllegalStateException();
        }
        EditPart editPart = this._adapter.getGraphicViewer().getRootEditPart().getContents();
        if (!(editPart instanceof DocumentEditPart)) {
            if (debug) {
                System.out.println("WPERangeUpdater: document edit part was null for file: " + file);
            }
            throw new IllegalStateException();
        }
        this._documentEditPart = (DocumentEditPart)editPart;
    }

    public void update() {
        this.updateRangeAtEditPart(this._documentEditPart);
    }

    public void update(Range range) {
        long endOffset = range.getEndOffset();
        Node nodeAtContext = this._domUtil.getNodeAtContext(this._document, (int)range.getOffset());
        while (nodeAtContext != null && !(nodeAtContext instanceof IDOMElement)) {
            nodeAtContext = nodeAtContext.getParentNode();
        }
        if (nodeAtContext != null) {
            if (endOffset >= (long)((IDOMDocument)nodeAtContext.getOwnerDocument()).getEndOffset()) {
                nodeAtContext = nodeAtContext.getOwnerDocument();
            }
            Object object = this._editPartRegistry.get(nodeAtContext);
            this.updateRangeAtEditPart(object);
        }
    }

    private void updateRangeAtEditPart(Object object) {
        if (object instanceof ElementEditPart) {
            if (this._debug) {
                System.out.println("WPE refresh range: " + object);
            }
            ((ElementEditPart)object).refresh(true);
        } else if (object instanceof DocumentEditPart) {
            if (this._debug) {
                System.out.println("WPE refresh range: " + object);
            }
            ((DocumentEditPart)object).refresh(true);
        }
    }
}

