/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wpe;

import java.util.Map;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.webtier.ui.TraceOptions;
import oracle.eclipse.tools.webtier.ui.wpe.WPERangeUpdater;
import oracle.eclipse.tools.webtier.ui.wpe.WPEUpdateListener;
import oracle.eclipse.tools.webtier.ui.wpe.WPEUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

final class WPELocalizationListener
implements IDocumentLocalizationContext.ILocalizationListener {
    private static final boolean DEBUG = TraceOptions.WEBTIER_UI_DEBUG_WPE_UPDATE_LISTENER;
    private final WPEUpdateListener _wpeUpdateListener;
    private final WPEUtil _wpeUtil;

    WPELocalizationListener(WPEUpdateListener wpeUpdateListener) {
        this._wpeUpdateListener = wpeUpdateListener;
        this._wpeUtil = new WPEUtil();
    }

    public void changeOccurred(IDocumentLocalizationContext.LocalizationChangeEvent event) {
        if (DEBUG) {
            System.out.println("Localization Change Event: " + event);
        }
        IFile file = event.getSource().getFile();
        for (Map.Entry<HTMLEditor, WPEUpdateListener.EditorEntry> mapEntry : this._wpeUpdateListener.cloneWatchingParts().entrySet()) {
            HTMLEditor editor = mapEntry.getValue().getEditor();
            if (!file.equals((Object)this._wpeUtil.getEditorInput((IEditorPart)editor))) continue;
            try {
                WPERangeUpdater updater = new WPERangeUpdater(file, (IEditorPart)editor, DEBUG);
                PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new RefreshRunnable(event, updater));
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    private static final class RefreshRunnable
    implements Runnable {
        private final IDocumentLocalizationContext.LocalizationChangeEvent _event;
        private WPERangeUpdater _updater;

        private RefreshRunnable(IDocumentLocalizationContext.LocalizationChangeEvent event, WPERangeUpdater updater) {
            this._event = event;
            this._updater = updater;
        }

        @Override
        public void run() {
            for (IDocumentLocalizationContext.LocalizationChange change : this._event.getChanges()) {
                for (Range range : change.getAllRanges()) {
                    this._updater.update(range);
                }
            }
        }
    }
}

