/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class ProjectSettingsPage
extends DataModelWizardPage {
    private Button dirBrowseButton;
    private Button newRuntimeTargetButton = null;
    private Text dirText = null;
    private Text nameText = null;

    public ProjectSettingsPage(IDataModel model) {
        super(model, "ProjectSettingsPage");
        this.setTitle(Messages.ProjectSettingsPage_newProject_locationPage_title);
        this.setDescription(Messages.ProjectSettingsPage_newProject_locationPage_existingAppDesc);
    }

    public Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        this.createProjectLocationGroup(composite);
        this.createExistingSourceGroup(composite);
        this.createServerTargetGroup(composite);
        return composite;
    }

    protected void createProjectLocationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ProjectSettingsPage_newProject_locationPage_location);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        Label dirLabel = new Label((Composite)group, 0);
        dirLabel.setText(Messages.ProjectSettingsPage_newProject_locationPage_directory);
        this.dirText = new Text((Composite)group, 2048);
        this.dirText.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.dirText.setEnabled(false);
        this.synchHelper.synchText(this.dirText, "IProjectFromExistingSourceDataModelProperties.PROJECT_PATH", null);
        this.dirBrowseButton = new Button((Composite)group, 8);
        this.dirBrowseButton.setText(Messages.ProjectSettingsPage_newProject_locationPage_browse);
        this.dirBrowseButton.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, false));
        this.dirBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.dirBrowseButton);
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText(Messages.ProjectSettingsPage_newProject_locationPage_projectName);
        this.nameText = new Text((Composite)group, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.synchHelper.synchText(this.nameText, "IProjectFromExistingSourceDataModelProperties.PROJECT_NAME", null);
    }

    protected void createExistingSourceGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ProjectSettingsPage_newProject_locationPage_compilerSettings);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label complianceLabel = new Label((Composite)group, 0);
        complianceLabel.setText(Messages.ProjectSettingsPage_newProject_locationPage_compilerCompliance);
        Combo complianceCombo = new Combo((Composite)group, 2056);
        complianceCombo.setLayoutData((Object)new GridData(0, 0x1000008, true, false));
        this.synchHelper.synchCombo(complianceCombo, "IProjectFromExistingSourceDataModelProperties.PROJECT_COMPILER_COMPLIANCE", null);
    }

    protected void createServerTargetGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ProjectSettingsPage_newProject_locationPage_targetRuntime);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        Label runtimelabel = new Label((Composite)group, 0);
        runtimelabel.setText(Messages.ProjectSettingsPage_newProject_locationPage_runtime);
        Combo runtimeCombo = new Combo((Composite)group, 2056);
        runtimeCombo.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.synchHelper.synchCombo(runtimeCombo, "IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME", null);
        this.newRuntimeTargetButton = new Button((Composite)group, 0);
        this.newRuntimeTargetButton.setText(Messages.ProjectSettingsPage_newProject_locationPage_newRuntime);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IProjectFromExistingSourceDataModelProperties.PROJECT_NAME", "IProjectFromExistingSourceDataModelProperties.PROJECT_PATH_FILE", "IProjectFromExistingSourceDataModelProperties.PROJECT_CONTEXT_ROOT"};
    }

    protected void addListeners() {
        super.addListeners();
        this.dirBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ProjectSettingsPage.this.handleBrowseButtonEvent();
            }
        });
        this.newRuntimeTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSettingsPage.this.launchNewRuntimeWizard(ProjectSettingsPage.this.getShell());
            }
        });
    }

    void handleBrowseButtonEvent() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.ProjectSettingsPage_newProject_locationPage_browse);
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.model.setProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH", (Object)selectedDirectory);
        }
    }

    public void launchNewRuntimeWizard(Shell shell) {
        if (this.model != null) {
            DataModelPropertyDescriptor[] preAdditionDescriptors = this.model.getValidPropertyDescriptors("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME");
            if (ServerUIUtil.showNewRuntimeWizard((Shell)shell, null, null)) {
                DataModelPropertyDescriptor[] postAdditionDescriptors = this.model.getValidPropertyDescriptors("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME");
                Object[] preAddition = new Object[preAdditionDescriptors.length];
                int i = 0;
                while (i < preAddition.length) {
                    preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                    ++i;
                }
                Object[] postAddition = new Object[postAdditionDescriptors.length];
                int i2 = 0;
                while (i2 < postAddition.length) {
                    postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                    ++i2;
                }
                Object newAddition = ProjectSettingsPage.getNewObject(preAddition, postAddition);
                this.model.notifyPropertyChange("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME", 4);
                if (newAddition != null) {
                    this.model.setProperty("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME", newAddition);
                }
            }
        }
    }

    private static Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        if (oldObjects == null && newObjects != null && newObjects.length == 1) {
            return newObjects[0];
        }
        return null;
    }
}

