/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.wizards.existing.EnsureProjectRunnableWithProgress;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectBuildPathPage;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectFromExistingSourceDataModelOperation;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectFromExistingSourceDataModelProvider;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectSettingsPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class ProjectFromExistingSourceWizard
extends DataModelWizard
implements INewWizard {
    private boolean mIsFinished = false;

    public ProjectFromExistingSourceWizard() {
        this.setWindowTitle(Messages.ProjectFromExistingSourceWizard_newProject_wizard_title);
        this.setDefaultPageImageDescriptor(Activator.Images.NEW_PROJECT_WIZARD_BANNER.getImageDescriptor());
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getDataModel().setProperty("IProjectFromExistingSourceDataModelProperties.WORKBENCH", (Object)workbench);
    }

    protected IDataModelProvider getDefaultProvider() {
        return new ProjectFromExistingSourceDataModelProvider();
    }

    protected void doAddPages() {
        this.addPage((IWizardPage)new ProjectSettingsPage(this.getDataModel()));
        ProjectBuildPathPage buildPathPage = new ProjectBuildPathPage();
        this.getDataModel().setProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_BUILD_PATH_PAGE", (Object)buildPathPage);
        this.addPage((IWizardPage)buildPathPage);
    }

    public void dispose() {
        if (this.getDataModel().isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT") && !this.mIsFinished) {
            ProjectFromExistingSourceDataModelOperation.EclipseNewProjectController.deleteProject((Project)this.getDataModel().getProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT"));
        }
        this.getDataModel().setProperty("IProjectFromExistingSourceDataModelProperties.WORKBENCH", null);
        this.getDataModel().setProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_BUILD_PATH_PAGE", null);
        this.getDataModel().setProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT", null);
        super.dispose();
    }

    public boolean performCancel() {
        this.mIsFinished = false;
        if (this.getDataModel().isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT")) {
            ProjectFromExistingSourceDataModelOperation.EclipseNewProjectController.deleteProject((Project)this.getDataModel().getProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT"));
        }
        return super.performCancel();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        this.mIsFinished = true;
        super.postPerformFinish();
    }

    boolean ensureProject(Shell shell) throws InvocationTargetException, InterruptedException {
        this.getContainer().run(true, false, (IRunnableWithProgress)new EnsureProjectRunnableWithProgress(this.getDataModel()));
        return true;
    }

    public boolean canFinish() {
        return super.canFinish() && this.getDataModel().isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT");
    }
}

