/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.webapp.WebAppFolderMapper;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ClassPathDetector;
import oracle.eclipse.tools.webtier.ui.wizards.existing.DynamicWebProjectConfigurator;
import oracle.eclipse.tools.webtier.ui.wizards.existing.DynamicWebProjectConverter;
import oracle.eclipse.tools.webtier.ui.wizards.existing.EnsureProjectRunnableWithProgress;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectBuildPathPage;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class ProjectFromExistingSourceDataModelOperation
extends AbstractDataModelOperation {
    public ProjectFromExistingSourceDataModelOperation(IDataModel model) {
        super(model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IProject project;
        try {
            Shell shell = null;
            if (info != null) {
                shell = (Shell)info.getAdapter(Shell.class);
            }
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)100);
            ProjectBuildPathPage buldPathPage = (ProjectBuildPathPage)((Object)this.model.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_BUILD_PATH_PAGE"));
            try {
                buldPathPage.configureJavaProject(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)50));
            }
            catch (CoreException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            IJavaProject javaProject = buldPathPage.getJavaProject();
            if (!this.hasSourceFolder(javaProject)) {
                if (shell != null) {
                    MessageBox box = new MessageBox(shell, 131265);
                    box.setMessage(Messages.ProjectFromExistingSourceDataModelOperation_NewWebApp_noSrcFolder);
                    String title = Messages.ProjectFromExistingSourceDataModelOperation_NewWebApp_noSrcFolderTitle;
                    box.setText(title);
                    int result = box.open();
                    if (result == 128) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    this.createDefaultSrcFolder(javaProject, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)10));
                } else {
                    this.createDefaultSrcFolder(javaProject, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)10));
                }
            }
            project = buldPathPage.getJavaProject().getProject();
            IWorkbench workbench = (IWorkbench)this.model.getProperty("IProjectFromExistingSourceDataModelProperties.WORKBENCH");
            if (workbench != null) {
                BasicNewResourceWizard.selectAndReveal((IResource)project, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
            }
            Project webProject = (Project)this.model.getProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT");
            ArrayList<File> webAppRoots = new ArrayList<File>();
            File projectDir = (File)this.model.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH_FILE");
            EnsureProjectRunnableWithProgress.getWebAppRoots(projectDir, webAppRoots);
            String relativeRoot = "/";
            if (webAppRoots.size() > 0) {
                relativeRoot = EnsureProjectRunnableWithProgress.getRelativeRoot(projectDir, (File)webAppRoots.get(0));
            }
            WebAppFolderMapper.MappingInfo[] mappings = new WebAppFolderMapper.MappingInfo[]{new WebAppFolderMapper.MappingInfo(project, (IPath)new Path("/"), (IPath)new Path(relativeRoot))};
            DynamicWebProjectConfigurator config = new DynamicWebProjectConfigurator(webProject, mappings);
            config.setCompilerCompliance(this.model.getStringProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_COMPILER_COMPLIANCE"));
            config.setRuntime((IRuntime)this.model.getProperty("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME"));
            try {
                DynamicWebProjectConverter.convert(config, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)30));
            }
            catch (CoreException ce) {
                IStatus status = ce.getStatus();
                if (status == null) throw new ExecutionException(ce.getLocalizedMessage(), (Throwable)ce);
                if (status.getCode() != 10101) throw new ExecutionException(ce.getLocalizedMessage(), (Throwable)ce);
                IStatus iStatus = status;
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return iStatus;
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)5);
        }
        catch (CoreException ce) {
            IStatus iStatus = ce.getStatus();
            return iStatus;
        }
        IRuntime runtime = (IRuntime)this.model.getProperty("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME");
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (runtime != null && !runtime.equals(fproj.getPrimaryRuntime())) {
            try {
                Set runtimes = fproj.getTargetedRuntimes();
                if (!runtimes.contains(runtime)) {
                    HashSet<IRuntime> newRuntimes = new HashSet<IRuntime>(runtimes);
                    newRuntimes.add(runtime);
                    fproj.setTargetedRuntimes(newRuntimes, monitor);
                }
                fproj.setPrimaryRuntime(runtime, monitor);
            }
            catch (CoreException ce) {
                Status runtimeWarning;
                String warningText = Messages.ProjectFromExistingSourceDataModelOperation_NewWebApp_badRuntime;
                IStatus ceStatus = ce.getStatus();
                Status status = runtimeWarning = new Status(2, ceStatus == null ? "oracle.eclipse.tools.webtier.ui" : ceStatus.getPlugin(), String.valueOf(warningText) + (ceStatus == null ? "" : " " + ceStatus.getMessage()));
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return status;
            }
        }
        ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)5);
        return OK_STATUS;
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public void createDefaultSrcFolder(IJavaProject javaProject, IProgressMonitor monitor) {
        try {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
            IProject project = javaProject.getProject();
            File projectDir = project.getLocation().toFile();
            IPath rootPath = project.getFullPath();
            IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
            try {
                IPath srcPath = rootPath.append("src/");
                IFolder srcfolderHandle = workspaceRoot.getFolder(srcPath);
                if (!srcfolderHandle.exists()) {
                    srcfolderHandle.create(true, false, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)4));
                    new File(projectDir, "src").mkdirs();
                }
                IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcPath);
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
                System.arraycopy(entries, 0, newEntries, 0, entries.length);
                newEntries[entries.length] = srcEntry;
                javaProject.setRawClasspath(newEntries, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)6));
            }
            catch (Throwable e) {
                Activator.logError("", e);
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasSourceFolder(IJavaProject javaProject) {
        if (javaProject == null) {
            return false;
        }
        try {
            IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (true) {
                if (i >= packageFragmentRoots.length) {
                    return false;
                }
                if (!packageFragmentRoots[i].isArchive()) {
                    if (!packageFragmentRoots[i].isExternal()) return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Activator.logError("", e);
        }
        return false;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public static class EclipseNewProjectController {
        private static IProject getEclipseProjectHandle(String projectName) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }

        private static boolean isDefaultDirectory(String projectName, File directory) {
            File defaultDir = new File(Platform.getLocation().toFile(), projectName);
            return directory.equals(defaultDir);
        }

        protected File getNewProjectDefaultDirectory() {
            IPath path = Platform.getLocation();
            return path.toFile();
        }

        protected static boolean projectExists(String projectName) {
            return projectName == null || EclipseNewProjectController.getEclipseProjectHandle(projectName).exists();
        }

        protected static Project createProject(String projectName, File projectDir, String relativeRootDir, ProjectBuildPathPage javaProjectPage, boolean isExistingContent) throws CoreException, IOException {
            IProject project = EclipseNewProjectController.getEclipseProjectHandle(projectName);
            URI locationURI = EclipseNewProjectController.isDefaultDirectory(projectName, projectDir) ? null : projectDir.toURI();
            JavaCapabilityConfigurationPage.createProject((IProject)project, (URI)locationURI, null);
            IClasspathEntry[] entries = null;
            IPath outputLocation = null;
            if (!project.getFile(".classpath").exists()) {
                ClassPathDetector detector = new ClassPathDetector(project, relativeRootDir, !isExistingContent);
                entries = detector.getClasspath();
                outputLocation = detector.getOutputLocation();
            }
            javaProjectPage.init(JavaCore.create((IProject)project), outputLocation, entries, false);
            return (Project)project.getAdapter(Project.class);
        }

        protected static void deleteProject(Project webProject) {
            IProject project = webProject.getEclipseProject();
            if (project != null && project.exists()) {
                try {
                    project.delete(false, true, null);
                }
                catch (CoreException ex) {
                    Activator.logError("EclipseNewProjectController.deleteProject", ex);
                }
            }
        }
    }
}

