/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ImportableFacetsUtil {
    public static IProjectFacetVersion getJSFProjectFacetVersion(Project project) {
        return ImportableFacetsUtil.getJSFProjectFacetVersion(project, false);
    }

    public static IProjectFacetVersion getJSFProjectFacetVersion(Project project, boolean restrictTo11) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
        if (ImportableFacetsUtil.isFacesConfigFilePresent(project.getEclipseProject())) {
            if (restrictTo11) {
                return facet.getVersion("1.1");
            }
            String webFacetVersion = ImportableFacetsUtil.getWebFacetVersion(project.getEclipseProject());
            if (webFacetVersion.equals("2.3")) {
                return facet.getVersion("1.1");
            }
            if (webFacetVersion.equals("2.4")) {
                return facet.getVersion("1.1");
            }
            if (webFacetVersion.equals("2.5")) {
                return facet.getVersion("1.2");
            }
        }
        return null;
    }

    public static IProjectFacetVersion getJSTLProjectFacetVersion(Project project) {
        return ImportableFacetsUtil.getJSTLProjectFacetVersion(project, false);
    }

    public static IProjectFacetVersion getJSTLProjectFacetVersion(Project project, boolean restrictTo11) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jstl");
        if (ImportableFacetsUtil.isFacesConfigFilePresent(project.getEclipseProject())) {
            String webFacetVersion = ImportableFacetsUtil.getWebFacetVersion(project.getEclipseProject());
            if (webFacetVersion.equals("2.3")) {
                return null;
            }
            if (webFacetVersion.equals("2.4")) {
                return facet.getVersion("1.1");
            }
            if (webFacetVersion.equals("2.5")) {
                if (restrictTo11) {
                    return facet.getVersion("1.1");
                }
                return facet.getVersion("1.2");
            }
        }
        return null;
    }

    private static String getWebFacetVersion(IProject project) {
        String webVersion = null;
        try {
            IProjectFacetVersion webFacetVersion;
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
            if (fProject != null && (webFacetVersion = fProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jst.web"))) != null) {
                webVersion = webFacetVersion.getVersionString();
            }
        }
        catch (CoreException coreException) {}
        return webVersion;
    }

    private static boolean isFacesConfigFilePresent(IProject project) {
        boolean isPresent = false;
        List configFiles = ImportableFacetsUtil.getConfigFilesFromContextParam(project);
        configFiles.add(0, "WEB-INF/faces-config.xml");
        IVirtualFolder webContentFolder = JSFAppConfigUtils.getWebContentFolder((IProject)project);
        if (webContentFolder != null) {
            for (Object objConfigFile : configFiles) {
                IFile file;
                String configFile = (String)objConfigFile;
                IVirtualResource appConfigResource = webContentFolder.findMember(configFile);
                if (appConfigResource == null || appConfigResource.getType() != 16 || (file = (IFile)appConfigResource.getUnderlyingResource()) == null || !file.exists()) continue;
                isPresent = true;
                break;
            }
        }
        return isPresent;
    }

    private static List getConfigFilesFromContextParam(IProject project) {
        List filesList = new ArrayList();
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj != null) {
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                filesList = ImportableFacetsUtil.getConfigFilesForJ2EEApp(project);
            } else if (webAppObj instanceof WebApp) {
                filesList = ImportableFacetsUtil.getConfigFilesForJEEApp((WebApp)webAppObj);
            }
        }
        return filesList;
    }

    private static List getConfigFilesForJEEApp(WebApp webApp) {
        String filesString = null;
        List contextParams = webApp.getContextParams();
        for (org.eclipse.jst.javaee.core.ParamValue paramValue : contextParams) {
            if (!paramValue.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
            filesString = paramValue.getParamValue();
            break;
        }
        return ImportableFacetsUtil.parseFilesString(filesString);
    }

    private static List getConfigFilesForJ2EEApp(IProject project) {
        List filesList;
        block11: {
            filesList = new ArrayList();
            WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
            if (webArtifactEdit != null) {
                try {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = null;
                    try {
                        webApp = webArtifactEdit.getWebApp();
                    }
                    catch (ClassCastException classCastException) {
                        ArrayList arrayList = filesList;
                        webArtifactEdit.dispose();
                        return arrayList;
                    }
                    if (webApp == null) break block11;
                    String filesString = null;
                    if (webApp.getVersionID() == 23) {
                        EList contexts = webApp.getContexts();
                        for (ContextParam contextParam : contexts) {
                            if (!contextParam.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
                            filesString = contextParam.getParamValue();
                            break;
                        }
                    } else {
                        EList contextParams = webApp.getContextParams();
                        for (ParamValue paramValue : contextParams) {
                            if (!paramValue.getName().equals("javax.faces.CONFIG_FILES")) continue;
                            filesString = paramValue.getValue();
                            break;
                        }
                    }
                    filesList = ImportableFacetsUtil.parseFilesString(filesString);
                }
                finally {
                    webArtifactEdit.dispose();
                }
            }
        }
        return filesList;
    }

    private static List parseFilesString(String filesString) {
        ArrayList<String> filesList = new ArrayList<String>();
        if (filesString != null && filesString.trim().length() > 0) {
            StringTokenizer stFilesString = new StringTokenizer(filesString, ",");
            while (stFilesString.hasMoreTokens()) {
                String configFile = stFilesString.nextToken().trim();
                filesList.add(configFile);
            }
        }
        return filesList;
    }

    public static boolean isWeblogicXMLPresent(IProject project) {
        IFile file;
        IVirtualResource appConfigResource;
        boolean isPresent = false;
        IVirtualFolder webContentFolder = JSFAppConfigUtils.getWebContentFolder((IProject)project);
        if (webContentFolder != null && (appConfigResource = webContentFolder.findMember("WEB-INF/weblogic.xml")) != null && appConfigResource.getType() == 16 && (file = (IFile)appConfigResource.getUnderlyingResource()) != null && file.exists()) {
            isPresent = true;
        }
        return isPresent;
    }
}

