/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ClassPathDetector;
import oracle.eclipse.tools.webtier.ui.wizards.existing.EJBProjectConfigurator;
import oracle.eclipse.tools.webtier.ui.wizards.existing.EJBProjectConverter;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectBuildPathPage;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EJBProjectFromExistingDataModelOperation
extends AbstractDataModelOperation {
    public EJBProjectFromExistingDataModelOperation(IDataModel model) {
        super(model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Project ejbProject;
        try {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)100);
            ejbProject = (Project)this.model.getProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT");
            EJBProjectConfigurator config = new EJBProjectConfigurator(ejbProject);
            try {
                EJBProjectConverter.convert(config, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)30));
            }
            catch (CoreException ce) {
                IStatus status = ce.getStatus();
                if (status == null) throw new ExecutionException(ce.getLocalizedMessage(), (Throwable)ce);
                if (status.getCode() != 10101) throw new ExecutionException(ce.getLocalizedMessage(), (Throwable)ce);
                IStatus iStatus = status;
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return iStatus;
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)5);
        }
        catch (CoreException ce) {
            IStatus iStatus = ce.getStatus();
            return iStatus;
        }
        IRuntime runtime = (IRuntime)this.model.getProperty("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME");
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)ejbProject.getEclipseProject());
        if (runtime != null && !runtime.equals(fproj.getPrimaryRuntime())) {
            try {
                Set runtimes = fproj.getTargetedRuntimes();
                if (!runtimes.contains(runtime)) {
                    HashSet<IRuntime> newRuntimes = new HashSet<IRuntime>(runtimes);
                    newRuntimes.add(runtime);
                    fproj.setTargetedRuntimes(newRuntimes, monitor);
                }
                fproj.setPrimaryRuntime(runtime, monitor);
            }
            catch (CoreException ce) {
                Status runtimeWarning;
                String warningText = Messages.ProjectFromExistingSourceDataModelOperation_NewWebApp_badRuntime;
                IStatus ceStatus = ce.getStatus();
                Status status = runtimeWarning = new Status(2, ceStatus == null ? "oracle.eclipse.tools.webtier.ui" : ceStatus.getPlugin(), String.valueOf(warningText) + (ceStatus == null ? "" : " " + ceStatus.getMessage()));
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return status;
            }
        }
        ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)5);
        return OK_STATUS;
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public static class EclipseNewProjectController {
        private static IProject getEclipseProjectHandle(String projectName) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }

        private static boolean isDefaultDirectory(String projectName, File directory) {
            File defaultDir = new File(Platform.getLocation().toFile(), projectName);
            return directory.equals(defaultDir);
        }

        protected File getNewProjectDefaultDirectory() {
            IPath path = Platform.getLocation();
            return path.toFile();
        }

        protected static boolean projectExists(String projectName) {
            return projectName == null || EclipseNewProjectController.getEclipseProjectHandle(projectName).exists();
        }

        protected static Project createProject(String projectName, File projectDir, String relativeRootDir, ProjectBuildPathPage javaProjectPage, boolean isExistingContent) throws CoreException, IOException {
            IProject project = EclipseNewProjectController.getEclipseProjectHandle(projectName);
            URI locationURI = EclipseNewProjectController.isDefaultDirectory(projectName, projectDir) ? null : projectDir.toURI();
            JavaCapabilityConfigurationPage.createProject((IProject)project, (URI)locationURI, null);
            IClasspathEntry[] entries = null;
            IPath outputLocation = null;
            if (!project.getFile(".classpath").exists()) {
                ClassPathDetector detector = new ClassPathDetector(project, relativeRootDir, !isExistingContent);
                entries = detector.getClasspath();
                outputLocation = detector.getOutputLocation();
            }
            javaProjectPage.init(JavaCore.create((IProject)project), outputLocation, entries, false);
            return (Project)project.getAdapter(Project.class);
        }

        protected static void deleteProject(Project webProject) {
            IProject project = webProject.getEclipseProject();
            if (project != null && project.exists()) {
                try {
                    project.delete(false, true, null);
                }
                catch (CoreException ex) {
                    Activator.logError("EclipseNewProjectController.deleteProject", ex);
                }
            }
        }
    }
}

