/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.webapp.WebAppFolderMapper;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.wizards.existing.DynamicWebProjectConfigurator;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ImportableFacetsUtil;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectFromExistingSourceDataModelOperation;
import oracle.eclipse.tools.webtier.ui.wizards.existing.WlsRuntimeUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationOp;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.EarFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.ModuleStructuralModel;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProject;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class DynamicWebProjectConverter {
    private static final String WLS_WEB_FACET_ID = "wls.web";
    private DynamicWebProjectConfigurator mConfigurator;
    private IProject mProject;

    public DynamicWebProjectConverter(DynamicWebProjectConfigurator config) {
        this.mConfigurator = config;
        assert (this.mConfigurator.getProjectLocation() != null);
        String projName = this.mConfigurator.getDataModel().getStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        assert (projName != null);
        this.mProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
    }

    /*
     * Unable to fully structure code
     */
    public boolean convert(IProgressMonitor monitor) throws Exception {
        block36: {
            webProject = this.mConfigurator.getWebProject();
            hasWebProject = webProject != null;
            prjFolder = this.mConfigurator.getProjectLocation();
            mappings = this.mConfigurator.getFolderMappings();
            if (!hasWebProject) {
                webProject = (Project)this.mProject.getAdapter(Project.class);
            }
            javaFacetVersion = this.mConfigurator.getJavaFacetVersion();
            if (!DynamicWebProjectConverter.$assertionsDisabled && javaFacetVersion == null) {
                throw new AssertionError();
            }
            webFacetVersion = this.mConfigurator.getWebModuleFacetVersion();
            if (!DynamicWebProjectConverter.$assertionsDisabled && webFacetVersion == null) {
                throw new AssertionError();
            }
            if (javaFacetVersion == null || webFacetVersion == null) {
                return false;
            }
            facetedProject = ProjectFacetsManager.create((IProject)this.mProject, (boolean)true, (IProgressMonitor)ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
            settingsFolder = this.mProject.getFolder(".settings");
            if (!settingsFolder.exists() && new File(prjFolder, ".settings").exists()) {
                try {
                    settingsFolder.refreshLocal(0, null);
                }
                catch (Throwable v0) {}
            }
            fixedFacets = new HashSet<IProjectFacet>();
            javaConfig = javaFacetVersion.createActionConfig(IFacetedProject.Action.Type.INSTALL, this.mProject.getName());
            webConfig = webFacetVersion.createActionConfig(IFacetedProject.Action.Type.INSTALL, this.mProject.getName());
            if (!facetedProject.hasProjectFacet(javaFacetVersion.getProjectFacet())) {
                facetedProject.installProjectFacet(javaFacetVersion, javaConfig, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                fixedFacets.add(javaFacetVersion.getProjectFacet());
            }
            if (webConfig instanceof IDataModel) {
                mi = WebAppFolderMapper.findProjectRootMapping((WebAppFolderMapper.MappingInfo[])mappings, (String)this.mProject.getName());
                if (!DynamicWebProjectConverter.$assertionsDisabled && mi == null) {
                    throw new AssertionError();
                }
                rootUri = mi.getProjectUri();
                ((IDataModel)webConfig).setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)(rootUri.equals("./") != false ? "/" : rootUri));
                ((IDataModel)webConfig).setProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", (Object)this.mConfigurator.getContextRoot());
                map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.mConfigurator.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                facetModel = (IDataModel)map.get((Object)"jst.web");
                addToEar = facetModel.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR");
                ((IDataModel)webConfig).setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", addToEar);
                earName = facetModel.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
                ((IDataModel)webConfig).setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", earName);
            }
            if (!facetedProject.hasProjectFacet(webFacetVersion.getProjectFacet())) {
                webFacetInstallAction = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webFacetVersion, webConfig);
                versions = new HashSet<IProjectFacetVersion>();
                versions.add(javaFacetVersion);
                actions = new HashSet<IFacetedProject.Action>();
                actions.add(webFacetInstallAction);
                checkStatus = ProjectFacetsManager.check(versions, actions);
                if (checkStatus.isOK()) {
                    DynamicWebProjectConverter.addWebFacet(facetedProject, this.mProject, webFacetVersion, webConfig, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1), this.mConfigurator);
                    fixedFacets.add(webFacetVersion.getProjectFacet());
                } else {
                    ProjectFromExistingSourceDataModelOperation.EclipseNewProjectController.deleteProject(webProject);
                    srcStatus = checkStatus;
                    if (checkStatus.isMultiStatus()) {
                        srcStatus = checkStatus.getChildren()[0];
                    }
                    thrownStatus = new Status(srcStatus.getSeverity(), srcStatus.getPlugin(), 10101, srcStatus.getMessage(), checkStatus.getException());
                    throw new CoreException((IStatus)thrownStatus);
                }
            }
            if (fixedFacets.size() > 0) {
                fixedFacets.addAll(facetedProject.getFixedProjectFacets());
                facetedProject.setFixedProjectFacets(fixedFacets);
            }
            if ((primaryRuntime = facetedProject.getPrimaryRuntime()) != null && !(validRuntimes = RuntimeManager.getRuntimes()).contains(primaryRuntime)) {
                facetedProject.removeTargetedRuntime(primaryRuntime, monitor);
            }
            if ((runtime = this.mConfigurator.getRuntime()) != null && WlsRuntimeUtil.isWlsRuntime(runtime) && !"1.3".equals(this.mConfigurator.getCompilerCompliance()) && ImportableFacetsUtil.isWeblogicXMLPresent(this.mProject)) {
                try {
                    wlsWebFacet = ProjectFacetsManager.getProjectFacet((String)"wls.web");
                    if (!facetedProject.hasProjectFacet(wlsWebFacet) && (latestSupportedWlsWebFacetVersion = wlsWebFacet.getLatestSupportedVersion(runtime)) != null) {
                        facetedProject.installProjectFacet(latestSupportedWlsWebFacetVersion, null, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                    }
                }
                catch (IllegalArgumentException v1) {
                }
                catch (CoreException v2) {}
            }
            versions = this.mConfigurator.getAdaptedFacetVersions();
            supportedVersions = new HashSet<IProjectFacetVersion>(versions);
            facetInstallActions = new HashMap<IProjectFacet, IFacetedProject.Action>();
            facetVersionIter = supportedVersions.iterator();
            while (facetVersionIter.hasNext()) {
                version = (IProjectFacetVersion)facetVersionIter.next();
                if (version.getProjectFacet().getId().equals(javaFacetVersion.getProjectFacet().getId()) || version.getProjectFacet().getId().equals(webFacetVersion.getProjectFacet().getId()) || version.getProjectFacet().getId().equals("wls.web") || facetedProject.hasProjectFacet(version.getProjectFacet())) {
                    facetVersionIter.remove();
                    versions.remove(version);
                    continue;
                }
                projectFacet = version.getProjectFacet();
                queuedFacetAction = (IFacetedProject.Action)facetInstallActions.get(projectFacet);
                if (queuedFacetAction != null && version.compareTo((Object)queuedFacetAction.getProjectFacetVersion()) <= 0) continue;
                if (runtime != null && !runtime.supports(version)) {
                    version = projectFacet.getLatestSupportedVersion(runtime);
                }
                if (projectFacet == ProjectFacetsManager.getProjectFacet((String)"jst.jstl")) {
                    jsfFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
                    jsfVersion = facetedProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jst.jsf"));
                    if (jsfVersion == null) {
                        if (versions.contains(jsfFacet.getVersion("1.1"))) {
                            jsfVersion = jsfFacet.getVersion("1.1");
                        } else if (versions.contains(jsfFacet.getVersion("1.2"))) {
                            jsfVersion = jsfFacet.getVersion("1.2");
                        }
                    }
                    if (jsfVersion != null) {
                        version = projectFacet.getVersion(jsfVersion.getVersionString());
                    }
                }
                if (version != null) {
                    facetInstallActions.put(projectFacet, new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, version, null));
                    continue;
                }
                facetVersionIter.remove();
            }
            try {
                facetedProject.modify(new HashSet<V>(facetInstallActions.values()), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)4));
                versions = supportedVersions;
                break block36;
            }
            catch (CoreException ce) {
                Activator.logError(ce.getLocalizedMessage(), ce);
                ** for (version : versions)
            }
lbl-1000:
            // 1 sources

            {
                DynamicWebProjectConverter.adaptFacet(version, facetedProject);
                continue;
            }
        }
        if ("1.3".equals(this.mConfigurator.getCompilerCompliance()) && facetedProject.hasProjectFacet(wlsWebFacet = ProjectFacetsManager.getProjectFacet((String)"wls.web"))) {
            wlsWebFacetVersion = facetedProject.getInstalledVersion(wlsWebFacet);
            facetedProject.uninstallProjectFacet(wlsWebFacetVersion, null, monitor);
        }
        DynamicWebProjectConverter.stripInvalidFacets(facetedProject, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        return true;
    }

    private static void stripInvalidFacets(final IFacetedProject facetedProject, IProgressMonitor progressMonitor) throws CoreException {
        Set projectFacetVersions;
        if (facetedProject != null && (projectFacetVersions = facetedProject.getProjectFacets()) != null) {
            final HashSet<IFacetedProject.Action> modifyActions = new HashSet<IFacetedProject.Action>();
            for (IProjectFacetVersion projectFacetVersion : projectFacetVersions) {
                if (projectFacetVersion.getPluginId() != null) continue;
                modifyActions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, projectFacetVersion, null));
            }
            if (!modifyActions.isEmpty()) {
                DynamicWebProjectConverter.beginModification(facetedProject);
                try {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor progressMonitor2) throws CoreException {
                            for (IFacetedProject.Action modifyAction : modifyActions) {
                                DynamicWebProjectConverter.apply(modifyAction, facetedProject);
                            }
                            DynamicWebProjectConverter.save(facetedProject);
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, progressMonitor);
                }
                finally {
                    DynamicWebProjectConverter.endModification(facetedProject);
                }
                DynamicWebProjectConverter.notifyListeners(facetedProject);
            }
        }
    }

    private static void adaptFacet(IProjectFacetVersion fv, IFacetedProject facetedProject) {
        if (facetedProject.hasProjectFacet(fv)) {
            return;
        }
        DynamicWebProjectConverter.beginModification(facetedProject);
        try {
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, null);
            DynamicWebProjectConverter.apply(action, facetedProject);
            DynamicWebProjectConverter.save(facetedProject);
        }
        finally {
            DynamicWebProjectConverter.endModification(facetedProject);
        }
    }

    private static void addWebFacet(final IFacetedProject prj, final IProject selectedProject, final IProjectFacetVersion webFacetVersion, final Object webConfig, IProgressMonitor monitor, final DynamicWebProjectConfigurator configurator) throws CoreException {
        DynamicWebProjectConverter.beginModification(prj);
        try {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor2) throws CoreException {
                    DynamicWebProjectConverter.installWebFacet(selectedProject, webFacetVersion, webConfig, monitor2, configurator);
                    IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webFacetVersion, webConfig);
                    DynamicWebProjectConverter.apply(action, prj);
                    DynamicWebProjectConverter.save(prj);
                }
            };
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
        }
        finally {
            DynamicWebProjectConverter.endModification(prj);
        }
        DynamicWebProjectConverter.notifyListeners(prj);
    }

    private static void apply(IFacetedProject.Action action, IFacetedProject prj) {
        try {
            Method m = FacetedProject.class.getDeclaredMethod("apply", IFacetedProject.Action.class);
            m.setAccessible(true);
            m.invoke((Object)prj, action);
        }
        catch (Throwable t) {
            Activator.logError(t.getLocalizedMessage(), t);
        }
    }

    private static void save(IFacetedProject prj) {
        try {
            Method m = FacetedProject.class.getDeclaredMethod("save", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)prj, new Object[0]);
        }
        catch (Throwable t) {
            Activator.logError(t.getLocalizedMessage(), t);
        }
    }

    private static void notifyListeners(IFacetedProject prj) {
        try {
            Method m = FacetedProject.class.getDeclaredMethod("notifyListeners", IFacetedProjectEvent.class);
            m.setAccessible(true);
            m.invoke((Object)prj, new ProjectModifiedFacetedProjectEvent(prj));
        }
        catch (Throwable t) {
            Activator.logError(t.getLocalizedMessage(), t);
        }
    }

    private static void endModification(IFacetedProject prj) {
        try {
            Method m = FacetedProject.class.getDeclaredMethod("endModification", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)prj, new Object[0]);
        }
        catch (Throwable t) {
            Activator.logError(t.getLocalizedMessage(), t);
        }
    }

    private static void beginModification(IFacetedProject prj) {
        try {
            Method m = FacetedProject.class.getDeclaredMethod("beginModification", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)prj, new Object[0]);
        }
        catch (Throwable t) {
            Activator.logError(t.getLocalizedMessage(), t);
        }
    }

    private static void installWebFacet(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor, DynamicWebProjectConfigurator configurator) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        IClasspathEntry[] current = null;
        IJavaProject javaProject = null;
        try {
            try {
                String earProjectName;
                IVirtualFile vf;
                IFile manifestmf;
                IVirtualFolder jsrc;
                String contextRoot;
                IVirtualComponent c;
                ModuleCoreNature moduleCoreNature;
                IJavaProject jproj;
                IDataModel model = (IDataModel)cfg;
                javaProject = jproj = JavaCore.create((IProject)project);
                current = jproj.getRawClasspath();
                WtpUtils.addNatures((IProject)project);
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IPath pjpath = project.getFullPath();
                IPath contentdir = DynamicWebProjectConverter.setContentPropertyIfNeeded(model, pjpath, project);
                IPath webinf = contentdir.append("WEB-INF");
                if (ws.getRoot().getFolder(webinf).exists()) {
                    IPath webinflib = webinf.append("lib");
                    DynamicWebProjectConverter.mkdirs(ws.getRoot().getFolder(webinflib));
                }
                if ((moduleCoreNature = ModuleCoreNature.getModuleCoreNature((IProject)project)) != null) {
                    ModuleStructuralModel moduleModel = null;
                    Object accessorKey = new Object();
                    try {
                        moduleModel = moduleCoreNature.getModuleStructuralModelForWrite(accessorKey);
                        moduleModel.prepareProjectModulesIfNecessary();
                        moduleModel.saveIfNecessary(monitor, accessorKey);
                    }
                    finally {
                        if (moduleModel != null) {
                            moduleModel.dispose();
                        }
                    }
                }
                if ((c = ComponentCore.createComponent((IProject)project)) != null) {
                    c.create(0, null);
                }
                if ((contextRoot = model.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) == null || contextRoot.length() == 0) {
                    contextRoot = project.getName();
                }
                DynamicWebProjectConverter.setContextRootPropertyIfNeeded(c, contextRoot);
                DynamicWebProjectConverter.setJavaOutputPropertyIfNeeded(c, jproj.getOutputLocation());
                IVirtualFolder webroot = c.getRootFolder();
                if (webroot.getProjectRelativePath().equals((Object)new Path("/"))) {
                    String propPath = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
                    if (propPath.equals("/")) {
                        propPath = "";
                    }
                    webroot.createLink((IPath)new Path("/" + propPath), 0, null);
                }
                if ((jsrc = c.getRootFolder().getFolder("/WEB-INF/classes")).getUnderlyingFolder().exists()) {
                    IClasspathEntry[] cp = jproj.getRawClasspath();
                    int i = 0;
                    while (i < cp.length) {
                        String rootPath;
                        String path;
                        IClasspathEntry cpe = cp[i];
                        if (cpe.getEntryKind() == 3 && (path = cpe.getPath().toFile().getPath().toString().replace('\\', '/')).indexOf(rootPath = webroot.getWorkspaceRelativePath().toFile().toString().replace('\\', '/')) < 0) {
                            jsrc.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
                        }
                        ++i;
                    }
                }
                if ((manifestmf = (vf = c.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"))).getUnderlyingFile()) == null || !manifestmf.exists()) {
                    DynamicWebProjectConverter.createManifest(project, c.getRootFolder().getUnderlyingFolder(), monitor);
                }
                ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                Path cont = new Path("org.eclipse.jst.j2ee.internal.web.container");
                DynamicWebProjectConverter.removeWebInfLibs(jproj, configurator);
                DynamicWebProjectConverter.addToClasspath(jproj, JavaCore.newContainerEntry((IPath)cont));
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR") && (earProjectName = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME")) != null && !earProjectName.equals("")) {
                    String ver = fv.getVersionString();
                    String j2eeVersionText = J2EEVersionUtil.convertVersionIntToString((int)J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)ver));
                    ProjectFacetsManager.create((IProject)project);
                    DynamicWebProjectConverter.installEARFacet(j2eeVersionText, earProjectName, (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME"), monitor);
                    IProject earProject = ProjectUtilities.getProject((String)earProjectName);
                    IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
                    IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider(){

                        public Object getDefaultProperty(String propertyName) {
                            if ("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP".equals(propertyName)) {
                                HashMap<IVirtualComponent, String> map = new HashMap<IVirtualComponent, String>();
                                List components = (List)this.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                                int i = 0;
                                while (i < components.size()) {
                                    IVirtualComponent component = (IVirtualComponent)components.get(i);
                                    String name = component.getName();
                                    name = String.valueOf(name) + ".war";
                                    map.put(component, name);
                                    ++i;
                                }
                                return map;
                            }
                            return super.getDefaultProperty(propertyName);
                        }

                        public IDataModelOperation getDefaultOperation() {
                            return new AddComponentToEnterpriseApplicationOp(this.model){};
                        }
                    });
                    dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
                    List modList = (List)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                    modList.add(c);
                    dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
                    try {
                        dataModel.getDefaultOperation().execute(null, null);
                    }
                    catch (ExecutionException e) {
                        Activator.logError(e.getLocalizedMessage(), e);
                    }
                }
                try {
                    ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
                }
                catch (ExecutionException e) {
                    Activator.logError(e.getLocalizedMessage(), e);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            catch (Exception exception) {
                if (javaProject != null && current != null) {
                    javaProject.setRawClasspath(current, null);
                }
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void removeWebInfLibs(IJavaProject jproj, DynamicWebProjectConfigurator configurator) throws JavaModelException {
        IClasspathEntry[] entries = jproj.getRawClasspath();
        if (entries == null || entries.length == 0) {
            return;
        }
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        String webInf = WebAppFolderMapper.findProjectRootMapping((WebAppFolderMapper.MappingInfo[])configurator.getFolderMappings(), (String)jproj.getProject().getName()).getProjectUri();
        if (webInf.equals("./")) {
            webInf = "";
        } else if (!webInf.endsWith("/")) {
            webInf = String.valueOf(webInf) + "/";
        }
        webInf = String.valueOf(webInf) + "WEB-INF/lib";
        if (webInf.startsWith("/")) {
            webInf = webInf.substring(1);
        }
        webInf = "/" + jproj.getProject().getName() + "/" + webInf;
        int i = 0;
        while (i < entries.length) {
            IPath path;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() != 1 || !(path = entry.getPath()).toString().startsWith(webInf)) {
                list.add(entry);
            }
            ++i;
        }
        IClasspathEntry[] newEntries = list.toArray(new IClasspathEntry[list.size()]);
        jproj.setRawClasspath(newEntries, null);
    }

    private static void installEARFacet(String j2eeVersionText, String earProjectName, IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        IProject project = ProjectUtilities.getProject((String)earProjectName);
        if (project.exists()) {
            return;
        }
        try {
            IFacetedProject facetProj = ProjectFacetsManager.create((String)earProjectName, null, (IProgressMonitor)monitor);
            facetProj.setRuntime(runtime, monitor);
            IDataModel earFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EarFacetInstallDataModelProvider());
            earFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)earProjectName);
            earFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)j2eeVersionText);
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            actions.add(new IFacetedProject.Action((IFacetedProject.Action.Type)earFacetInstallDataModel.getProperty("IFacetDataModelProperties.FACET_TYPE"), (IProjectFacetVersion)earFacetInstallDataModel.getProperty("IFacetDataModelPropeties.FACET_VERSION"), (Object)earFacetInstallDataModel));
            facetProj.modify(actions, null);
            try {
                FacetProjectCreationOperation.addDefaultFactets((IFacetedProject)facetProj, (IRuntime)runtime);
            }
            catch (ExecutionException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }
        catch (CoreException e) {
            Activator.logError(e.getLocalizedMessage(), e);
            throw e;
        }
    }

    private static void addToClasspath(IJavaProject jproj, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] current = jproj.getRawClasspath();
        IClasspathEntry[] updated = new IClasspathEntry[current.length + 1];
        System.arraycopy(current, 0, updated, 0, current.length);
        updated[current.length] = entry;
        jproj.setRawClasspath(updated, null);
    }

    private static void createManifest(IProject project, IContainer aFolder, IProgressMonitor monitor) {
        IFile file = aFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (file.exists()) {
            return;
        }
        try {
            ManifestFileCreationAction.createManifestFile((IFile)file, (IProject)project);
        }
        catch (CoreException e) {
            Activator.logError(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            Activator.logError(e.getLocalizedMessage(), e);
        }
    }

    private static IPath setContentPropertyIfNeeded(IDataModel model, IPath pjpath, IProject project) {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        if (c != null && c.exists()) {
            return c.getRootFolder().getUnderlyingResource().getFullPath();
        }
        return pjpath.append(model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER"));
    }

    private static void mkdirs(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                DynamicWebProjectConverter.mkdirs((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }

    private static void setContextRootPropertyIfNeeded(IVirtualComponent c, String contextRoot) {
        String existing;
        if (c != null && (existing = c.getMetaProperties().getProperty("context-root")) == null) {
            c.setMetaProperty("context-root", contextRoot);
        }
    }

    private static void setJavaOutputPropertyIfNeeded(IVirtualComponent c, IPath path) {
        if (c != null) {
            String existing = c.getMetaProperties().getProperty("java-output-path");
            String relPath = path.removeFirstSegments(1).toString();
            if (!relPath.startsWith("/")) {
                relPath = "/" + relPath;
            }
            if (existing == null || !existing.equals(relPath)) {
                c.setMetaProperty("java-output-path", relPath);
            }
        }
    }

    public static boolean convert(final DynamicWebProjectConfigurator config, IRunnableContext context, final String taskName) throws CoreException {
        DynamicWebProjectConverter.preverify(config);
        final boolean[] results = new boolean[1];
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.setTaskName(taskName);
                results[0] = DynamicWebProjectConverter.convert(config, monitor);
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            context.run(false, false, op);
        }
        catch (Throwable e) {
            String message = e.getLocalizedMessage();
            Status status = new Status(4, "oracle.eclipse.tools.webtier.ui", -1, message == null ? "" : message, e);
            throw new CoreException((IStatus)status);
        }
        return results[0];
    }

    private static void preverify(DynamicWebProjectConfigurator config) throws CoreException {
        File dotproject = new File(config.getProjectLocation(), ".project");
        File dotclasspath = new File(config.getProjectLocation(), ".classpath");
        if (dotproject.exists() && !dotproject.canWrite()) {
            Status status = new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.DynamicWebProjectConverter_dotProject_readOnly, null);
            throw new CoreException((IStatus)status);
        }
        if (dotclasspath.exists() && !dotclasspath.canWrite()) {
            Status status = new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.DynamicWebProjectConverter_dotClasspath_readOnly, null);
            throw new CoreException((IStatus)status);
        }
    }

    public static boolean convert(DynamicWebProjectConfigurator config, IProgressMonitor monitor) throws CoreException {
        DynamicWebProjectConverter converter = new DynamicWebProjectConverter(config);
        monitor.beginTask("", 10);
        boolean result = false;
        try {
            try {
                result = converter.convert(monitor);
            }
            catch (Exception e) {
                if (e instanceof CoreException) {
                    throw (CoreException)((Object)e);
                }
                Status status = new Status(2, "oracle.eclipse.tools.webtier.ui", -1, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static class ProjectModifiedFacetedProjectEvent
    implements IFacetedProjectEvent {
        private final IFacetedProject project;
        private final IFacetedProjectEvent.Type eventType;

        public ProjectModifiedFacetedProjectEvent(IFacetedProject project) {
            this.project = project;
            this.eventType = IFacetedProjectEvent.Type.PROJECT_MODIFIED;
        }

        public final IFacetedProject getProject() {
            return this.project;
        }

        public final IFacetedProjectEvent.Type getType() {
            return this.eventType;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("<event project=\"");
            buf.append(this.project.getProject().getName());
            buf.append("\" type=\"");
            buf.append(this.eventType.name());
            buf.append("\">\n");
            this.toStringInternal(buf);
            buf.append("</event>");
            return buf.toString();
        }

        protected void toStringInternal(StringBuilder stringbuilder) {
        }

        public IFacetedProjectWorkingCopy getWorkingCopy() {
            return null;
        }
    }
}

