/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.webapp.WebAppFolderMapper;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ImportableFacetsUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.J2EEFileUtil;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class DynamicWebProjectConfigurator {
    private final List<WebAppFolderMapper.MappingInfo> mMappings;
    private String mCompilerCompliance;
    private final IDataModel mDataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
    private boolean mAutoAddFacets = true;
    private IRuntime mRuntime = null;
    private final Project _project;

    public DynamicWebProjectConfigurator(Project project, WebAppFolderMapper.MappingInfo[] mappings) {
        this._project = project;
        this.mDataModel.setProperty("IProjectCreationPropertiesNew.PROJECT_NAME", (Object)this._project.getEclipseProject().getName());
        this.mMappings = new ArrayList<WebAppFolderMapper.MappingInfo>(Arrays.asList(mappings));
    }

    public Set<IProjectFacetVersion> getAdaptedFacetVersions() {
        IProjectFacetVersion javaFacet;
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        IProjectFacetVersion webFacet = this.getWebModuleFacetVersion();
        if (webFacet != null) {
            facets.add(webFacet);
        }
        if ((javaFacet = this.getJavaFacetVersion()) != null) {
            facets.add(javaFacet);
        }
        if (this.mAutoAddFacets) {
            IProjectFacetVersion jstlVersion;
            boolean restrictTo11 = "1.3".equals(this.mCompilerCompliance);
            IProjectFacetVersion jsfVersion = ImportableFacetsUtil.getJSFProjectFacetVersion(this._project, restrictTo11);
            if (jsfVersion != null) {
                facets.add(jsfVersion);
            }
            if ((jstlVersion = ImportableFacetsUtil.getJSTLProjectFacetVersion(this._project, restrictTo11)) != null) {
                facets.add(jstlVersion);
            }
        }
        return facets;
    }

    public IProjectFacetVersion getWebModuleFacetVersion() {
        Set facets = ProjectFacetsManager.getProjectFacets();
        String webXmlVersion = this.getWebAppVersion("2.5");
        for (IProjectFacet facet : facets) {
            String id = facet.getId();
            if (!id.equals("jst.web")) continue;
            Set versions = facet.getVersions();
            for (IProjectFacetVersion fv : versions) {
                String version = fv.getVersionString();
                if (!version.equals(webXmlVersion)) continue;
                return fv;
            }
        }
        return null;
    }

    private String getWebAppVersion(String defVersion) {
        int specVersion;
        IResource resWebXML;
        IResource resProjectURI;
        String projectURI;
        WebAppFolderMapper.MappingInfo mappingInfo0;
        String version = defVersion;
        if (this.mMappings.size() > 0 && (mappingInfo0 = this.mMappings.get(0)) != null && (projectURI = mappingInfo0.getProjectUri()) != null && (resProjectURI = this._project.getEclipseProject().findMember(projectURI)) != null && resProjectURI.exists() && resProjectURI instanceof IFolder && (resWebXML = ((IFolder)resProjectURI).findMember("WEB-INF/web.xml")) != null && resWebXML.exists() && (specVersion = J2EEFileUtil.getFastSpecVersion((String)resWebXML.getLocation().toOSString())) != -1) {
            switch (specVersion) {
                case 22: {
                    version = "2.2";
                    break;
                }
                case 23: {
                    version = "2.3";
                    break;
                }
                case 24: {
                    version = "2.4";
                    break;
                }
                case 25: {
                    version = "2.5";
                    break;
                }
                case 30: {
                    version = "3.0";
                }
            }
        }
        return version;
    }

    public IProjectFacetVersion getJavaFacetVersion() {
        if (this._project.getEclipseProject() == null) {
            return null;
        }
        String level = this.mCompilerCompliance != null ? this.mCompilerCompliance : JavaFacetUtil.getCompilerLevel((IProject)this._project.getEclipseProject());
        return JavaFacet.FACET.getVersion(level);
    }

    public File getProjectLocation() {
        return this._project.getEclipseProject().getLocation().toFile();
    }

    public IDataModel getDataModel() {
        return this.mDataModel;
    }

    public Project getWebProject() {
        return this._project;
    }

    public WebAppFolderMapper.MappingInfo[] getFolderMappings() {
        return this.mMappings.toArray(new WebAppFolderMapper.MappingInfo[0]);
    }

    public String getContextRoot() {
        IProject iProject = this._project.getEclipseProject();
        String contextRoot = ComponentUtilities.getServerContextRoot((IProject)iProject);
        return contextRoot != null && contextRoot.length() != 0 ? contextRoot : iProject.getName();
    }

    public void setCompilerCompliance(String cc) {
        assert (cc == null || cc.equals("1.6") || cc.equals("1.5") || cc.equals("1.4") || cc.equals("1.3") || cc.equals("1.2") || cc.equals("1.1"));
        this.mCompilerCompliance = cc;
    }

    public String getCompilerCompliance() {
        return this.mCompilerCompliance;
    }

    public void setAutoAddFacets(boolean b) {
        this.mAutoAddFacets = b;
    }

    public boolean isAutoAddFacets() {
        return this.mAutoAddFacets;
    }

    public void setRuntime(IRuntime runtime) {
        this.mRuntime = runtime;
    }

    public IRuntime getRuntime() {
        return this.mRuntime;
    }
}

