/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.utils;

import java.util.HashSet;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TypeUtils {
    public static String chooseType(IProject project, String initialType, String title, int style) {
        Object[] types;
        block10: {
            SelectionDialog dialog;
            block9: {
                if (title == null) {
                    title = Messages.TypeUtils_title;
                }
                JavaSearchScope scope = null;
                if (project != null) {
                    try {
                        scope = new JavaSearchScope();
                        HashSet visitedProjects = new HashSet(2);
                        IJavaProject javaProject = TypeUtils.getJavaProject(project);
                        TypeUtils.addToJavaSearchScope(scope, javaProject, visitedProjects);
                    }
                    catch (Exception e1) {
                        LoggingService.logError((String)"oracle.eclipse.tools.webtier.ui", (String)("chooseType JavaSearchScope error:" + e1.getMessage()));
                    }
                }
                try {
                    Shell parent = TypeUtils.getActiveShell();
                    if (initialType == null) {
                        initialType = "";
                    }
                    dialog = JavaUI.createTypeDialog((Shell)parent, (IRunnableContext)new ProgressMonitorDialog(parent), (IJavaSearchScope)(scope != null ? scope : SearchEngine.createWorkspaceScope()), (int)style, (boolean)false, (String)initialType);
                    dialog.setTitle(title);
                    if (dialog.open() != 1) break block9;
                    return null;
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            types = dialog.getResult();
            if (types != null && types.length != 0) break block10;
            return null;
        }
        IType type = (IType)types[0];
        return type.getFullyQualifiedName('.');
    }

    private static Shell getActiveShell() {
        return Display.getCurrent().getActiveShell();
    }

    public static IJavaProject getJavaProject(IProject project) {
        try {
            if (project != null && project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                return model.getJavaProject(project.getName());
            }
        }
        catch (CoreException e) {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.ui", (String)("getJavaProject called with:" + project.getName() + " throws:" + e.getMessage()));
        }
        return null;
    }

    private static void addToJavaSearchScope(JavaSearchScope scope, IJavaProject javaProject, HashSet visitedProjects) throws JavaModelException {
        int includeMask = 15;
        scope.add((JavaProject)javaProject, includeMask, visitedProjects);
    }
}

