/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.utils;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.util.DefaultUniqueIdGenerator;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.impl.AbstractJSPTagImpl;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.ComponentIDType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagIDUtils {
    private static final String DVT_FACES_URI = "http://xmlns.oracle.com/dss/adf/faces";
    private static final String ADF_FACES_URI = "http://xmlns.oracle.com/adf/faces/rich";
    private static final String ADDED_ID_NAME = "Added IDs";
    private static final String ID_ATTR = "id";
    public static final String ADF_PREFERENCE_AUTO_GENERATE_IDS = "oracle.eclipse.tools.adf.view.auto_generate_ids";
    private static final String SPACE = " ";

    public static boolean isAutoGenerateIds() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean(ADF_PREFERENCE_AUTO_GENERATE_IDS);
    }

    public static final void fixFragmentIds(IDOMElement element, IDOMDocument document) {
        DefaultUniqueIdGenerator generator = new DefaultUniqueIdGenerator();
        Set idSet = generator.getIDs(document.getDocumentElement());
        idSet.addAll(generator.getIDs((Element)element));
        if (element != null) {
            TagIDUtils.addIdAttributeTo(element, generator, idSet);
            NodeList nodes = element.getElementsByTagName("*");
            int i = 0;
            int size = nodes.getLength();
            while (i < size) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1) {
                    TagIDUtils.addIdAttributeTo((IDOMElement)node, generator, idSet);
                }
                ++i;
            }
        }
    }

    private static void addIdAttributeTo(IDOMElement element, DefaultUniqueIdGenerator generator, Set<String> idSet) {
        if (!element.hasAttribute(ID_ATTR) && TagIDUtils.canHaveIdAttr(element)) {
            String uniqueId = generator.generateUniqueId(idSet, element.getLocalName().substring(0, 1));
            element.setAttribute(ID_ATTR, uniqueId);
            idSet.add(uniqueId);
        }
    }

    public static boolean canHaveIdAttr(IDOMElement element) {
        List list;
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)element.getStructuredDocument(), (Node)element);
        ITaglibContextResolver contextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        String uri = contextResolver.getTagURIForNodeName((Node)element);
        return (ADF_FACES_URI.equals(uri) || DVT_FACES_URI.equals(uri)) && (list = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidValues.class, context, uri, element.getLocalName(), ID_ATTR)) != null && list.size() > 0 && TagIDUtils.containsComponentIdType(list);
    }

    private static boolean containsComponentIdType(List<IMetaDataEnabledFeature> list) {
        for (IMetaDataEnabledFeature feature : list) {
            if (!(feature instanceof ComponentIDType)) continue;
            return true;
        }
        return false;
    }

    public static final void fixFragmentIds(EObject tag, IDOMDocument document) {
        DefaultUniqueIdGenerator generator = new DefaultUniqueIdGenerator();
        if (tag != null && tag instanceof AbstractJSPTagImpl) {
            AbstractJSPTagImpl tagElement = (AbstractJSPTagImpl)tag;
            Set idSet = generator.getIDs(document.getDocumentElement());
            TagIDUtils.fixFragmentIds((AbstractBaseTag)tagElement, idSet);
        }
    }

    private static void fixFragmentIds(AbstractBaseTag tagElement, Set<String> idSet) {
        TagIDUtils.fixIdTag(tagElement, idSet);
        EList childTags = tagElement.getChildTags();
        for (AbstractBaseTag childTag : childTags) {
            TagIDUtils.fixFragmentIds(childTag, idSet);
        }
    }

    private static void fixIdTag(AbstractBaseTag tagElement, Set<String> idSet) {
        DefaultUniqueIdGenerator generator = new DefaultUniqueIdGenerator();
        EClass eClass = tagElement.eClass();
        EStructuralFeature idFeature = eClass.getEStructuralFeature(ID_ATTR);
        if (idFeature != null && !tagElement.eIsSet(idFeature)) {
            String baseName = tagElement.getTagName();
            baseName = baseName.substring(0, 1);
            String id = generator.generateUniqueId(idSet, baseName);
            tagElement.eSet(idFeature, (Object)id);
            idSet.add(id);
        }
    }

    public static Change fixFragmentIds(IFile jsfFile) {
        TextFileChange result = new TextFileChange(MessageFormat.format(ADDED_ID_NAME, jsfFile.getName()), jsfFile);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        result.setEdit((TextEdit)multiTextEdit);
        IModelManager mgr = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = mgr.getModelForRead(jsfFile);
            if (model == null) {
                return null;
            }
            IDOMDocument document = ((IDOMModel)model).getDocument();
            DefaultUniqueIdGenerator generator = new DefaultUniqueIdGenerator();
            IDOMElement element = (IDOMElement)document.getDocumentElement();
            Set idSet = generator.getIDs((Element)element);
            HashMap<Integer, String> offsetList = new HashMap<Integer, String>();
            if (element != null) {
                TagIDUtils.addIdAttributeTo(element, generator, idSet, offsetList);
                NodeList nodes = element.getElementsByTagName("*");
                int i = 0;
                int size = nodes.getLength();
                while (i < size) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() == 1) {
                        TagIDUtils.addIdAttributeTo((IDOMElement)node, generator, idSet, offsetList);
                    }
                    ++i;
                }
                TagIDUtils.updateTextEdit(multiTextEdit, offsetList);
                TextFileChange textFileChange = result;
                return textFileChange;
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    public static void fixFragmentIdsForFile(IFile jsfFile) {
        IModelManager mgr = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = mgr.getModelForEdit(jsfFile);
            if (model == null) {
                return;
            }
            try {
                IDOMDocument document = ((IDOMModel)model).getDocument();
                IDOMElement element = (IDOMElement)document.getDocumentElement();
                TagIDUtils.fixFragmentIds(element, document);
                model.save();
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private static void addIdAttributeTo(IDOMElement element, DefaultUniqueIdGenerator generator, Set<String> idSet, Map<Integer, String> offsetList) {
        if (!element.hasAttribute(ID_ATTR) && TagIDUtils.canHaveIdAttr(element)) {
            int endEndOffset;
            String uniqueId = generator.generateUniqueId(idSet, element.getLocalName().substring(0, 1));
            int startEndOffset = element.getStartEndOffset();
            int reverseOffset = startEndOffset == (endEndOffset = element.getEndOffset()) ? 2 : 1;
            offsetList.put(new Integer(startEndOffset - reverseOffset), new String(" id=\"" + uniqueId + "\""));
            element.removeAttribute(ID_ATTR);
            idSet.add(uniqueId);
        }
    }

    private static void updateTextEdit(MultiTextEdit multiTextEdit, Map<Integer, String> offsetList) {
        for (Integer offset : offsetList.keySet()) {
            InsertEdit insert = new InsertEdit(offset.intValue(), offsetList.get(offset));
            multiTextEdit.addChild((TextEdit)insert);
        }
    }
}

