/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.utils;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.swing.Icon;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class ImageUtils {
    public static ImageDescriptor awtIcon2ImageDescriptor(final Icon icon) {
        ImageDescriptor descriptor = new ImageDescriptor(){

            public ImageData getImageData() {
                BufferedImage image = ImageUtils.createBufferedImage(icon.getIconWidth(), icon.getIconHeight());
                Graphics2D g = image.createGraphics();
                try {
                    icon.paintIcon(null, g, 0, 0);
                }
                finally {
                    g.dispose();
                }
                ImageData data = ImageUtils.createImageData(image);
                return data;
            }
        };
        return descriptor;
    }

    public static BufferedImage createBufferedImage(int w, int h) {
        return new BufferedImage(w, h, 7);
    }

    public static ImageData createImageData(BufferedImage image) {
        ImageUtils.checkAccess();
        if (image.getType() != 5) {
            return ImageUtils.createImageData(image, image.getTransparency() != 1);
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int bands = image.getColorModel().getColorSpace().getNumComponents();
        int depth = 24;
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        ImageData data = new ImageData(width, height, depth, new PaletteData(255, 65280, 0xFF0000), width * bands, pixels);
        return data;
    }

    public static ImageData createImageData(RenderedImage image, boolean transparent) {
        ImageUtils.checkAccess();
        ImageData swtdata = null;
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = 24;
        PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
        swtdata = new ImageData(width, height, depth, palette);
        Raster raster = image.getData();
        int numbands = raster.getNumBands();
        int[] awtdata = raster.getPixels(0, 0, width, height, new int[width * height * numbands]);
        int step = swtdata.depth / 8;
        byte[] data = swtdata.data;
        swtdata.transparentPixel = -1;
        int baseindex = 0;
        int y = 0;
        while (y < height) {
            int idx = (0 + y) * swtdata.bytesPerLine + 0 * step;
            int x = 0;
            while (x < width) {
                int pixel = x + y * width;
                baseindex = pixel * numbands;
                data[idx++] = (byte)awtdata[baseindex + 2];
                data[idx++] = (byte)awtdata[baseindex + 1];
                data[idx++] = (byte)awtdata[baseindex];
                if (numbands == 4 && transparent) {
                    swtdata.setAlpha(x, y, awtdata[baseindex + 3]);
                }
                ++x;
            }
            ++y;
        }
        return swtdata;
    }

    static void checkAccess() {
        if (Display.getCurrent() == null) {
            SWT.error((int)22);
        }
    }
}

