/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop;

import java.util.List;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.impl.AbstractJSPTagImpl;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.tagdrop.AbstractTagDropWizardAdvisor;
import oracle.eclipse.tools.webtier.ui.tagdrop.DynamicTagDropWizardRegistry;
import oracle.eclipse.tools.webtier.ui.tagdrop.FacetComposite;
import oracle.eclipse.tools.webtier.ui.tagdrop.ITagDropWizardAdvisor;
import oracle.eclipse.tools.webtier.ui.tagdrop.SelectionToPanelVisibilityConverter;
import oracle.eclipse.tools.webtier.ui.utils.MDUtils;
import oracle.eclipse.tools.webtier.ui.utils.PositionUtils;
import oracle.eclipse.tools.webtier.ui.utils.TagIDUtils;
import oracle.eclipse.tools.xml.edit.ui.common.AbstractControllerContext;
import oracle.eclipse.tools.xml.edit.ui.common.IControllerContext;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.provider.IItemGroupSource;
import oracle.eclipse.tools.xml.edit.ui.provider.TagEditContext;
import oracle.eclipse.tools.xml.edit.ui.tagdoc.TagDocHelpListener;
import oracle.eclipse.tools.xml.edit.ui.viewer.CategoryContentProvider;
import oracle.eclipse.tools.xml.edit.ui.viewer.EObjectViewer;
import oracle.eclipse.tools.xml.edit.ui.viewer.PropertyDescriptorLabelProvider;
import oracle.eclipse.tools.xml.model.emfbinding.EStoreFactory;
import oracle.eclipse.tools.xml.model.emfbinding.IEStoreNodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeAdapterEStoreEObjectImpl;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeEStoreFactory;
import oracle.eclipse.tools.xml.model.metadata.tlei.TleiEcoreMetaData;
import oracle.eclipse.tools.xml.model.tagdoc.TagInfo;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsp.core.taglib.ITaglibDescriptor;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Node;

public class TagDropWizard
extends Wizard
implements INewWizard {
    private static final ComposedAdapterFactory ADAPTER_FACTORY = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private PropertyEditorWizardPage propertyEditorWizardPage;
    private EObject _rootObject;
    private ILabelProvider _tagNameLabelProvider;
    private IItemGroupSource _groupSource;
    private WidgetAdapter _widgetAdapter;
    private final TagIdentifier _tagToDrop;
    private final IFile _file;
    private final NodeEStoreFactory _eStoreFactory;
    private final List<InitialSetting> _initialFeatureValues;
    private AbstractTagDropWizardAdvisor _wizardAdvisor;
    private AbstractTagDropWizardAdvisor _adfDynamicWizardAdvisor;
    private IControllerContext _controllerContext;
    private IObservableValue _dynamicJSFOptionSelected;
    private IObservableValue _dynamicADFOptionSelected;
    private IObservableValue _isIniting = new WritableValue((Object)Boolean.TRUE, Boolean.class);
    private long _insertOffset;
    private static final String HELPID_PREFIX = "oracle.eclipse.tools.webtier.ui.";
    private IDOMPosition _position;
    private FacetComposite facetSection;

    public TagDropWizard(TagIdentifier tagToDrop, IFile file, List<InitialSetting> initialFeatureValues, IDOMPosition position) {
        IItemPropertySource itemPropertySource;
        this._tagToDrop = tagToDrop;
        this._file = file;
        IDocument doc = null;
        if (this._file != null) {
            doc = (IDocument)this._file.getAdapter(IDocument.class);
        }
        this._eStoreFactory = doc != null ? (NodeEStoreFactory)doc.getAdapter(EStoreFactory.class) : null;
        this._initialFeatureValues = initialFeatureValues;
        this._insertOffset = PositionUtils.calculateInsertOffset(position, file);
        this._rootObject = this.createEObjectModel(this.getEClass(), true);
        if (this._rootObject != null && (itemPropertySource = (IItemPropertySource)ADAPTER_FACTORY.adapt((Notifier)this._rootObject, IItemPropertySource.class)) instanceof IItemGroupSource) {
            this._groupSource = (IItemGroupSource)itemPropertySource;
        }
        this._position = position;
        this.fixFragmentIds();
    }

    private void fixFragmentIds() {
        if (this._rootObject != null && TagIDUtils.isAutoGenerateIds()) {
            IDOMDocument document = (IDOMDocument)this._position.getContainerNode().getOwnerDocument();
            if (document == null && this._position.getContainerNode() instanceof IDOMDocument) {
                document = (IDOMDocument)this._position.getContainerNode();
            }
            if (document != null) {
                TagIDUtils.fixFragmentIds(this._rootObject, document);
            }
        }
    }

    private void attachInsertOffset(EObject eObject) {
        if (eObject instanceof NodeAdapterEStoreEObjectImpl) {
            IEStoreNodeBindingAdapter adapter = ((NodeAdapterEStoreEObjectImpl)eObject).getBindingAdapter();
            Long insertOffset = this._insertOffset == -1L ? null : Long.valueOf(this._insertOffset);
            adapter.setData("oracle.eclipse.tools.application.common.services.resource.ResourceBundleUtil.INSERT_POSITION", (Object)insertOffset);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        ImageDescriptor descriptor = Activator.Images.DROP_WIZARD_BANNER.getImageDescriptor();
        this.setDefaultPageImageDescriptor(descriptor);
        this._widgetAdapter = DialogWidgetAdapter.INSTANCE;
        this._wizardAdvisor = this.getWizardAdvisor(this._tagToDrop, this._file, this._widgetAdapter);
        this._adfDynamicWizardAdvisor = this.getWizardAdvisor(TagIdentifierFactory.createJSPTagWrapper((String)"http://xmlns.oracle.com/adf/faces/rich", (String)"adfDynamicWizardAdvisor"), this._file, this._widgetAdapter);
    }

    public TagIdentifier getTagToDrop() {
        return this._tagToDrop;
    }

    public void dispose() {
        if (this._tagNameLabelProvider != null) {
            this._tagNameLabelProvider.dispose();
            this._tagNameLabelProvider = null;
        }
        super.dispose();
    }

    public EObject getRootObject() {
        return this._rootObject;
    }

    public void setRootObject(EObject rootObject) {
        this._rootObject = rootObject;
        this.attachInsertOffset(rootObject);
    }

    private EObject createEObjectModel(EClass eClass, boolean initModel) {
        EObject eObject;
        if (eClass != null && this._eStoreFactory != null && (eObject = this._eStoreFactory.createUnboundEObject(eClass)) != null) {
            if (initModel) {
                this.initializeModel(eObject);
            }
            this.attachInsertOffset(eObject);
            return eObject;
        }
        return null;
    }

    public EObject createEObjectModel(EClass eClass) {
        return this.createEObjectModel(eClass, false);
    }

    private void initializeModel(EObject obj) {
        for (InitialSetting setting : this._initialFeatureValues) {
            setting.set(obj);
        }
    }

    private EClass getEClass() {
        if (this._eStoreFactory == null) {
            return null;
        }
        return this._eStoreFactory.getEClass(this._tagToDrop.getUri(), this._tagToDrop.getTagName());
    }

    public boolean hasDropModel() {
        if (this._groupSource == null) {
            return false;
        }
        return this._groupSource.hasFieldGroups(TagEditContext.CREATE_TAG, (Object)this._rootObject);
    }

    public boolean performFinish() {
        if (this.isDynamicJsfGenSelected()) {
            this._wizardAdvisor.performFinish();
        } else if (this.isDynamicAdfGenSelected()) {
            this._adfDynamicWizardAdvisor.performFinish();
            this._rootObject = null;
            new HTMLFormatProcessorImpl().formatNode(this._position.getContainerNode());
        }
        if (this._rootObject != null && this._rootObject instanceof AbstractJSPTagImpl) {
            if (this.facetSection != null) {
                MDUtils.addSelectedFacets(this._rootObject, this._position, this._eStoreFactory, this.facetSection.getFacetStates());
            } else {
                MDUtils.addDefaultFacets(this._rootObject, this._position, this._eStoreFactory);
            }
        }
        this.fixFragmentIds();
        return true;
    }

    private boolean isDynamicJsfGenSelected() {
        return (Boolean)this._dynamicJSFOptionSelected.getValue();
    }

    private boolean isDynamicAdfGenSelected() {
        return (Boolean)this._dynamicADFOptionSelected.getValue();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.isDynamicJsfGenSelected()) {
            return this._wizardAdvisor.getNextPage(page);
        }
        if (this.isDynamicAdfGenSelected()) {
            return this._adfDynamicWizardAdvisor.getNextPage(page);
        }
        return null;
    }

    public boolean canFinish() {
        if (this.isDynamicJsfGenSelected() || this.isDynamicAdfGenSelected()) {
            return this.getContainer().getCurrentPage().isPageComplete();
        }
        return super.canFinish();
    }

    public void addPages() {
        this.propertyEditorWizardPage = new PropertyEditorWizardPage("propertyEditors", null, null);
        this.addPage((IWizardPage)this.propertyEditorWizardPage);
        if (this.isDynamicGenerationOptionRequired()) {
            this._wizardAdvisor.addPages();
            this._adfDynamicWizardAdvisor.addPages();
        }
    }

    private boolean isDynamicGenerationOptionRequired() {
        return this._wizardAdvisor != null;
    }

    private AbstractTagDropWizardAdvisor getWizardAdvisor(TagIdentifier tagIdentifier, IFile file, WidgetAdapter widgetAdapter) {
        AbstractTagDropWizardAdvisor advisor = DynamicTagDropWizardRegistry.getInstance().getAdvisor(this, tagIdentifier);
        if (advisor != null) {
            advisor.setFile(file);
            advisor.setWidgetAdapter(widgetAdapter);
        }
        return advisor;
    }

    private TagDocHelpListener getTagDocHelpListener(TagIdentifier tagIdentifier, IFile file) {
        ITaglibRecord record = TaglibIndex.resolve((String)file.getFullPath().toString(), (String)tagIdentifier.getUri(), (boolean)false);
        if (record == null) {
            return null;
        }
        ITaglibDescriptor desc = record.getDescriptor();
        String version = desc.getTlibVersion();
        String namespace = tagIdentifier.getUri();
        String name = tagIdentifier.getTagName();
        if (namespace.length() > 0 && name.length() > 0 && version.length() > 0) {
            return new TagDocHelpListener(new TagInfo(namespace, name, version));
        }
        return null;
    }

    public IControllerContext getControllerContext() {
        return this._controllerContext;
    }

    public IObservableValue getInitializationObservable() {
        return this._isIniting;
    }

    public final IFile getFile() {
        return this._file;
    }

    public ILabelProvider getTagNameLabelProvider() {
        if (this._tagNameLabelProvider == null) {
            this._tagNameLabelProvider = new TagNameLabelProvider((AdapterFactory)ADAPTER_FACTORY);
        }
        return this._tagNameLabelProvider;
    }

    public Node getSelectionRoot() {
        return this._position.getContainerNode();
    }

    public IDOMPosition getPosition() {
        return this._position;
    }

    private static class DynamicPanel
    extends Composite {
        public DynamicPanel(Composite parent, int style, ITagDropWizardAdvisor wizardAdvisor) {
            super(parent, style);
            this.init(wizardAdvisor);
        }

        private void init(ITagDropWizardAdvisor wizardAdvisor) {
            wizardAdvisor.getStartingPageControl(this);
        }
    }

    public static final class InitialSetting
    implements EStructuralFeature.Setting {
        private final EStructuralFeature _feature;
        private final Object _value;

        public InitialSetting(EStructuralFeature feature, Object value) {
            this._feature = feature;
            this._value = value;
        }

        private void set(EObject eObj) {
            eObj.eSet(this._feature, this._value);
        }

        public Object get(boolean resolve) {
            return this._value;
        }

        public EObject getEObject() {
            throw new UnsupportedOperationException("Not valid for this impl");
        }

        public EStructuralFeature getEStructuralFeature() {
            return this._feature;
        }

        public boolean isSet() {
            throw new UnsupportedOperationException("Not valid for this impl");
        }

        public void set(Object newValue) {
            throw new UnsupportedOperationException("Not valid for this impl");
        }

        public void unset() {
            throw new UnsupportedOperationException("Not valid for this impl");
        }
    }

    private class PropertyEditorPanel
    extends Composite {
        private EObjectViewer _editor;
        private IStructuredContentProvider _contentProvider;
        private ILabelProvider _labelProvider;

        public PropertyEditorPanel(Composite parent, int style, IControllerContext controllerContext) {
            super(parent, style);
            GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)this);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
            this.createControl(controllerContext);
        }

        private void createControl(IControllerContext controllerContext) {
            this._editor = new EObjectViewer(controllerContext, (Composite)this);
            this._contentProvider = new CategoryContentProvider(TagDropWizard.this._groupSource, TagDropWizard.this._widgetAdapter, TagDropWizard.this._controllerContext.getTagEditContext());
            this._editor.setContentProvider((IContentProvider)this._contentProvider);
            this._labelProvider = new PropertyDescriptorLabelProvider();
            this._editor.setLabelProvider((IBaseLabelProvider)this._labelProvider);
            if (TagDropWizard.this._rootObject == null) {
                TagDropWizard.this._rootObject = TagDropWizard.this.createEObjectModel(TagDropWizard.this.getEClass(), true);
            }
            this._editor.setInput((Object)TagDropWizard.this.getRootObject());
            String windowTitle = TagDropWizard.this.getTagNameLabelProvider().getText((Object)TagDropWizard.this.getRootObject());
            TagDropWizard.this.setWindowTitle(NLS.bind((String)Messages.TagDropWizard_windowTitle, (Object)windowTitle));
            if (TagDropWizard.this._rootObject instanceof AbstractJSPTagImpl && !MDUtils.getUserSelectedFacets(TagDropWizard.this._rootObject, TagDropWizard.this._position).isEmpty()) {
                TagDropWizard.this.facetSection = new FacetComposite(this, 0, TagDropWizard.this._rootObject, TagDropWizard.this._position);
                GridData gridData = new GridData(4, 128, true, false, 1, 1);
                TagDropWizard.this.facetSection.setLayoutData(gridData);
                TagDropWizard.this.facetSection.setBackground(this.getBackground());
            }
        }

        public void dispose() {
            super.dispose();
            if (this._editor != null) {
                this._editor.dispose();
                this._editor = null;
            }
            if (this._contentProvider != null) {
                this._contentProvider.dispose();
                this._contentProvider = null;
            }
            if (this._labelProvider != null) {
                this._labelProvider.dispose();
                this._labelProvider = null;
            }
        }
    }

    public class PropertyEditorWizardPage
    extends WizardPage {
        private Composite _pePanel;
        private Composite _dynamicJsfPanel;
        private Composite _dynamicAdfPanel;
        private Composite _stack;
        private Button _sb;
        private Button _db;
        private StackLayout _stackLayout;
        private Binding _radio1ButtonBinding;
        private Binding _radio2ButtonBinding;
        private Button _dcb;

        public PropertyEditorWizardPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void dispose() {
            if (TagDropWizard.this._controllerContext != null) {
                TagDropWizard.this._controllerContext.dispose();
                TagDropWizard.this._controllerContext = null;
            }
            if (this._dynamicJsfPanel != null) {
                if (TagDropWizard.this.isDynamicJsfGenSelected()) {
                    TagDropWizard.this._wizardAdvisor.getFirstPage().dispose();
                } else if (TagDropWizard.this.isDynamicAdfGenSelected()) {
                    TagDropWizard.this._adfDynamicWizardAdvisor.getFirstPage().dispose();
                }
            }
            if (this._radio1ButtonBinding != null) {
                this._radio1ButtonBinding.dispose();
            }
            if (this._radio2ButtonBinding != null) {
                this._radio2ButtonBinding.dispose();
            }
        }

        public void createControl(Composite parent) {
            TagDropWizard.this._widgetAdapter.adaptParent(parent);
            TagDropWizard.this._dynamicJSFOptionSelected = (IObservableValue)new WritableValue((Object)Boolean.FALSE, Boolean.class);
            TagDropWizard.this._dynamicADFOptionSelected = (IObservableValue)new WritableValue((Object)Boolean.FALSE, Boolean.class);
            TagDropWizard.this._controllerContext = (IControllerContext)new ControllerContext(TagDropWizard.this._widgetAdapter);
            Composite c = TagDropWizard.this._widgetAdapter.createComposite(parent, 0);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)c);
            String tagName = TagDropWizard.this.getTagNameLabelProvider().getText((Object)TagDropWizard.this.getRootObject());
            String lcTagName = tagName.toLowerCase();
            if (TagDropWizard.this.isDynamicGenerationOptionRequired()) {
                this.setTitle(Messages.bind((String)Messages.TagDropWizard_dynamicTitle, (Object)tagName));
                GridLayoutFactory.fillDefaults().margins(14, 14).applyTo(c);
                this.setDescription(NLS.bind((String)Messages.TagDropWizard_staticOrDynamicGenDesc, (Object)lcTagName));
                this.createOptionsComposite(c);
                this._stack = TagDropWizard.this._widgetAdapter.createComposite(c, 0);
                GridDataFactory.fillDefaults().grab(true, true).hint(-1, 275).applyTo((Control)this._stack);
                this._stackLayout = new StackLayout();
                this._stack.setLayout((Layout)this._stackLayout);
                this._pePanel = new PropertyEditorPanel(this._stack, 0, TagDropWizard.this._controllerContext);
                GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(this._pePanel);
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this._pePanel);
                this._dynamicJsfPanel = new DynamicPanel(this._stack, 0, TagDropWizard.this._wizardAdvisor);
                GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(this._dynamicJsfPanel);
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this._dynamicJsfPanel);
                this._dynamicJsfPanel.layout();
                this._dynamicAdfPanel = new DynamicPanel(this._stack, 0, TagDropWizard.this._adfDynamicWizardAdvisor);
                GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(this._dynamicAdfPanel);
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this._dynamicAdfPanel);
                this._dynamicAdfPanel.layout();
                this.bindDynamicPanels();
                this._stackLayout.topControl = this._pePanel;
                this._stack.pack();
                this._stack.layout();
                c.pack();
                c.layout();
            } else {
                this.setTitle(tagName);
                GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(c);
                this.setDescription(NLS.bind((String)Messages.TagDropWizard_staticGenDesc, (Object)lcTagName));
                this._pePanel = new PropertyEditorPanel(c, 0, TagDropWizard.this._controllerContext);
                GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(this._pePanel);
                GridDataFactory.fillDefaults().grab(true, true).hint(-1, 275).applyTo((Control)this._pePanel);
                this._pePanel.setVisible(true);
                this._pePanel.pack();
                this._pePanel.layout();
            }
            TagDropWizard.this._isIniting.setValue((Object)Boolean.FALSE);
            TagDropWizard.this._controllerContext.afterUIUpdate();
            String helpId = TleiEcoreMetaData.INSTANCE.getHelpId(TagDropWizard.this.getEClass(), TagDropWizard.HELPID_PREFIX);
            if (helpId != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, helpId);
            } else {
                TagDocHelpListener helpListener = TagDropWizard.this.getTagDocHelpListener(TagDropWizard.this._tagToDrop, TagDropWizard.this._file);
                if (helpListener != null) {
                    c.addHelpListener((HelpListener)helpListener);
                }
            }
            this.setControl((Control)c);
        }

        private void bindDynamicPanels() {
            WritableValue topPanel = new WritableValue((Object)this._pePanel, Composite.class);
            this._radio1ButtonBinding = TagDropWizard.this._controllerContext.getDataBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._db), (IObservableValue)topPanel, new UpdateValueStrategy().setConverter((IConverter)new SelectionToPanelVisibilityConverter(this._dynamicJsfPanel, this._pePanel)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
            if (TagDropWizard.this._adfDynamicWizardAdvisor != null && TagDropWizard.this._adfDynamicWizardAdvisor.getSupportTagDropTester().canSupportTagDrop(TagDropWizard.this._tagToDrop)) {
                this._radio2ButtonBinding = TagDropWizard.this._controllerContext.getDataBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._dcb), (IObservableValue)topPanel, new UpdateValueStrategy().setConverter((IConverter)new SelectionToPanelVisibilityConverter(this._dynamicAdfPanel, this._pePanel)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
                TagDropWizard.this._controllerContext.getDataBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._dcb), TagDropWizard.this._dynamicADFOptionSelected);
            }
            topPanel.addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    ((PropertyEditorWizardPage)PropertyEditorWizardPage.this)._stackLayout.topControl = (Composite)event.getObservableValue().getValue();
                    PropertyEditorWizardPage.this._stack.layout();
                }
            });
            TagDropWizard.this._controllerContext.getDataBindingContext().bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._db), TagDropWizard.this._dynamicJSFOptionSelected);
            TagDropWizard.this._dynamicJSFOptionSelected.addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    TagDropWizard.this.getContainer().updateButtons();
                }
            });
            TagDropWizard.this._dynamicADFOptionSelected.addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    TagDropWizard.this.getContainer().updateButtons();
                }
            });
        }

        public boolean isPageComplete() {
            if (!this.isDynamicOptionSelected() && !TagDropWizard.this.isDynamicAdfGenSelected()) {
                return true;
            }
            return TagDropWizard.this._wizardAdvisor.getFirstPage().isPageComplete();
        }

        public boolean canFlipToNextPage() {
            if (this.isDynamicOptionSelected()) {
                return TagDropWizard.this._wizardAdvisor.getFirstPage().isPageComplete();
            }
            if (TagDropWizard.this.isDynamicAdfGenSelected()) {
                return TagDropWizard.this._adfDynamicWizardAdvisor.getFirstPage().isPageComplete();
            }
            return false;
        }

        private boolean isDynamicOptionSelected() {
            return (Boolean)TagDropWizard.this._dynamicJSFOptionSelected.getValue();
        }

        private void createOptionsComposite(Composite parent) {
            Composite optionsComposite = TagDropWizard.this._widgetAdapter.createComposite(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(optionsComposite);
            GridDataFactory.swtDefaults().applyTo((Control)optionsComposite);
            Label lbl = TagDropWizard.this._widgetAdapter.createLabel(optionsComposite, Messages.TagDropWizard_options, 0);
            GridDataFactory.swtDefaults().applyTo((Control)lbl);
            this._sb = TagDropWizard.this._widgetAdapter.createButton(optionsComposite, NLS.bind((String)Messages.TagDropWizard_configureOption, (Object)TagDropWizard.this._tagToDrop.getTagName()), 16);
            this._sb.setSelection(true);
            GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this._sb);
            Label spacer = new Label(optionsComposite, 0);
            GridDataFactory.swtDefaults().applyTo((Control)spacer);
            this._db = TagDropWizard.this._widgetAdapter.createButton(optionsComposite, NLS.bind((String)Messages.TagDropWizard_genJSFOptions, (Object)TagDropWizard.this._tagToDrop.getTagName()), 16);
            this._db.setSelection(false);
            GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this._db);
            if (TagDropWizard.this._adfDynamicWizardAdvisor != null && TagDropWizard.this._adfDynamicWizardAdvisor.getSupportTagDropTester().canSupportTagDrop(TagDropWizard.this._tagToDrop)) {
                Label spacer2 = new Label(optionsComposite, 0);
                GridDataFactory.swtDefaults().applyTo((Control)spacer2);
                this._dcb = TagDropWizard.this._widgetAdapter.createButton(optionsComposite, NLS.bind((String)Messages.TagDropWizard_genADFOptions, (Object)TagDropWizard.this._tagToDrop.getTagName()), 16);
                this._dcb.setSelection(false);
                GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this._dcb);
            }
        }

        private class ControllerContext
        extends AbstractControllerContext {
            ControllerContext(WidgetAdapter widgetAdapter) {
                super(widgetAdapter);
            }

            public void hookUpValidation(DataBindingContext dbc) {
                WizardPageSupport.create((WizardPage)PropertyEditorWizardPage.this, (DataBindingContext)dbc);
            }

            public void afterUIUpdate() {
                PropertyEditorWizardPage.this.setPageComplete(true);
            }

            public void setErrorMessage(String message) {
                PropertyEditorWizardPage.this.setErrorMessage(message);
            }

            public boolean enableHyperlinks() {
                return false;
            }

            public TagEditContext getTagEditContext() {
                return TagEditContext.CREATE_TAG;
            }
        }
    }

    private static final class TagNameLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private AdapterFactoryItemDelegator _itemProvider;

        public TagNameLabelProvider(AdapterFactory adapterFactory) {
            if (adapterFactory != null) {
                this._itemProvider = new AdapterFactoryItemDelegator(adapterFactory);
            }
        }

        public void dispose() {
            super.dispose();
            this._itemProvider = null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (this._itemProvider == null) {
                return Messages.TagDropWizard_defaultTagLabel;
            }
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                String text = this._itemProvider.getText((Object)eObject);
                if (text == null) {
                    Activator.logError("Missing label provider: " + eObject, new Exception());
                    text = Messages.TagDropWizard_defaultTagLabel;
                }
                return text;
            }
            return Messages.TagDropWizard_defaultTagLabel;
        }
    }
}

