/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private Image base;
    private Map<String, ImageDescriptor> overlays;
    private Set<String> keys;

    public OverlayImageDescriptor(Image baseImage, Map<String, ImageDescriptor> overlays) {
        this.base = baseImage;
        this.overlays = overlays;
    }

    public Image getBaseImage() {
        return this.base;
    }

    public void setKeys(Set<String> keys) {
        this.keys = keys;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base.getImageData(), 0, 0);
        this.drawOverlays();
    }

    private void drawOverlays() {
        for (String key : this.keys) {
            if (!this.overlays.containsKey(key)) continue;
            this.drawImage(this.overlays.get(key).getImageData(), 0, 0);
        }
    }

    protected Point getSize() {
        ImageData data = this.getBaseImage().getImageData();
        return new Point(data.width, data.height);
    }
}

