/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.itemcreation.ITagDropOverrider;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.AbstractDropCustomizer;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.ICustomizationData;

public abstract class ItemOverridingDropCustomizer
extends AbstractDropCustomizer {
    private IAdaptable _customizationAdapter;

    public final IAdaptable getDropCustomizationData() {
        return this._customizationAdapter;
    }

    public final IStatus runCustomizer(IFile file, IDOMPosition position) {
        IStatus writeableStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT);
        if (!writeableStatus.isOK()) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = this.doCustomization(file, position);
        if (status.getSeverity() != 0) {
            return status;
        }
        this._customizationAdapter = this.getCustomizationAdapter();
        return status;
    }

    protected abstract IStatus doCustomization(IFile var1, IDOMPosition var2);

    protected abstract CustomizationAdapter getCustomizationAdapter();

    protected static final class CustomizationAdapter
    implements IAdaptable {
        private final ICustomizationData _customizationData;
        private final ITagDropOverrider _tagDropOverrider;

        public CustomizationAdapter(ICustomizationData data, ITagDropOverrider dropOverrider) {
            this._customizationData = data;
            this._tagDropOverrider = dropOverrider;
        }

        public Object getAdapter(Class adapter) {
            if (ICustomizationData.class == adapter) {
                return this._customizationData;
            }
            if (ITagDropOverrider.class == adapter) {
                return this._tagDropOverrider;
            }
            return null;
        }
    }
}

