/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop;

import java.util.ArrayList;
import java.util.Collections;
import oracle.eclipse.tools.webtier.ui.tagdrop.OEPECustomizationDataImpl;
import oracle.eclipse.tools.webtier.ui.tagdrop.OEPEDefaultTagCreator;
import oracle.eclipse.tools.webtier.ui.tagdrop.OEPEUserCustomizedTagCreator;
import oracle.eclipse.tools.webtier.ui.tagdrop.TagDropWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.elementedit.AbstractElementEdit;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreator;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.AbstractDropCustomizer;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.IDropCustomizer;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class ElementEditDecorator
extends AbstractElementEdit {
    private final IElementEdit _delegate;

    public ElementEditDecorator(IElementEdit delegate) {
        this._delegate = delegate;
    }

    public void createEditPolicies(ElementEditPart part) {
        this._delegate.createEditPolicies(part);
    }

    public boolean fillContainerContextMenu(IMenuManager contextMenu, ElementEditPart elePart, NodeEditPart nodePart, ISelection innerSelection) {
        return this._delegate.fillContainerContextMenu(contextMenu, elePart, nodePart, innerSelection);
    }

    public void fillContextMenu(IMenuManager contextMenu, Element ele) {
        this._delegate.fillContextMenu(contextMenu, ele);
    }

    public IDropCustomizer getDropCustomizer(TagIdentifier tagId) {
        return new MyDropCustomizer(tagId);
    }

    public ITagCreator getTagCreator(TagIdentifier tagId) {
        TagDropWizard wizard = new TagDropWizard(ElementEditDecorator.fixTagId(tagId), null, new ArrayList<TagDropWizard.InitialSetting>(), null);
        if (wizard.hasDropModel()) {
            return new OEPEUserCustomizedTagCreator();
        }
        return new OEPEDefaultTagCreator();
    }

    public boolean handleModelChange(Element ele, ElementEditPart part, boolean recursive) {
        return this._delegate.handleModelChange(ele, part, recursive);
    }

    public boolean isResizable(Element ele) {
        return this._delegate.isResizable(ele);
    }

    public static TagIdentifier fixTagId(TagIdentifier tagId) {
        if ("JSP11".equalsIgnoreCase(tagId.getUri())) {
            String tagName = tagId.getTagName();
            int index = tagName.indexOf(58);
            if (index > -1) {
                tagName = tagName.substring(index + 1);
            }
            return TagIdentifierFactory.createJSPTagWrapper((String)"http://java.sun.com/JSP/Page", (String)tagName);
        }
        if ("HTML".equalsIgnoreCase(tagId.getUri())) {
            String tagName = tagId.getTagName().toLowerCase();
            String[] splitName = ElementEditDecorator.splitInputName(tagName);
            if (splitName.length > 0) {
                tagName = splitName[0];
            }
            return TagIdentifierFactory.createJSPTagWrapper((String)"http://www.w3.org/1999/xhtml", (String)tagName);
        }
        return tagId;
    }

    public static String[] splitInputName(String tagName) {
        return tagName.toLowerCase().split("\\.");
    }

    public static class MyDropCustomizer
    extends AbstractDropCustomizer {
        private OEPECustomizationDataImpl _customizationData;
        private final TagIdentifier _tagId;

        public MyDropCustomizer(TagIdentifier tagId) {
            this._tagId = tagId;
        }

        public IAdaptable getDropCustomizationData() {
            return this._customizationData;
        }

        protected TagDropWizard getTagDropWizard(IFile file, TagIdentifier tagId, TagIdentifier fixedTagId, IDOMPosition position) {
            return new TagDropWizard(tagId, file, Collections.EMPTY_LIST, position);
        }

        public IStatus runCustomizer(IFile file, IDOMPosition position) {
            IStatus writeableStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT);
            if (!writeableStatus.isOK()) {
                return Status.CANCEL_STATUS;
            }
            TagIdentifier tagId = ElementEditDecorator.fixTagId(this._tagId);
            TagDropWizard wizard = this.getTagDropWizard(file, this._tagId, tagId, position);
            if (wizard.hasDropModel()) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, (IStructuredSelection)new StructuredSelection((Object)file));
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int result = dialog.open();
                EObject rootObject = wizard.getRootObject();
                if (1 == result || rootObject == null) {
                    return Status.CANCEL_STATUS;
                }
                this._customizationData = new OEPECustomizationDataImpl(tagId, file, rootObject, position);
            }
            return Status.OK_STATUS;
        }

        public IStatus runCustomizer() {
            throw new UnsupportedOperationException("Call runCustomizer(file,position) instead");
        }

        protected final TagIdentifier getTagId() {
            return this._tagId;
        }
    }
}

