/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.tagdrop.AbstractTagDropWizardAdvisor;
import oracle.eclipse.tools.webtier.ui.tagdrop.TagDropWizard;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.osgi.framework.Bundle;

public class DynamicTagDropWizardRegistry {
    private static final String DYN_TAG_DROP_WIZ_CONTRIBUTORS_EXTENSION_POINT_ID = "oracle.eclipse.tools.webtier.ui.dynamicTagDropWizard";
    private static final String ATTR_FORTAGNAME = "forTagName";
    private static final String ATTR_FORTAGURI = "forTagUri";
    private static final String ATTR_WIZARDADVISOR = "wizardAdvisor";
    private static DynamicTagDropWizardRegistry _instance;
    private HashMap<String, Class<?>> _map;

    public static synchronized DynamicTagDropWizardRegistry getInstance() {
        if (_instance == null) {
            _instance = new DynamicTagDropWizardRegistry();
            _instance.init();
        }
        return _instance;
    }

    private void init() {
        IConfigurationElement[] contributorElems = Platform.getExtensionRegistry().getConfigurationElementsFor(DYN_TAG_DROP_WIZ_CONTRIBUTORS_EXTENSION_POINT_ID);
        this._map = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = contributorElems;
        int n = contributorElems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            try {
                Bundle bundle = Platform.getBundle((String)elem.getContributor().getName());
                String tagUri = elem.getAttribute(ATTR_FORTAGURI);
                String tagName = elem.getAttribute(ATTR_FORTAGNAME);
                Class klass = bundle.loadClass(elem.getAttribute(ATTR_WIZARDADVISOR));
                if (AbstractTagDropWizardAdvisor.class.isAssignableFrom(klass)) {
                    this.addToRegistry(tagUri, tagName, klass);
                }
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "oracle.eclipse.tools.webtier.ui", "Problem creating TagDropWizardAdvsor for " + elem.toString(), (Throwable)e));
            }
            ++n2;
        }
    }

    private void addToRegistry(String uri, String tagName, Class<?> klass) {
        this._map.put(TagIdentifierFactory.createJSPTagWrapper((String)uri, (String)tagName).asQName().toString(), klass);
    }

    public AbstractTagDropWizardAdvisor getAdvisor(TagDropWizard tagDropWizard, TagIdentifier tagId) {
        if (tagDropWizard == null) {
            throw new NullPointerException();
        }
        Class<?> klass = this._map.get(tagId.asQName().toString());
        if (klass != null) {
            try {
                Class[] paramTypes = new Class[]{TagDropWizard.class};
                Constructor<?> constructor = klass.getConstructor(paramTypes);
                return (AbstractTagDropWizardAdvisor)constructor.newInstance(new Object[]{tagDropWizard});
            }
            catch (Exception e) {
                Activator.logError("Invalid dynamic tag drop wizard for " + tagId.asQName(), e);
            }
        }
        return null;
    }
}

