/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleExtFactory;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.databinding.conversion.Converter;

public class ValueReferenceToResourceBundleKeyPairConverter
extends Converter {
    private final IFilePositionContext _context;

    public ValueReferenceToResourceBundleKeyPairConverter(IFilePositionContext context) {
        super(ValueReference.class, ResourceBundleKeyPair.class);
        this._context = context;
    }

    public Object convert(Object fromObject) {
        if (fromObject instanceof ValueReference) {
            ValueReference valRef = (ValueReference)fromObject;
            Variable var = valRef.getVariable();
            if (var == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.Converter_ValRefVariable_NullError);
                return null;
            }
            DataType dataType = var.getType();
            if (!(dataType instanceof JavaResourceBundleDataType)) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.Converter_WrongDataTypeError);
                return null;
            }
            IResourceBundleExt bundleExt = ResourceBundleExtFactory.INSTANCE.create(this._context, (JavaResourceBundleDataType)dataType, var);
            if (bundleExt == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.Converter_CouldNotCreate_IResourceBundleExt_Error);
                return null;
            }
            String key = valRef.getFieldName();
            if (key == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.Converter_ValueRefKey_NullError);
                return null;
            }
            return new ResourceBundleKeyPair(bundleExt, key);
        }
        return null;
    }
}

