/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.webtier.ui.resource.internal.Package;
import org.eclipse.core.runtime.Assert;

public class Source {
    private final String _sourceName;
    private Set<Package> _packages = new HashSet<Package>();

    Source(String sourceName) {
        Assert.isNotNull((Object)sourceName);
        this._sourceName = sourceName;
    }

    public String getSourceName() {
        return this._sourceName;
    }

    public boolean addBaseName(Package pkg) {
        boolean added = this._packages.add(pkg);
        pkg.setParent(this);
        return added;
    }

    public Set<Package> getPackages() {
        return Collections.unmodifiableSet(this._packages);
    }

    public Package getPackage(String packageName) {
        for (Package pkg : this._packages) {
            if (!pkg.getPackageName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source that = (Source)obj;
        return this.getSourceName().equals(that.getSourceName());
    }

    public int hashCode() {
        return this.getSourceName().hashCode();
    }

    public String toString() {
        return String.valueOf(super.toString()) + '[' + this.getSourceName() + ']';
    }
}

