/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.Collection;
import java.util.Locale;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.resource.LocaleObservableValue;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorValueCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultDeferredValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultValueBindingMediator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ResourceLocaleDialogCreationAdvisor
extends AbstractDialogEditorValueCreationAdvisor<IObservableValue, UpdateValueStrategy> {
    private static final String HELPID = "oracle.eclipse.tools.webtier.ui.ChooseLocaleDialog";
    private IDocumentLocalizationContext _context;

    public ResourceLocaleDialogCreationAdvisor(DataBindingContext context, String title, AbstractDialogEditorCreationAdvisor.MessageSourceObservableValue messageObservableValue, IObservableValue userModelObservable, IDocumentLocalizationContext localizationContext) {
        super(context, title, messageObservableValue, (AbstractBindingMediator)new UserDataMediator(userModelObservable), (AbstractBindingMediator)new IntermediateDataMediator(), (AbstractBindingMediator)new SelectionDataMediator());
        this._context = localizationContext;
    }

    protected Control doCreateEditingArea(Composite parent) {
        Composite editingArea = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        editingArea.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        editingArea.setLayout((Layout)layout);
        Combo combo = new Combo(editingArea, 12);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setContentProvider((IContentProvider)new LocaleContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LocaleLabelProvider());
        viewer.setInput((Object)this._context);
        this.setInitState(AbstractDialogEditorCreationAdvisor.InitState.UI_INITIALIZED);
        this.getSelectionModel().setStateModel((IObservable)ViewersObservables.observeSingleSelection((Viewer)viewer));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), HELPID);
        return editingArea;
    }

    public void dispose() {
        super.dispose();
    }

    private static final class IntermediateDataMediator
    extends DefaultValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        public IntermediateDataMediator() {
            super((IObservableValue)new LocaleObservableValue(null), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    public static final class LocaleContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IDocumentLocalizationContext) {
                IDocumentLocalizationContext context = (IDocumentLocalizationContext)inputElement;
                Collection locales = context.getAvailableLocale();
                locales.remove(Locale.ROOT);
                if (!locales.contains(Locale.getDefault())) {
                    locales.add(Locale.getDefault());
                }
                try {
                    return locales.toArray(new Locale[locales.size()]);
                }
                catch (ArrayStoreException arrayStoreException) {
                    return null;
                }
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static final class LocaleLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Locale) {
                if (Locale.getDefault().equals(element)) {
                    return String.valueOf(Locale.getDefault().getDisplayName()) + ' ' + Messages.ResourceLocaleDialogCreationAdvisor_defaultLocaleSuffix;
                }
                return ((Locale)element).getDisplayName();
            }
            return null;
        }
    }

    private static final class SelectionDataMediator
    extends DefaultDeferredValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        public SelectionDataMediator() {
            super(new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        }
    }

    private static final class UserDataMediator
    extends DefaultValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        public UserDataMediator(IObservableValue userModel) {
            super(userModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        }
    }
}

