/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.Activator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class ResourceFlatTreeContentProvider
implements ITreeContentProvider,
IResourceBundleExt.INewResourceKeyListener {
    private final Project _project;
    private StructuredViewer _viewer;

    public ResourceFlatTreeContentProvider(Project project) {
        Assert.isNotNull((Object)project);
        this._project = project;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IResourceBundleExt) {
            IResourceBundleExt bundleExt = (IResourceBundleExt)parentElement;
            ArrayList<String> keyList = new ArrayList<String>();
            Enumeration keys = bundleExt.getKeys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                keyList.add(key);
            }
            Collections.sort(keyList);
            ArrayList<ResourceBundleKeyPair> children = new ArrayList<ResourceBundleKeyPair>(keyList.size());
            for (String key : keyList) {
                children.add(new ResourceBundleKeyPair(bundleExt, key));
            }
            return children.toArray(new Object[children.size()]);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ResourceBundleKeyPair) {
            return ((ResourceBundleKeyPair)element).getBundleExt();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IResourceBundleExt) {
            return ((IResourceBundleExt)element).getKeys().hasMoreElements();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IResourceBundleExt) {
            return this.getChildren(inputElement);
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this._viewer = (StructuredViewer)viewer;
        if (oldInput != null) {
            ((IResourceBundleExt)oldInput).removeNewResourceKeyListener((IResourceBundleExt.INewResourceKeyListener)this);
        }
        if (newInput != null) {
            ((IResourceBundleExt)newInput).addNewResourceKeyListener((IResourceBundleExt.INewResourceKeyListener)this);
            this.refreshBundle((IResourceBundleExt)newInput);
        }
    }

    private void refreshBundle(IResourceBundleExt bundleExt) {
        if (bundleExt == null) {
            return;
        }
        try {
            this._project.getEclipseProject().build(10, null);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
        }
        IAppClassLoaderProvider appService = (IAppClassLoaderProvider)this._project.getAppService(IAppClassLoaderProvider.class);
        if (appService != null) {
            IAppClassLoaderProvider.IUpdateEvent updateEvent = appService.reset();
            updateEvent.waitForSignal(1000);
        }
        try {
            bundleExt.refreshResourceBundle();
        }
        catch (IllegalStateException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)e);
        }
    }

    public void newResourceKey(IResourceBundleExt.NewResourceKeyEvent event) {
        Control control;
        Object input = this._viewer.getInput();
        if (input instanceof IResourceBundleExt) {
            this.refreshBundle((IResourceBundleExt)input);
        }
        if ((control = this._viewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ResourceFlatTreeContentProvider.this._viewer.refresh(false);
                }
            });
        }
    }
}

