/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.resource.internal.Package;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBaseName;
import oracle.eclipse.tools.webtier.ui.resource.internal.Source;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class ResourceBaseNameLabelProvider
extends BaseLabelProvider
implements ILabelProvider {
    private static final String JAR_SUFFIX = ".jar";

    public Image getImage(Object element) {
        if (element instanceof Source) {
            if (((Source)element).getSourceName().endsWith(JAR_SUFFIX)) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_obj.gif");
            }
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.packagefolder_obj.gif");
        }
        if (element instanceof Package) {
            return CommonImages.createImage((ImageDescriptor)CommonImages.DESC_OBJECT_PACKAGE);
        }
        if (element instanceof ResourceBaseName) {
            return CommonImages.createImage((ImageDescriptor)CommonImages.DESC_OBJECT_FILE);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof Source) {
            return ((Source)element).getSourceName();
        }
        if (element instanceof Package) {
            String packageName = ((Package)element).getPackageName();
            return packageName.length() == 0 ? Messages.ResourceBaseNameLabelProvider_DefaultPackage_Label : packageName;
        }
        if (element instanceof ResourceBaseName) {
            return ((ResourceBaseName)element).getBaseName();
        }
        return null;
    }
}

