/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.model;

import java.util.regex.Pattern;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceDataProvider;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;

public class PaletteItem
extends PaletteEntry
implements IDropSourceDataProvider {
    private PaletteContributor _contributor;
    private final ITagDropSourceData _template;
    private String _helpId;
    private static final Pattern controlCharPattern = Pattern.compile("[\t|\r|\n|\f]+");
    private static final Pattern dblSpacesPattern = Pattern.compile("  ");

    public PaletteItem(ITagDropSourceData template, String label, String toolTipText, ImageDescriptor smallIcon, ImageDescriptor largeIcon) {
        super(label, toolTipText, smallIcon, largeIcon);
        this._template = template;
    }

    public String getToolTipText() {
        return this.replaceControlCharsWithSpace(this.getDescription());
    }

    private String replaceControlCharsWithSpace(String aString) {
        if (aString != null) {
            String temp = controlCharPattern.matcher(aString).replaceAll(" ");
            return dblSpacesPattern.matcher(temp).replaceAll(" ");
        }
        return aString;
    }

    public String getURI() {
        return this._template.getNamespace();
    }

    public String getDefaultPrefix() {
        return this._template.getDefaultPrefix();
    }

    public void setHelpId(String helpId) {
        this._helpId = helpId;
    }

    public String getHelpId() {
        return this._helpId;
    }

    public void setPaletteContributor(PaletteContributor contributor) {
        this._contributor = contributor;
    }

    public PaletteContributor getPaletteContributor() {
        return this._contributor;
    }

    public IDropSourceData getDropSourceData() {
        return this._template;
    }
}

