/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.model;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteCategoryGroup;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteItem;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteCategory {
    private String _id;
    private String _defaultPrefix;
    private PaletteCategoryGroup _group = new PaletteCategoryGroup("", 0, null);
    private String _label;
    private String _toolTip;
    private boolean _isInitiallyOpen;
    private final int _priority;
    private List<PaletteItem> _paletteItems;
    private ImageDescriptor _defaultLargeItemIcon;
    private ImageDescriptor _defaultSmallItemIcon;
    private static Comparator<PaletteItem> _labelComparator = new PaletteItemLabelComparator();
    private final String _contributorID;

    public PaletteCategory(String id, String contributorID, String defaultPrefix, String label, ImageDescriptor defaultSmallItemIcon, ImageDescriptor defaultLargeItemIcon) {
        this(id, contributorID, defaultPrefix, label, null, defaultSmallItemIcon, defaultLargeItemIcon, -1, false);
    }

    public PaletteCategory(PaletteCategory category) {
        assert (category != null);
        assert (category._id != null);
        this._id = category._id;
        this._label = category._label;
        this._toolTip = category._toolTip;
        this._defaultSmallItemIcon = category._defaultSmallItemIcon;
        this._defaultLargeItemIcon = category._defaultLargeItemIcon;
        this._isInitiallyOpen = category._isInitiallyOpen;
        this._defaultPrefix = category._defaultPrefix;
        this._paletteItems = new Vector<PaletteItem>();
        this._paletteItems.addAll(category._paletteItems);
        this._priority = category._priority;
        this._group = category._group;
        this._contributorID = category._contributorID;
    }

    private PaletteCategory(String id, String contributorID, String defaultPrefix, String label, String toolTip, ImageDescriptor defaultSmallItemIcon, ImageDescriptor defaultLargeItemIcon, int priority, boolean isInitiallyOpen) {
        assert (id != null);
        this._id = id;
        this._label = label;
        this._toolTip = toolTip;
        this._defaultSmallItemIcon = defaultSmallItemIcon;
        this._defaultLargeItemIcon = defaultLargeItemIcon;
        this._paletteItems = new Vector<PaletteItem>();
        this._isInitiallyOpen = isInitiallyOpen;
        this._defaultPrefix = defaultPrefix;
        this._priority = priority;
        this._contributorID = contributorID;
    }

    public void addAll(PaletteCategory category) {
        assert (category != null);
        this._paletteItems.addAll(category._paletteItems);
    }

    public void addPaletteItem(PaletteItem item) {
        assert (item != null);
        this._paletteItems.add(item);
    }

    public boolean equals(Object source) {
        return source instanceof PaletteCategory && this._id.equals(((PaletteCategory)source)._id);
    }

    public String getID() {
        return this._id;
    }

    public String getLabel() {
        return this._label;
    }

    public List<PaletteItem> getPaletteItems() {
        return this._paletteItems;
    }

    public PaletteCategoryGroup getGroup() {
        return this._group;
    }

    public void setPaletteCategoryGroup(PaletteCategoryGroup group) {
        this._group = group;
    }

    public int getPriority() {
        return this._priority;
    }

    public String getToolTip() {
        return this._toolTip;
    }

    public String setToolTip(String s) {
        this._toolTip = s;
        return this._toolTip;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean isInitiallyOpen() {
        return this._isInitiallyOpen;
    }

    public void setInitiallyOpen(boolean initiallyOpen) {
        this._isInitiallyOpen = initiallyOpen;
    }

    public void setLabel(String newLabel) {
        this._label = newLabel;
    }

    public ImageDescriptor getDefaultLargeItemIcon() {
        return this._defaultLargeItemIcon;
    }

    public void setDefaultLargeItemIcon(ImageDescriptor defaultLargeItemIcon) {
        this._defaultLargeItemIcon = defaultLargeItemIcon;
    }

    public ImageDescriptor getDefaultSmallItemIcon() {
        return this._defaultSmallItemIcon;
    }

    public void setDefaultSmallItemIcon(ImageDescriptor defaultSmallItemIcon) {
        this._defaultSmallItemIcon = defaultSmallItemIcon;
    }

    public void sortItems(Comparator<PaletteItem> comparator) {
        Collections.sort(this._paletteItems, comparator);
    }

    public void sortItemsByLabel() {
        this.sortItems(_labelComparator);
    }

    public void setGroup(PaletteCategoryGroup group) {
        if (group != null) {
            this._group = group;
        }
    }

    public String toString() {
        return "PaletteCategory name=" + this._label + " priority=" + this._priority;
    }

    public String getDefaultPrefix() {
        return this._defaultPrefix;
    }

    public String getContributorID() {
        return this._contributorID;
    }

    private static class PaletteItemLabelComparator
    implements Comparator<PaletteItem> {
        private static final Collator _collator = Collator.getInstance();

        private PaletteItemLabelComparator() {
        }

        @Override
        public int compare(PaletteItem item1, PaletteItem item2) {
            return _collator.compare(item1.getLabel(), item2.getLabel());
        }
    }
}

