/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewer;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.MaximizableDrawerEditPart;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.TemplateEditPart;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteEntry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.progress.UIJob;

public class PaletteViewerState {
    private static final boolean DEBUG = false;
    private static final String DEBUG_SEP = "-----------------------------------------";
    private OEPEPaletteViewer _paletteViewer;
    private List<CategoryState> _currentState = new ArrayList<CategoryState>();
    private List<DesignPaletteDrawer> _visibleCategories = new ArrayList<DesignPaletteDrawer>();
    private PaletteEntry _currentTool;
    private DesignPaletteDrawer _maximizedCategory;
    private String _cacheDesc;

    private PaletteViewerState(OEPEPaletteViewer paletteViewer) {
        this._paletteViewer = paletteViewer;
    }

    public static PaletteViewerState newInstance(OEPEPaletteViewer paletteViewer) {
        return new PaletteViewerState(paletteViewer);
    }

    public void cacheState(String desc) {
        this._cacheDesc = desc;
        this._maximizedCategory = null;
        this._currentState = new ArrayList<CategoryState>();
        this._visibleCategories = new ArrayList<DesignPaletteDrawer>();
        for (DesignPaletteDrawer drawer : this.getPaletteCategories()) {
            if (!drawer.isVisible()) continue;
            CategoryState state = new CategoryState(drawer);
            this._currentState.add(state);
            this._visibleCategories.add(drawer);
        }
        Collections.sort(this._currentState, new Comparator<CategoryState>(){

            @Override
            public int compare(CategoryState state1, CategoryState state2) {
                if (state1.isPinnedOpen() && !state2.isPinnedOpen()) {
                    return -1;
                }
                if (state2.isPinnedOpen() && !state1.isPinnedOpen()) {
                    return 1;
                }
                if (state1.isPinnedOpen() && !state2.isPinnedOpen()) {
                    return -1;
                }
                if (state2.isExpanded() && !state2.isMaximized() && !state1.isExpanded()) {
                    return 1;
                }
                if (state1.isExpanded() && !state1.isMaximized() && !state2.isExpanded()) {
                    return -1;
                }
                if (!state2.isExpanded() && state1.isMaximized()) {
                    return 1;
                }
                if (!state1.isExpanded() && state2.isMaximized()) {
                    return -1;
                }
                return 0;
            }
        });
        this.cacheSelection();
        this.debugDump(this._currentState);
    }

    private void debugDump(List<CategoryState> states) {
    }

    private List<DesignPaletteDrawer> getPaletteCategories() {
        PaletteRoot root = this._paletteViewer.getPaletteRoot();
        List entries = root.getChildren();
        ArrayList<DesignPaletteDrawer> cats = new ArrayList<DesignPaletteDrawer>();
        int i = 0;
        while (i < entries.size()) {
            PaletteEntry entry;
            if (entries.get(i) instanceof PaletteEntry && (entry = (PaletteEntry)entries.get(i)) instanceof DesignPaletteDrawer) {
                cats.add((DesignPaletteDrawer)entry);
            }
            ++i;
        }
        return cats;
    }

    public List<DesignPaletteDrawer> getVisibleCategories() {
        return this._visibleCategories;
    }

    public void restoreState() {
        if (this._cacheDesc == null) {
            return;
        }
        for (CategoryState categoryState : this._currentState) {
            categoryState.resetState();
        }
        this.restoreSelection();
        this.resetMaximizedCategory();
    }

    private void resetMaximizedCategory() {
        if (this._maximizedCategory != null) {
            new UIJob("restore max"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MaximizableDrawerEditPart editPart = (MaximizableDrawerEditPart)((Object)PaletteViewerState.this._paletteViewer.getEditPartRegistry().get(PaletteViewerState.this._maximizedCategory));
                    if (editPart != null) {
                        editPart.setMaximized(true);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void resetState() {
        this._cacheDesc = null;
        this._maximizedCategory = null;
        this._currentTool = null;
        if (this._currentState != null) {
            this._currentState.clear();
        }
        if (this._visibleCategories != null) {
            this._visibleCategories.clear();
        }
    }

    private void cacheSelection() {
        StructuredSelection ssel;
        this._currentTool = null;
        if (this._paletteViewer.getSelection() != null && (ssel = (StructuredSelection)this._paletteViewer.getSelection()).getFirstElement() instanceof TemplateEditPart) {
            TemplateEditPart part = (TemplateEditPart)((Object)ssel.getFirstElement());
            this._currentTool = (PaletteEntry)part.getModel();
        }
    }

    private void restoreSelection() {
        if (this._currentTool != null) {
            new UIJob("restore selection"){
                final PaletteEntry curTool;
                {
                    this.curTool = PaletteViewerState.this._currentTool;
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    EditPart tool;
                    if (this.curTool != null && PaletteViewerState.this._paletteViewer != null && (tool = (EditPart)PaletteViewerState.this._paletteViewer.getEditPartRegistry().get(this.curTool)) != null && tool.isSelectable() && tool.getParent() != null) {
                        PaletteViewerState.this._paletteViewer.setSelection((ISelection)new StructuredSelection((Object)tool));
                        if (((MaximizableDrawerEditPart)tool.getParent()).isExpanded()) {
                            PaletteViewerState.this._paletteViewer.reveal(tool);
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void dispose() {
        if (this._currentState != null) {
            this._currentState.clear();
            this._currentState = null;
        }
        if (this._visibleCategories != null) {
            this._visibleCategories.clear();
            this._visibleCategories = null;
        }
        this._paletteViewer = null;
        this._currentTool = null;
    }

    private class CategoryState {
        private DesignPaletteDrawer _drawer;
        private List<DesignPaletteEntry> _visibleTools;
        private boolean _isVisible = true;
        private boolean _isMaximized;
        private boolean _isExpanded;
        private boolean _isPinnedOpen;

        public CategoryState(DesignPaletteDrawer drawer) {
            this._drawer = drawer;
            this._visibleTools = new ArrayList<DesignPaletteEntry>();
            this.initialize();
        }

        private void initialize() {
            DrawerEditPart drawerEditPart = (DrawerEditPart)PaletteViewerState.this._paletteViewer.getEditPartRegistry().get(this._drawer);
            if (drawerEditPart != null) {
                this._isExpanded = drawerEditPart.isExpanded();
                this._isPinnedOpen = drawerEditPart.isPinnedOpen();
                if (drawerEditPart instanceof MaximizableDrawerEditPart) {
                    this._isMaximized = ((MaximizableDrawerEditPart)drawerEditPart).isMaximized();
                    if (this._isMaximized) {
                        PaletteViewerState.this._maximizedCategory = this._drawer;
                    }
                }
                this.cachePaletteItemsState(drawerEditPart);
            }
        }

        private void cachePaletteItemsState(DrawerEditPart drawerEditPart) {
            for (Object tool : this._drawer.getChildren()) {
                if (!(tool instanceof DesignPaletteEntry) || !((DesignPaletteEntry)tool).isVisible()) continue;
                this._visibleTools.add((DesignPaletteEntry)tool);
            }
        }

        public void resetState() {
            try {
                if (PaletteViewerState.this._paletteViewer.getControl() != null) {
                    PaletteViewerState.this._paletteViewer.getControl().setVisible(false);
                }
                this._drawer.setVisible(this._isVisible);
                DrawerEditPart drawerEditPart = (DrawerEditPart)PaletteViewerState.this._paletteViewer.getEditPartRegistry().get(this._drawer);
                if (drawerEditPart != null && drawerEditPart.isActive()) {
                    drawerEditPart.setExpanded(this._isExpanded);
                    drawerEditPart.setPinnedOpen(this._isPinnedOpen);
                    if (drawerEditPart instanceof MaximizableDrawerEditPart) {
                        ((MaximizableDrawerEditPart)drawerEditPart).setMaximized(false);
                    }
                } else if (this._isPinnedOpen) {
                    this._drawer.setInitialState(2);
                } else if (this._isExpanded) {
                    this._drawer.setInitialState(0);
                }
                this.resetPaletteItemsState();
            }
            finally {
                if (PaletteViewerState.this._paletteViewer.getControl() != null) {
                    PaletteViewerState.this._paletteViewer.getControl().setVisible(true);
                }
            }
        }

        private void resetPaletteItemsState() {
            int i = 0;
            while (i < this._drawer.getChildren().size()) {
                if (this._drawer.getChildren().get(i) instanceof DesignPaletteEntry) {
                    DesignPaletteEntry item = (DesignPaletteEntry)this._drawer.getChildren().get(i);
                    item.setVisible(this._visibleTools.contains(item));
                }
                ++i;
            }
        }

        public boolean isPinnedOpen() {
            return this._isPinnedOpen;
        }

        public boolean isExpanded() {
            return this._isExpanded;
        }

        public boolean isMaximized() {
            return this._isMaximized;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(String.valueOf(this._drawer.getCategoryModelID()) + "[ ");
            buf.append(this._isMaximized ? "maxed " : "");
            buf.append(this._isPinnedOpen ? "pinned " : "");
            buf.append(this._isExpanded ? "expanded " : "");
            buf.append(this._isVisible ? "" : "hidden ");
            buf.append("]");
            return buf.toString();
        }
    }
}

