/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webtier.ui.palette.internal.AbstractOEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.internal.IPaletteFilterListener;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizationHelper;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizer;
import oracle.eclipse.tools.webtier.ui.palette.internal.PaletteFilter;
import oracle.eclipse.tools.webtier.ui.palette.internal.PaletteViewerState;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.MaximizableDrawerEditPart;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;

public class OEPEPaletteViewer
extends DesignerPaletteViewer
implements IPaletteFilterListener {
    protected static List<String> DATA_CONTRIBUTOR_IDS = new ArrayList<String>();
    private PaletteCustomizer _customizer;
    private PaletteCustomizerDialog _customizerDialog;
    private PaletteViewerState _preMaximizeState;
    private PaletteViewerState _preMaximizeFilteredState;
    private PaletteFilter _filterUI;

    static {
        DATA_CONTRIBUTOR_IDS.add("DataControlsPalette");
        DATA_CONTRIBUTOR_IDS.add("DataControlObjectPalette");
        DATA_CONTRIBUTOR_IDS.add("DataPalette");
        DATA_CONTRIBUTOR_IDS.add("ManagedBeans");
        DATA_CONTRIBUTOR_IDS.add("PageVariables");
    }

    public void setFilterUI(PaletteFilter filter) {
        this._filterUI = filter;
        if (filter != null) {
            this._filterUI.addPaletteFilterListener(this);
        }
    }

    PaletteFilter getFilterUI() {
        return this._filterUI;
    }

    protected void hookControl() {
        super.hookControl();
    }

    protected void unhookControl() {
        super.unhookControl();
    }

    public void init() {
        super.init();
        this._preMaximizeState = PaletteViewerState.newInstance(this);
        this._preMaximizeFilteredState = PaletteViewerState.newInstance(this);
    }

    public PaletteCustomizerDialog getCustomizerDialog() {
        if (this._customizerDialog == null) {
            this._customizerDialog = OEPEPaletteCustomizationHelper.getNewCustomizerDialog((PaletteViewer)this, (OEPEPaletteCustomizer)this.getCustomizer());
        }
        ((OEPEPaletteCustomizer)this.getCustomizer()).setPaletteRoot((AbstractOEPEPaletteRoot)this.getPaletteRoot());
        return this._customizerDialog;
    }

    public PaletteCustomizer getCustomizer() {
        if (this._customizer == null) {
            this._customizer = OEPEPaletteCustomizationHelper.getNewCustomizer();
        }
        return this._customizer;
    }

    public boolean isFiltered() {
        if (this._filterUI != null) {
            return this._filterUI.isInFiltrationMode();
        }
        return false;
    }

    public MaximizableDrawerEditPart getMaximizedCategory() {
        return this.getMaximizedEditPart();
    }

    public void maximizeState(MaximizableDrawerEditPart editPartToMax) {
        if (this.isFiltered()) {
            this._preMaximizeFilteredState.cacheState("PreMaximizedFilteredState");
        } else {
            this._preMaximizeState.cacheState("PreMaximizedState");
        }
        for (Object drawer : this.getPaletteRoot().getChildren()) {
            DesignPaletteDrawer dd;
            if (!(drawer instanceof DesignPaletteDrawer) || (dd = (DesignPaletteDrawer)drawer) == editPartToMax.getModel()) continue;
            dd.setVisible(false);
        }
    }

    public void resetToMinimizeState() {
        if (this.isFiltered()) {
            this._preMaximizeFilteredState.restoreState();
        } else {
            this._preMaximizeState.restoreState();
        }
    }

    protected void handleDispose(DisposeEvent e) {
        if (this._preMaximizeState != null) {
            this._preMaximizeState.restoreState();
            this._preMaximizeState.dispose();
            this._preMaximizeState = null;
        }
        if (this._preMaximizeFilteredState != null) {
            this._preMaximizeFilteredState.dispose();
            this._preMaximizeFilteredState = null;
        }
        if (this._filterUI != null) {
            this._filterUI.removePaletteFilterListener(this);
            this._filterUI = null;
        }
        this._customizer = null;
        this._customizerDialog = null;
        super.handleDispose(e);
    }

    protected void handleFocusGained(FocusEvent fe) {
        IFigure fig = ((GraphicalEditPart)this.getFocusEditPart()).getFigure();
        if (fig != null && fig.internalGetEventDispatcher() == null) {
            return;
        }
        super.handleFocusGained(fe);
    }

    @Override
    public void filterAboutToBeApplied() {
        this.resetToMinimizeState();
    }

    @Override
    public void filterAboutToBeCleared() {
        this._preMaximizeFilteredState.resetState();
    }

    private MaximizableDrawerEditPart getMaximizedEditPart() {
        for (Object obj : this.getEditPartRegistry().values()) {
            MaximizableDrawerEditPart drawer;
            if (!(obj instanceof MaximizableDrawerEditPart) || !(drawer = (MaximizableDrawerEditPart)((Object)obj)).isMaximized()) continue;
            return drawer;
        }
        return null;
    }

    public MaximizableDrawerEditPart getDrawerEditPart(DesignPaletteDrawer drawer) {
        for (Object o : this.getEditPartRegistry().values()) {
            MaximizableDrawerEditPart drawerEditPart;
            if (!(o instanceof MaximizableDrawerEditPart) || (drawerEditPart = (MaximizableDrawerEditPart)((Object)o)).getModel() != drawer) continue;
            return drawerEditPart;
        }
        return null;
    }

    public boolean showLayout() {
        return true;
    }

    public boolean showUseLargeIcons() {
        return true;
    }

    public boolean showCustomize() {
        return !this.isFiltered();
    }

    public boolean showSettings() {
        return !this.isFiltered();
    }
}

