/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.webtier.ui.palette.internal.AbstractOEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizationHelper;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.customize.PaletteSeparatorFactory;
import org.eclipse.gef.ui.palette.customize.PaletteStackFactory;

public class OEPEPaletteCustomizer
extends PaletteCustomizer {
    private AbstractOEPEPaletteRoot root;
    private Map<String, Boolean> currentSettings;

    public void setPaletteRoot(AbstractOEPEPaletteRoot root) {
        this.root = root;
        this.cacheCurrentCustomizations();
    }

    private void cacheCurrentCustomizations() {
        this.currentSettings = new HashMap<String, Boolean>();
        int i = 1;
        while (i < this.root.getChildren().size()) {
            if (this.root.getChildren().get(i) instanceof DesignPaletteDrawer) {
                DesignPaletteDrawer drawer = (DesignPaletteDrawer)this.root.getChildren().get(i);
                this.currentSettings.put(drawer.getCategoryModelID(), drawer.isVisible());
            }
            ++i;
        }
    }

    public AbstractOEPEPaletteRoot getPaletteRoot() {
        return this.root;
    }

    public void save() {
        OEPEPaletteCustomizationHelper.save(this.root);
    }

    public void revertToSaved() {
        int i = 1;
        while (i < this.root.getChildren().size()) {
            if (this.root.getChildren().get(i) instanceof DesignPaletteDrawer) {
                DesignPaletteDrawer drawer = (DesignPaletteDrawer)this.root.getChildren().get(i);
                drawer.setVisible(this.currentSettings.get(drawer.getCategoryModelID()));
            }
            ++i;
        }
    }

    public boolean canMoveDown(PaletteEntry entry) {
        return false;
    }

    public boolean canMoveUp(PaletteEntry entry) {
        return false;
    }

    public boolean canDelete(PaletteEntry entry) {
        return false;
    }

    public List getNewEntryFactories() {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(new PaletteSeparatorFactory());
        list.add(new PaletteStackFactory());
        return list;
    }
}

