/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.palette.internal.AbstractOEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizationDialog;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteCustomizer;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteRoot;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jst.pagedesigner.utils.XMLUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class OEPEPaletteCustomizationHelper {
    private static final String PREFS_TAGLIBHIDE_PREFIX = "_hiddenCategory_:";
    private static final QualifiedName PALETTE_CUSTOMIZATIONS = new QualifiedName("oracle.eclipse.tools.webtier.ui", "_palette_");

    public static OEPEPaletteCustomizer getNewCustomizer() {
        return new OEPEPaletteCustomizer();
    }

    public static PaletteCustomizerDialog getNewCustomizerDialog(PaletteViewer paletteViewer, OEPEPaletteCustomizer paletteCustomizer) {
        OEPEPaletteCustomizationDialog dlg = new OEPEPaletteCustomizationDialog(paletteViewer.getControl().getShell(), paletteCustomizer, paletteViewer);
        return dlg;
    }

    public static void save(AbstractOEPEPaletteRoot paletteRoot) {
        IProject project = paletteRoot.getProject();
        IPersistentPreferenceStore prefs = OEPEPaletteCustomizationHelper.getPreferenceStore(project);
        if (prefs instanceof ScopedPreferenceStore) {
            IEclipsePreferences[] prefsArray;
            IEclipsePreferences[] iEclipsePreferencesArray = prefsArray = ((ScopedPreferenceStore)prefs).getPreferenceNodes(false);
            int n = prefsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName;
                Preferences parentPrefs;
                IEclipsePreferences curPrefs = iEclipsePreferencesArray[n2];
                if (curPrefs instanceof ProjectPreferences && (parentPrefs = ((ProjectPreferences)curPrefs).parent()) instanceof ProjectPreferences && !(projectName = ((ProjectPreferences)parentPrefs).name()).equals(project.getName())) {
                    prefs = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "oracle.eclipse.tools.webtier.ui");
                    try {
                        project.setSessionProperty(PALETTE_CUSTOMIZATIONS, (Object)prefs);
                    }
                    catch (CoreException cex) {
                        LoggingService.logException((String)"oracle.eclipse.tools.webtier.ui", (CoreException)cex);
                    }
                }
                ++n2;
            }
        }
        if (prefs != null) {
            for (PaletteEntry entry : paletteRoot.getChildren()) {
                if (!(entry instanceof DesignPaletteDrawer)) continue;
                DesignPaletteDrawer pd = (DesignPaletteDrawer)entry;
                prefs.setValue(PREFS_TAGLIBHIDE_PREFIX + pd.getCategoryModelID(), Boolean.toString(!pd.isVisible()));
            }
            try {
                prefs.save();
            }
            catch (IOException e) {
                LoggingService.logError((String)"oracle.eclipse.tools.webtier.ui", (String)e.getMessage());
            }
        }
    }

    public static List<DesignPaletteDrawer> loadUserCustomizations(OEPEPaletteRoot root) {
        ArrayList<DesignPaletteDrawer> newDrawers = new ArrayList<DesignPaletteDrawer>();
        IPersistentPreferenceStore prefs = OEPEPaletteCustomizationHelper.getPreferenceStore(root.getProject());
        if (prefs != null) {
            for (PaletteEntry entry : root.getChildren()) {
                if (!(entry instanceof DesignPaletteDrawer)) continue;
                DesignPaletteDrawer drawer = (DesignPaletteDrawer)entry;
                if (prefs.contains(PREFS_TAGLIBHIDE_PREFIX + drawer.getCategoryModelID())) {
                    drawer.setVisible(!prefs.getBoolean(PREFS_TAGLIBHIDE_PREFIX + drawer.getCategoryModelID()));
                    continue;
                }
                newDrawers.add(drawer);
            }
        }
        return newDrawers;
    }

    public static void hideTaglibDrawer(DesignPaletteDrawer paletteDrawer) {
        IProject project = paletteDrawer.getPaletteContributor().getFile().getProject();
        paletteDrawer.setVisible(false);
        IPersistentPreferenceStore prefs = OEPEPaletteCustomizationHelper.getPreferenceStore(project);
        if (prefs != null) {
            prefs.setValue(PREFS_TAGLIBHIDE_PREFIX + paletteDrawer.getCategoryModelID(), Boolean.TRUE.toString());
            OEPEPaletteCustomizationHelper.save((OEPEPaletteRoot)paletteDrawer.getParent());
        }
    }

    private static IPersistentPreferenceStore getPreferenceStore(IProject project) {
        IPersistentPreferenceStore store = null;
        if (project != null) {
            try {
                if (!project.getSessionProperties().containsKey(PALETTE_CUSTOMIZATIONS)) {
                    store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "oracle.eclipse.tools.webtier.ui");
                    project.setSessionProperty(PALETTE_CUSTOMIZATIONS, (Object)store);
                } else {
                    store = (IPersistentPreferenceStore)project.getSessionProperty(PALETTE_CUSTOMIZATIONS);
                }
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.ui", (CoreException)e);
            }
        }
        return store;
    }

    public static void exportCustomizations(OEPEPaletteRoot paletteRoot, String filename) {
        Document document = XMLUtil.getDocumentBuilder().getDOMImplementation().createDocument(null, "palette-item", null);
        try {
            FileOutputStream ostream = null;
            int index = filename.lastIndexOf(File.separator);
            String foldername = filename.substring(0, index);
            File folder = new File(foldername);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ostream = new FileOutputStream(filename);
            for (PaletteEntry entry : paletteRoot.getChildren()) {
                if (entry == null || !(entry instanceof DesignPaletteDrawer)) continue;
                DesignPaletteDrawer drawer = (DesignPaletteDrawer)entry;
                Element categoryElement = document.createElement("category");
                categoryElement.setAttribute("id", drawer.getCategoryModelID());
                categoryElement.setAttribute("hidden", Boolean.toString(!drawer.isVisible()));
                document.getDocumentElement().appendChild(categoryElement);
            }
            XMLUtil.serialize((Document)document, (OutputStream)ostream);
            ostream.close();
        }
        catch (IOException e) {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.ui", (String)e.getMessage());
        }
    }

    public static void importCustomizations(OEPEPaletteCustomizer customizer, String filename) {
        Element root;
        Document document = null;
        try {
            DocumentBuilder builder = XMLUtil.getDocumentBuilder();
            if (builder != null) {
                document = builder.parse(filename);
            } else {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)"DocumentBuilder not created");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)("File not found: " + filename));
        }
        catch (IOException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)("IOException:" + e.getMessage()));
        }
        catch (SAXException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)("SAXException:" + e.getMessage()));
        }
        if (document != null && (root = document.getDocumentElement()) != null) {
            NodeList catetorylist = root.getChildNodes();
            int i = 0;
            int n = catetorylist.getLength();
            while (i < n) {
                Element categoryElement;
                Node childNode = catetorylist.item(i);
                if (childNode.getNodeType() == 1 && childNode.getNodeName().equals("category") && (categoryElement = (Element)childNode).hasAttribute("hidden")) {
                    boolean isHidden = Boolean.valueOf(categoryElement.getAttribute("hidden"));
                    String uri = categoryElement.getAttribute("id");
                    OEPEPaletteCustomizationHelper.applyImport(customizer, uri, isHidden);
                }
                ++i;
            }
        }
    }

    private static void applyImport(OEPEPaletteCustomizer customizer, String uri, boolean isHidden) {
        for (Object o : customizer.getPaletteRoot().getChildren()) {
            DesignPaletteDrawer pd;
            if (!(o instanceof DesignPaletteDrawer) || !uri.equals((pd = (DesignPaletteDrawer)o).getCategoryModelID())) continue;
            pd.setVisible(!isHidden);
            break;
        }
    }
}

