/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.method;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplateStore;

public class MethodBodyCreator {
    private TemplateStore _templateStore = JavaPlugin.getDefault().getCodeTemplateStore();
    private static MethodBodyCreator INSTANCE = new MethodBodyCreator();

    public static MethodBodyCreator getInstance() {
        return INSTANCE;
    }

    private MethodBodyCreator() {
    }

    public boolean doesTemplateExist(String templateId) {
        return this._templateStore.findTemplateById(templateId) != null;
    }

    public String getMethodBody(String templateId) {
        TemplateBuffer buffer;
        block6: {
            if (this._templateStore == null) {
                return null;
            }
            Template template = this._templateStore.findTemplateById(templateId);
            if (template == null) {
                return null;
            }
            buffer = null;
            try {
                buffer = new TemplateTranslator().translate(template);
                if (buffer != null) break block6;
                return null;
            }
            catch (TemplateException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
                return null;
            }
        }
        TemplateVariable[] variables = buffer.getVariables();
        if (variables == null || variables.length == 0) {
            LoggingService.logDebug((Plugin)Activator.getDefault(), (String)Messages.bind((String)Messages.TemplateVariablesNotSupported_Error, (Object)templateId));
        }
        return buffer.getString();
    }
}

