/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.internal.wizard;

import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.NewArtificalVariableAction;
import oracle.eclipse.tools.webtier.ui.utils.TypeUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ArtificialVariableWizard
extends Wizard
implements INewWizard {
    private NewArtificialVariablePage _page;
    private NewArtificalVariableAction.ArtificialVarBean _var;
    private IObservableValue _model;
    private IProject _project;

    public ArtificialVariableWizard(NewArtificalVariableAction.ArtificialVarBean var, IProject project) {
        this._var = var;
        this._model = new WritableValue((Object)this._var, NewArtificalVariableAction.ArtificialVarBean.class);
        this._project = project;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ArtificialVariableWizard_title);
        this._page = new NewArtificialVariablePage();
        this.addPage((IWizardPage)this._page);
    }

    public boolean performFinish() {
        return true;
    }

    public boolean needsPreviousAndNextButtons() {
        return false;
    }

    private IProject getProject() {
        return this._project;
    }

    private class NewArtificialVariablePage
    extends WizardPage {
        private Text typeText;
        private Text nameText;
        private DataBindingContext _context;

        public NewArtificialVariablePage() {
            super("NewArtificialVariablePage");
            this.setTitle(Messages.ArtificialVariableWizard_pagetitle);
            this.setDescription(Messages.ArtificialVariableWizard_desc);
        }

        public void createControl(Composite parent) {
            Composite c = new Composite(parent, 0);
            GridLayout gl = new GridLayout(3, false);
            c.setLayout((Layout)gl);
            Label nameLabel = new Label(c, 0);
            nameLabel.setText(Messages.ArtificialVariableWizard_name);
            nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.nameText = new Text(c, 2048);
            GridData gd1 = new GridData(4, 0x1000000, true, false);
            gd1.horizontalSpan = 2;
            this.nameText.setLayoutData((Object)gd1);
            Label typeLabel = new Label(c, 0);
            typeLabel.setText(Messages.ArtificialVariableWizard_type);
            typeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.typeText = new Text(c, 2048);
            this.typeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button browseType = new Button(c, 8);
            browseType.setText(Messages.ArtificialVariableWizard_browse);
            browseType.setToolTipText(Messages.ArtificialVariableWizard_browseTooltip);
            browseType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            browseType.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String initialName = NewArtificialVariablePage.this.typeText.getText();
                    String typeName = TypeUtils.chooseType(ArtificialVariableWizard.this.getProject(), initialName, null, 6);
                    if (typeName == null || typeName.length() == 0) {
                        return;
                    }
                    NewArtificialVariablePage.this.typeText.setText(typeName);
                }
            });
            this.bindData();
            this.setControl((Control)c);
        }

        private void bindData() {
            this._context = new DataBindingContext();
            IObservableValue nameModel = BeansObservables.observeDetailValue((IObservableValue)ArtificialVariableWizard.this._model, (String)"name", String.class);
            IObservableValue typeModel = BeansObservables.observeDetailValue((IObservableValue)ArtificialVariableWizard.this._model, (String)"type", String.class);
            ISWTObservableValue nameControl = SWTObservables.observeText((Control)this.nameText, (int)24);
            ISWTObservableValue typeControl = SWTObservables.observeText((Control)this.typeText, (int)24);
            this._context.bindValue((IObservableValue)nameControl, nameModel, this.getNameUpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
            this._context.bindValue((IObservableValue)typeControl, typeModel, this.getTypeUpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)this._context);
        }

        private UpdateValueStrategy getNameUpdateValueStrategy() {
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setBeforeSetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    return JavaConventions.validateIdentifier((String)((String)value), (String)"1.3", (String)"1.3");
                }
            });
            return strategy;
        }

        private UpdateValueStrategy getTypeUpdateValueStrategy() {
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setBeforeSetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    String type = (String)value;
                    if (type.equals("")) {
                        return ValidationStatus.error((String)Messages.ArtificialVariableWizard_noEmptyType);
                    }
                    Project project = (Project)ArtificialVariableWizard.this.getProject().getAdapter(Project.class);
                    DataType dt = ((IDatatypeProvider)project.getAppService(IDatatypeProvider.class)).getDataType(type, null);
                    if (dt.isUnknown()) {
                        return ValidationStatus.error((String)NLS.bind((String)Messages.ArtificialVariableWizard_unknownType, (Object)type));
                    }
                    return Status.OK_STATUS;
                }
            });
            return strategy;
        }

        public void dispose() {
            this._context.dispose();
            super.dispose();
        }
    }
}

