/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableTagToolCreationAdapter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesModel;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesPaletteTreeEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTree;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTreeItem;
import oracle.eclipse.tools.webtier.ui.palette.model.TreeModelAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;

public class VariablesTreeModelAdapter
extends TreeModelAdapter {
    private VariablesModel _root;
    private ITreeContentProvider _treeContentProvider;
    private final String _namespace;
    private Comparator<DesignPaletteEntry> _comparator;
    private TreeModelAdapter.PaletteTreeFilter _paletteTreeFilter;

    public VariablesTreeModelAdapter(VariablesModel root, ITreeContentProvider treeContentProvider, ILabelProvider labelProvider, String namespace) {
        super(labelProvider);
        this._root = root;
        this._treeContentProvider = treeContentProvider;
        this._namespace = namespace;
        this._paletteTreeFilter = new TreeModelAdapter.PaletteTreeFilter(labelProvider, treeContentProvider);
    }

    @Override
    protected List<DesignPaletteEntry> getChildren(Object model) {
        ArrayList<DesignPaletteEntry> nodeList = new ArrayList<DesignPaletteEntry>();
        if (model instanceof PaletteTree) {
            Object[] children = this.doFilter(this._root, this._treeContentProvider.getChildren((Object)this._root));
            int i = 0;
            while (i < children.length) {
                PaletteTreeItem item = new PaletteTreeItem(children[i], new VariableTagToolCreationAdapter(children[i], this._namespace), this._namespace);
                item.setPaletteContributor(((PaletteTree)((Object)model)).getPaletteContributor());
                VariablesPaletteTreeEntry tool = new VariablesPaletteTreeEntry(item, ((PaletteTree)((Object)model)).getPaletteContributor(), this._namespace);
                nodeList.add(tool);
                ++i;
            }
        } else {
            VariablesPaletteTreeEntry item = (VariablesPaletteTreeEntry)model;
            Object[] children = this.doFilter(item.getModel(), this._treeContentProvider.getChildren(item.getModel()));
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Object obj = children[i];
                    VariableTagToolCreationAdapter adapter = new VariableTagToolCreationAdapter(obj, this._namespace);
                    PaletteTreeItem childItem = new PaletteTreeItem(obj, adapter, this._namespace);
                    childItem.setPaletteContributor(item.getPaletteItem().getPaletteContributor());
                    VariablesPaletteTreeEntry tool = new VariablesPaletteTreeEntry(item, childItem, item.getPaletteItem().getPaletteContributor(), this._namespace);
                    nodeList.add(tool);
                    ++i;
                }
            }
        }
        if (this._comparator != null) {
            Collections.sort(nodeList, this._comparator);
        }
        return nodeList;
    }

    @Override
    protected String getLabel(Object model) {
        if (model instanceof PaletteTree) {
            return this.getLabelProvider().getText((Object)this._root);
        }
        if (model instanceof VariablesPaletteTreeEntry) {
            VariablesPaletteTreeEntry item = (VariablesPaletteTreeEntry)model;
            return this.getLabelProvider().getText(item.getModel());
        }
        return "";
    }

    @Override
    protected Image getImage(Object model) {
        if (model instanceof PaletteTree) {
            return this.getLabelProvider().getImage((Object)this._root);
        }
        if (model instanceof VariablesPaletteTreeEntry) {
            VariablesPaletteTreeEntry item = (VariablesPaletteTreeEntry)model;
            return this.getLabelProvider().getImage(item.getModel());
        }
        return null;
    }

    @Override
    protected String getToolTipText(Object model) {
        VariablesPaletteTreeEntry item;
        if (model instanceof VariablesPaletteTreeEntry && (item = (VariablesPaletteTreeEntry)model).getModel() instanceof ValueReference) {
            ValueReference ref = (ValueReference)item.getModel();
            return ref.getDescription();
        }
        return super.getToolTipText(model);
    }

    @Override
    public Object getRoot() {
        return this._root;
    }

    @Override
    protected boolean isReadonly(Object model) {
        VariablesPaletteTreeEntry entry;
        if (model instanceof PaletteTree) {
            return true;
        }
        return model instanceof VariablesPaletteTreeEntry && (entry = (VariablesPaletteTreeEntry)model).getModel() instanceof VariableGroup;
    }

    public void setComparator(Comparator<DesignPaletteEntry> comparator) {
        this._comparator = comparator;
    }

    @Override
    public synchronized TreeModelAdapter.PaletteTreeFilter getPaletteTreeFilter() {
        return this._paletteTreeFilter;
    }
}

